# search.pl -- search interface
#
# $Id: search.pl,v 2.2 1993/06/21 04:59:35 sanders Exp $
#
# Tony Sanders <sanders@bsdi.com>, April 1993
#
# Examples:
# $map{'info'} = '&do_search($_, $query, "Info")';
#

require 'find.pl';
require "$http_sdir/grep.pl";

sub do_search {
    local($_, $query, $title) = @_;
    local(*hits, $key);
    do { &retrieve($_); return; } unless $query;
    $query =~ s/\+/\\s+/;

    local($path) = $_;
    -f $path && do { # dirname
        @path = split("/", $path); pop @path; $path = join("/", @path); };

    alarm(0);
    &find($path);

    &MIME_header('ok', 'text/html');
    print "<HEAD>\n<TITLE>Search of $title ($path): $query</TITLE>\n";
    print "</HEAD>\n<BODY>\n<H1>$title query results:</H1>\n<UL>\n";

    foreach $key (&sort_by_numeric_value(*hits)) {
	alarm($http_timeout);
	($hits, $title) = split(" ",$hits{$key},2);
        printf('<LI>score: %05d, <A HREF="/%s">%s</A>%s',
            $hits, $key, $title, "\n");
    }
    print "</UL>\n</BODY>\n";
}

sub sort_by_numeric_value {
    local(*x) = @_;
    sub _by_value { -($x{$a} <=> $x{$b}); }
    sort _by_value keys %x;
}

sub grok { $hits++; 0; }				# return 1 for speed

sub wanted {
    local($/, $i, $pos, $title, $input, $hits) = "\n";
    return unless -f $_ && (!($dir =~ m,/.hidden$,));
    return unless ($_ ne "index.html") && ($_ ne "info.html");
    return unless open(GREP, $_);
    $pos = tell(GREP);
    $hits = 0; $query =~ s,\377,.,g;			# protect delimeter
    &grep('grok', 'i', $query, *GREP) && &error('internal_error', $@);
    do { close(GREP); return; } unless $hits;
    if (/\.html$/) {		# Look for <TITLE>...</TITLE> in html files
	seek(GREP, $pos, 0);
	for ($i = 10; $i && ($input = <GREP>); $i--) {
	    last if ($title) = $input =~ m/^<title>(.*)<\/title>/i;
	}
    }
    close(GREP);
    $title = $title || $_;
    $hits{$name} = "$hits /$dir/$title";
}

1;
