#!/usr/bin/perl
# plexus.pl -- HyperText Transfer Protocol Daemon main loop
#
# $Id: plexus.pl,v 2.5 1993/07/08 00:11:41 sanders Exp $
#
# Originally by Marc VanHeyningen, March 1993
# Modified by Tony Sanders <sanders@bsdi.com>, April 1993
#
# This code forms the core of a multi-threaded HTTP deamon, with the
# primary emphasis being on responsiveness; thus, things like exec()
# and parsing are kept to a minimum when responding to requests.
#

die "plexus.pl must be called from plexus\n" unless $#ARGV == 3;

$http_config = shift;		# config file
$port = shift;			# port id (FYI only)
$running_as_root = shift;	# who started us
$s = shift;			# socket file descriptor
require "$http_config";

$ENV{'TZ'} = 'GMT';		# be network friendly

require 'ctime.pl';

# load the files in @inclist, set in $http_config
while ($_ = shift @inclist) { require $_; }

if ($running_as_root) {
    open(LOG, ">>$http_log") || die "$http_log: $!";
} else {
    open(LOG, ">/dev/tty") || die "/dev/tty: $!";
}
select(LOG); $| = 1;
print LOG "----Server #$$ on port $port started at ", &ctime(time);

$restart_daemon = 0;
$SIG{'INT'} = "cleanup";
$SIG{'QUIT'} = "restart_daemon";
$SIG{'USR1'} = "restart_daemon";
$SIG{'CHLD'} = "reaper"; 

open(S, "+>&$s") || die "reopen of socket filedescriptor failed: $!";

CONNECTION:
until ($restart_daemon) {

    # trap "interruped system call"
    eval '{ $addr = accept(NS, S) || die "accept: $!"; }';
    if ($@) {
	next CONNECTION if($@ =~ /^accept: Interrupted system call/);
	print LOG "----Server exiting: $@\n"; die "$@";
    }

    # XXX: This would be the place to add code that filters connections
    # XXX: Someone needs to make this configurable
    # $mynet = pack("bbbb", 128, 46, 0 0);        # your Class B network
    # $mymask = 0xffff0000;                       # for Class B
    # $peer_net = ((unpack($sockaddr, getpeername(NS)))[2]) & $mymask;
    # if ($peernet == $mynet && fork == 0) {...}

    # fork immediately to prevent delays
    if (fork == 0) {
	$SIG{'ALRM'} = "timeout_error"; alarm($http_timeout);
	open(STDOUT, '>& NS');
	select(STDOUT); $| = 1;
	$_ = <NS>;				# get request
	s/[ \t\r\n]*$//;			# remove trailing white-space
	&log;					# log request
	&process_input;				# DO IT!
	exit;
    }
    close(NS);					# parent "thread" keeps going
}

alarm($http_timeout);
flock(LOG, &LOCK_EX) if $running_as_root;
print LOG "----Server #$$ restarting at ", &ctime(time);
close(LOG);
alarm(0);
exec "$http_server", $http_config, $port, $running_as_root, $s;
die "$http_server: $!";  

sub restart_daemon { $restart_daemon++; }
sub reaper { while(waitpid(-1,&WNOHANG) > 0) { ; } }
sub timeout_error { &error('internal_error',
    "Server timed out after $http_timeout seconds."); }
sub cleanup { close(S); shutdown(S, 2); print STDOUT "\n\n"; exit; }
sub log {
    # log connection
    local($af, $port, $inetaddr) = unpack($sockaddr, $addr);
    local(@inetaddr) = unpack('C4', $inetaddr);
    local($ctime) = &ctime(time); chop $ctime;
    flock(LOG, &LOCK_EX) if $running_as_root;	# client logs so must lock
    printf(LOG "%-15s %s %s\n", join(".", @inetaddr), $ctime, $_);
    close(LOG);					# lock goes away
}
sub error {
    local($status, $msg) = @_;
    $status = 'internal_error' unless defined($code{$status});
    &MIME_header($status, 'text/html');		# XXX: how to avoid dups?
    print <<EOM;
<HEAD><TITLE>Server Error: $code{$status}</TITLE></HEAD>
<BODY><H1>Server Error: $code{$status}</H1>
$msg <P>
If you feel this is a server problem and wish to report it, please
include the error code, the requested URL, which and what version
browser you are using, and any other facts that might be relevant to: <P>
$http_support
</BODY>
EOM
    exit(-1);
}
sub do_restart {
    &MIME_header('ok', 'text/html');
    print NS "<HEAD>\n<TITLE>Restarting server</TITLE>\n</HEAD>\n";
    print NS "<BODY>\n<H1>Restarting server</H1>\n</BODY>\n";
    close(NS); kill 30, getppid; exit;
}
sub debug {
    local($msg) = @_;
    return unless $debug;
    # print STDERR $msg, "\n";
    open(FOO, ">>/tmp/plexus.debug");
    select((select(FOO), $| = 1)[0]);
    print FOO $msg, "\n";
    close(FOO);
}

1;
