/*   This program is just a C implementation of parts of the elisp function     */
/*   nuke-nroff-bs() found in man.el (part of the standard Emacs distribution   */
/*   i.e. it filters out all the rubbish that some brain dead implementations   */
/*        of nroff insist on generating.                                        */

#include <stdio.h>

main ()
{
	int c, next, previous ;

	previous = fgetc (stdin) ;
	while ((c = fgetc (stdin)) != EOF) {
		if (c == 8) { /* \b or ^H */
			next = fgetc (stdin) ;
			if (next == previous) {   /*   x\bx (overstrike)   */
				previous = next ;
			}
			else if (previous == '_') {   /*   _\bx  (underline)   */
				previous = next ;
			}
			else if ((previous == 'o') && (next == '+')) {   /*   o\b+  (bullet)   */
				previous = '*' ;
			}
			else if (next == '_') {   /*   \b_   (underline)   */
				previous = 0 ;
			}
			else previous = next ;
		}
		else if (c == 27) {   /*   check for ^[9 and remove   */
			next = fgetc (stdin) ;
			if (next == '9') previous = 0 ; else previous = next ;
		}
		else {
			if (previous != 0) fputc (previous, stdout) ;
			previous = c ;
		}
	}
	if (previous != 0) fputc (previous, stdout) ;
}
