######################### -*- Mode: Perl -*- #########################
##
## File          : Makefile.PL
##
## Author        : Norbert Goevert
## Created On    : Fri Oct 16 13:13:11 1998
## Last Modified : Time-stamp: <1998-12-03 15:34:24 goevert>
##
## Description   : generates Makefile for Mrequire
##
## $Id: Makefile.PL 1.2 Thu, 03 Dec 1998 15:34:32 +0100 goevert $
## $ProjectHeader: Mrequire 0.2 Thu, 03 Dec 1998 15:34:32 +0100 goevert $
##
######################################################################


use strict;

use ExtUtils::MakeMaker;
use File::Basename;


my @exe_files = grep { $_ !~ /~$/ } glob('script/*');

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile
  ( 'EXE_FILES'    => [ @exe_files ],
    'NAME'         => 'Mrequire',
    'VERSION_FROM' => 'lib/Mrequire.pm', # finds $VERSION
  );


## ###################################################################
## subs
## ###################################################################

sub MY::postamble {
  my $self = shift;

  local *postamble;

  local $_ = $self->MM::postamble;

  my @setuid;
  foreach (@exe_files) {
    if ((stat($_))[2] & 04000) {
      push @setuid, $_;
    }
  }

  return $_ unless @setuid;

  $_ .= "install ::\n";
  $_ .= "\t\@echo \n";
  $_ .= "\t\@echo '" . '#' x 70 . "'\n";
  
  foreach my $script (@setuid) {
    my $name = (fileparse($script))[0];
    $_ .= "\t\@echo '## $script is setuid " . getpwuid((stat($script))[4]) . ".'\n";
    $_ .= "\t\@echo '## To keep these settings you must change'\n";
    $_ .= "\t\@echo '## \$(INSTALLSCRIPT)/$name by hand.'\n";
    $_ .= "\t\@echo '" . '#' x 70 . "'\n";
  }

  $_ .= "\t\@echo \n";

  return $_;
}


__END__
## ###################################################################
## pod
## ###################################################################

=head1 NAME

Makefile.PL - generates Makefile for Mrequire(3)

=head1 SEE ALSO

Mrequire(3),
perl(1),
h2xs(1),
ls6h2xs(1),
ExtUtils::MakeMaker(3).

=head1 AUTHOR

Norbert Goevert E<lt>F<goevert@ls6.cs.uni-dortmund.de>E<gt>

=cut
