/*
#ident	"@(#)smail/src:RELEASE-3_2_0_116:match.h,v 1.4 2004/03/17 20:58:11 woods Exp"
 */

/*
 *    Copyright (C) 2004  Greg A. Woods
 *
 * See the file COPYING, distributed with smail, for restriction
 * and warranty information.
 *
 * Some or all of this code may also be released under a separate copyright
 * license.  Contact the author for details.
 */

/*
 * match.h:
 *	Interface file for match.c
 */

typedef struct pcre_info {
    char *re;			/* the RE, first to fool print_charplist() */
    char *msg;			/* message text */
    char *opts;			/* RE options letters */
    char delim_c;		/* RE delimiter character */
    int flags;			/* translated option letters */
    pcre *code;			/* pcre_compile() results */
    pcre_extra *hints;		/* pcre_study() results */
    int ovecsize;		/* # of int's for table of 3 int's per capture */
} pcre_info_t;

/* macros used in communicating with functions in match.c */
#define MATCH_FAIL	(-1)		/* unrecoverable failure */
#define MATCH_NOMATCH	0		/* no match was found */
#define MATCH_MATCHED	1		/* operation was successful */

/* external functions defined in match.c */
extern int match_re __P((char *, char *, unsigned int, char **, char **, char **, char **));
extern int match_re_list __P((char *, char *, unsigned int, char **));
extern int match_hostname __P((char *, char *, char **));
extern int match_pcre_list __P((char *, size_t, charplist_t *, unsigned int, char **));
extern smail_bool_t match_ip __P((char *, char *, int, int, int, char **));
extern int match_ip_net __P((char *, char *, int));
extern char *flip_inet_addr __P((char *));
extern charplist_t *compile_pcre_list __P((char *, char **));
extern void free_pcre_list __P((charplist_t *re));
extern char *format_pcre_list __P((charplist_t *re));

/* 
 * Local Variables:
 * c-file-style: "smail"
 * End:
 */
