/*
 * Copyright (c) 1992 Purdue University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Purdue University.  The name of the University may not be used
 * to endorse or promote products derived * from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Note: this copyright applies to portions of this software developed
 * at Purdue beyond the software covered by the original copyright.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include "dp.h"

void
writelog(sitename, dev, starttime, stoptime, duration)
char *sitename, *dev;
time_t starttime, stoptime;
long duration;
{
    static char	WHERE[] = "writelog";
    FILE	*F;
    long	hours;
    long	minutes;
    long	seconds;
    extern	char *ctime();

    /* Just in case... */
    if (starttime == 0)
	return;

    if ((F = fopen(CALL_LOG, "a")) == NULL) {
	d_log(DLOG_DIAG, WHERE, "Can't open call log, %m");
	return;
    }

    hours = duration / 3600;
    minutes = (duration - hours * 3600) / 60;
    seconds = duration - hours * 3600 - minutes * 60;

    (void)fprintf(F, "%-16.16s %-6.6s %-19.19s  %02ld:%02ld:%02ld   %s\n",
	sitename, dev, ctime(&stoptime), hours, minutes, seconds, progname);
    (void)fclose(F);
}
