#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sr-general.h>
#include <sr-api.h>
#include <sr-logger.h>
#include <isode/psap.h>
#ifndef __CEXTRACT__
#include "proto.h"
#endif

extern char    *gnu_gets(char *prompt, FILE * from, char *buf, int len);
extern char     gnu_getchar(char *prompt);

/*
 * Edit address to point to the System Under Test
 */

#define ADDRESS "@c=NO@o=Universitetet i Oslo@cn=bombur@cn=SR BASIC"

#define MAX_BUF 4096

#define LogError(refnr, txt) ++error,ToLog(refnr, txt)


FILE           *ASPF;
FILE           *logf = NULL;
char            instr[257];
int             inlen = 256;
char           *ASPfilename;
char           *prompt = "> ";
int             rmrefnr = 0;
int             i;
int             cnt = 0;

static char           *
int2str(int int_nmb)
{
  static char     chstr[2048];
  int             i = 0;
  int             sgn;
  int             j;
  int             mdl;
  if ((sgn = int_nmb) < 0)
    int_nmb = -int_nmb;
  do
  {
    chstr[i++] = int_nmb % 10 + '0';
  } while ((int_nmb /= 10) > 0);
  if (sgn < 0)
    chstr[i++] = '-';
  chstr[i] = '\0';
  for (i = 0, j = strlen(chstr) - 1; i < j; i++, j--)
  {
    mdl = chstr[i];
    chstr[i] = chstr[j];
    chstr[j] = mdl;
  }
  return (chstr);
}

char           *
b2str(Boolean tf)
{
  if (tf)
    return ("TRUE");
  else
    return ("FALSE");
}

Boolean
a2b(char *ch)
{
  if (!strcmp(ch, "1"))
    return (True);
  else
    return (False);
}

void
ToLog(int rmrfnr, char *intxt)
{
  if (logf)
  {
    fprintf(logf, ">Ref %d: %s\n", rmrfnr, intxt);
    fflush(logf);
  }
  printf("Ref %d: %s\n", rmrfnr, intxt);
}

void
ToLogInp(int rmrfnr, char *prompt, char *intxt)
{
  if (!logf)
    return;
  fprintf(logf, "<Ref %d: %s %s\n", rmrfnr, prompt, intxt);
  fflush(logf);
}

void
ShowRPN(RPNStructure * rpnS)
{
  if (rpnS->kind)
  {
    ShowRPN(rpnS->u.s.rpnStructure1);
    ShowRPN(rpnS->u.s.rpnStructure2);
    switch (rpnS->u.s.operator)
    {
    case 0:
      puts(" AND");
      fputs(" AND", logf);
      break;
    case 1:
      puts(" OR");
      fputs(" OR", logf);
      break;
    case 2:
      puts(" AND_NOT");
      fputs(" AND_NOT", logf);
      break;
    }
  } else
  {
    if (rpnS->u.operand->kind)
    {
      printf(" %s", rpnS->u.operand->resultSetId);
      fprintf(logf, " %s", rpnS->u.operand->resultSetId);
    } else
    {
      do
      {
	do
	{
	  printf(" %d", rpnS->u.operand->attrsPlusTerm->attributeList->attrElem->attributeType);
	  fprintf(logf, " %d", rpnS->u.operand->attrsPlusTerm->attributeList->attrElem->attributeType);
	  printf(" %d", rpnS->u.operand->attrsPlusTerm->attributeList->attrElem->attributeValue);
	  fprintf(logf, " %d", rpnS->u.operand->attrsPlusTerm->attributeList->attrElem->attributeValue);
	  rpnS->u.operand->attrsPlusTerm->attributeList =
	    rpnS->u.operand->attrsPlusTerm->attributeList->next;
	} while (rpnS->u.operand->attrsPlusTerm->attributeList != NULL);
	printf(" %s", os2str(rpnS->u.operand->attrsPlusTerm->term));
	fprintf(logf, " %s", os2str(rpnS->u.operand->attrsPlusTerm->term));
	rpnS->u.operand->attrsPlusTerm = rpnS->u.operand->attrsPlusTerm->next;
      } while (rpnS->u.operand->attrsPlusTerm != NULL);
    }
  }
}

void
CompRPN(int refnr, RPNStructure * rpn1, RPNStructure * rpn2)
{
  int error = 0;
  if (rpn1->kind == rpn2->kind)
  {
    if (rpn1->kind)
    {
      CompRPN(refnr, rpn1->u.s.rpnStructure1, rpn2->u.s.rpnStructure1);
      CompRPN(refnr, rpn1->u.s.rpnStructure2, rpn2->u.s.rpnStructure2);
      if (rpn1->u.s.operator != rpn2->u.s.operator)
	LogError(refnr, "**ERROR: RPN-operator");
    } else
    {
      if (rpn1->u.operand->kind == rpn2->u.operand->kind)
      {
	if (rpn1->u.operand->kind)
	{
	  if (strcmp(rpn1->u.operand->resultSetId, rpn2->u.operand->resultSetId))
	    LogError(refnr, "**ERROR: RPN-operand RSId");
	} else
	{
	  do
	  {
	    do
	    {
	      if (rpn1->u.operand->attrsPlusTerm->attributeList->attrElem->attributeType !=
		  rpn2->u.operand->attrsPlusTerm->attributeList->attrElem->attributeType)
		LogError(refnr, "**ERROR: RPN-operand attrtype");
	      if (rpn1->u.operand->attrsPlusTerm->attributeList->attrElem->attributeValue !=
		  rpn2->u.operand->attrsPlusTerm->attributeList->attrElem->attributeValue)
		LogError(refnr, "**ERROR: RPN-operand attrvalue");
	      rpn1->u.operand->attrsPlusTerm->attributeList =
		rpn1->u.operand->attrsPlusTerm->attributeList->next;
	      rpn2->u.operand->attrsPlusTerm->attributeList =
		rpn2->u.operand->attrsPlusTerm->attributeList->next;
	    } while (rpn1->u.operand->attrsPlusTerm->attributeList != NULL &&
		     rpn2->u.operand->attrsPlusTerm->attributeList != NULL);
	    if (strcmp(os2str(rpn1->u.operand->attrsPlusTerm->term),
		       os2str(rpn2->u.operand->attrsPlusTerm->term)))
	      LogError(refnr, "**ERROR: RPN-operand term");
	    rpn1->u.operand->attrsPlusTerm = rpn1->u.operand->attrsPlusTerm->next;
	    rpn2->u.operand->attrsPlusTerm = rpn2->u.operand->attrsPlusTerm->next;
	  } while (rpn1->u.operand->attrsPlusTerm != NULL && rpn2->u.operand->attrsPlusTerm != NULL);
	}
      } else
	LogError(refnr, "**ERROR: RPN-operand kind");
    }
  } else
    LogError(refnr, "**ERROR: RPN-kind");
  if (!error)
    ToLog(refnr, "No differences found in RPN.");
}

void
ShowSRInitReqV(int refnr, SRInitialiseRequest * req)
{
  char            buf[MAX_BUF];
  sprintf(buf, "Protocol Version: %s", int2str(req->protocolVersion));
  ToLog(refnr, buf);
  sprintf(buf, "Options: %s", int2str(req->options));
  ToLog(refnr, buf);
  sprintf(buf, "Preferred Message Size: %s", int2str(req->preferredMessageSize));
  ToLog(refnr, buf);
  sprintf(buf, "Maximum Message Size: %s", int2str(req->maximumMessageSize));
  ToLog(refnr, buf);
  sprintf(buf, "Implementation Id: %s", req->implementationId);
  ToLog(refnr, buf);
  sprintf(buf, "Implementation Name: %s", req->implementationName);
  ToLog(refnr, buf);
  sprintf(buf, "Implementation Version: %s", req->implementationVersion);
  ToLog(refnr, buf);
}

void
SRirqComp(int refnr, SRInitialiseRequest * req1, SRInitialiseRequest * req2)
{
  int error = 0;
  if (req1->protocolVersion != req2->protocolVersion)
    LogError(refnr, "**ERROR: Protocol Version");
  if (req1->options != req2->options)
    LogError(refnr, "**ERROR: Options");
  if (req1->preferredMessageSize != req2->preferredMessageSize)
    LogError(refnr, "**ERROR: Preferred Message Size");
  if (req1->maximumMessageSize != req2->maximumMessageSize)
    LogError(refnr, "**ERROR: Maximum Message Size");
  if (strcmp(req1->implementationId, req2->implementationId))
    LogError(refnr, "**ERROR: Implementation Id");
  if (strcmp(req1->implementationName, req2->implementationName))
    LogError(refnr, "**ERROR: Implementation Name");
  if (strcmp(req1->implementationVersion, req2->implementationVersion))
    LogError(refnr, "**ERROR: Implementation Version");
  if (!error)
    ToLog(refnr, "No differences found in InitialiseRequest.");
}

void
ShowSRInitRespV(int refnr, SRInitialiseResponse * rsp)
{
  char            buf[MAX_BUF];
  sprintf(buf, "Protocl Version: %s", int2str(rsp->protocolVersion));
  ToLog(refnr, buf);
  sprintf(buf, "Options: %s", int2str(rsp->options));
  ToLog(refnr, buf);
  sprintf(buf, "Preferred Message Size: %s", int2str(rsp->preferredMessageSize));
  ToLog(refnr, buf);
  sprintf(buf, "Maximum Message Size: %s", int2str(rsp->maximumMessageSize));
  ToLog(refnr, buf);
  sprintf(buf, "Initialization Status: %s", b2str(rsp->initializationStatus));
  ToLog(refnr, buf);
  sprintf(buf, "Implementation Id: %s", rsp->implementationId);
  ToLog(refnr, buf);
  sprintf(buf, "Implementation Name: %s", rsp->implementationName);
  ToLog(refnr, buf);
  sprintf(buf, "Implementation Version: %s", rsp->implementationVersion);
  ToLog(refnr, buf);
}

void
SRirpComp(int refnr, SRInitialiseResponse * rsp1, SRInitialiseResponse * rsp2)
{
  int error = 0;
  if (rsp1->protocolVersion != rsp2->protocolVersion)
    LogError(refnr, "**ERROR: Protocol Version");
  if (rsp1->options != rsp2->options)
    LogError(refnr, "**ERROR: Options");
  if (rsp1->preferredMessageSize != rsp2->preferredMessageSize)
    LogError(refnr, "**ERROR: Preferred Message Size");
  if (rsp1->maximumMessageSize != rsp2->maximumMessageSize)
    LogError(refnr, "**ERROR: Maximum Message Size");
  if (rsp1->initializationStatus != rsp2->initializationStatus)
    LogError(refnr, "**ERROR: Initialization Status");
  if (strcmp(rsp1->implementationId, rsp2->implementationId))
    LogError(refnr, "**ERROR: Implementation Id");
  if (strcmp(rsp1->implementationName, rsp2->implementationName))
    LogError(refnr, "**ERROR: Implemenation Name");
  if (strcmp(rsp1->implementationVersion, rsp2->implementationVersion))
    LogError(refnr, "**ERROR: Implementation Version");
  if(!error)
    ToLog(refnr, "No differences found in InitialiseResponse.");
}

void
ShowRecordComposition(int refnr, RecordComposition *rec)
{
  RCNameAndId *rc;
  char buf[MAX_BUF];
  
  if (rec->genericRecordComposition) {
    sprintf(buf, "GenericRecordComposition: %s", rec->u.generic);
    ToLog(refnr, buf);
    return;
  }
  ToLog(refnr, "DatabaseSpecificRecordCompositions:");
  for (rc = rec->u.databaseSpecific; rc; rc = rc->next)
  {
    sprintf(buf, "%s, %s", rc->databaseName, rc->recordCompositionId);
    ToLog(refnr, buf);
  }
}

void
CompareRecordCompositions(int refnr, RecordComposition *rec1, RecordComposition *rec2, char *what)
{
  char buf[MAX_BUF];
  RCNameAndId    *rc1, *rc2;
  int error;

  if (rec1->genericRecordComposition !=
      rec2->genericRecordComposition)
  {
    sprintf(buf, "**ERROR: %s Rec Comp's Generic Rec Comp", what);
    LogError(refnr, buf);
    return;
  }
  if (rec1->genericRecordComposition)
  {
    if (strcmp(rec1->u.generic, rec2->u.generic)) {
      sprintf(buf, "**ERROR: Generic RC %s", what);
      LogError(refnr, buf);
    }
    return;
  }
  for (rc1 = rec1->u.databaseSpecific, rc2 = rec2->u.databaseSpecific;
       rc1 && rc2; rc1 = rc1->next, rc2 = rc2->next)
  {
    if (strcmp(rc1->databaseName, rc2->databaseName))
    {
      sprintf(buf, "**ERROR: DBName %s", what);
      LogError(refnr, buf);
      return;
    }
    if (strcmp(rc1->recordCompositionId, rc2->recordCompositionId))
    {
      sprintf(buf, "**ERROR: RCid %s", what);
      LogError(refnr, buf);
      return;
    }
  }
  if (rc1 != rc2) {
    sprintf(buf, "**ERROR: # of DBNames / RCid's %s", buf);
    LogError(refnr, buf);
  }
  if (!error)
    ToLog(refnr, "No differences found in RecordComposition.");
}


void
ShowSRSearchReqV(int refnr, SRSearchRequest * req)
{
  char            buf[MAX_BUF];
  sprintf(buf, "Small Set Upper Bound: %s", int2str(req->smallSetUpperBound));
  ToLog(refnr, buf);
  sprintf(buf, "Large Set Lower Bound: %s", int2str(req->largeSetLowerBound));
  ToLog(refnr, buf);
  sprintf(buf, "Medium Set Present Number: %s", int2str(req->mediumSetPresentNumber));
  ToLog(refnr, buf);
  sprintf(buf, "Replace Indicator: %s", b2str(req->replaceIndicator));
  ToLog(refnr, buf);
  sprintf(buf, "Proposed Result Set Id: %s", req->proposedResultSetId);
  ToLog(refnr, buf);
  ToLog(refnr, "Database Id's:");
  for (i = 0; i <= (req->noDatabaseIds - 1); i++)
  {
    sprintf(buf, "  %s", req->databaseId[i]);
    ToLog(refnr, buf);
  }
  if (req->smallSetRecordComposition->genericRecordComposition)
  {
    sprintf(buf, "Generic Composition Id (small): %s", req->smallSetRecordComposition->u.generic);
    ToLog(refnr, buf);
  } else
  {
    RCNameAndId    *database_specific;
    ToLog(refnr, "Database Names with Small Set Record Composition Id's:");
    for (database_specific = req->smallSetRecordComposition->u.databaseSpecific; database_specific; database_specific = database_specific->next)
    {
      sprintf(buf, "%s, %s", database_specific->databaseName, database_specific->recordCompositionId);
      ToLog(refnr, buf);
    }
  }
  if (req->mediumSetRecordComposition->genericRecordComposition)
  {
    sprintf(buf, "Generic Composition Id (medium): %s", req->mediumSetRecordComposition->u.generic);
    ToLog(refnr, buf);
  } else
  {
    RCNameAndId    *database_specific;
    ToLog(refnr, "Database Names with Medium Set Record Composition Id's:");
    for (database_specific = req->mediumSetRecordComposition->u.databaseSpecific; database_specific; database_specific = database_specific->next)
    {
      sprintf(buf, "%s, %s", database_specific->databaseName, database_specific->recordCompositionId);
      ToLog(refnr, buf);
    }
  }
  sprintf(buf, "Preferred Record Syntax: %s", OID_Oid2name(req->preferredRecordSyntax));
  ToLog(refnr, buf);
  ToLog(refnr, "The Query:");
  if (req->query->kind == queryRpnQuery)
  {
    sprintf(buf, "Attribute Set Id: %s", OID_Oid2name(req->query->q.rpnQuery->attributeSetId));
    ToLog(refnr, buf);
    ToLog(refnr, "");
    ShowRPN(req->query->q.rpnQuery->rpnStructure);
  } else
    ToLog(refnr, os2str(req->query->q.iso8777Query));
}

void
SRsrqComp(int refnr, SRSearchRequest * req1, SRSearchRequest * req2)
{
  int error;
  if (req1->smallSetUpperBound != req2->smallSetUpperBound)
    LogError(refnr, "**ERROR: Small Set Upper Bound");
  if (req1->largeSetLowerBound != req2->largeSetLowerBound)
    LogError(refnr, "**ERROR: Large Set Lower Bound");
  if (req1->mediumSetPresentNumber != req2->mediumSetPresentNumber)
    LogError(refnr, "**ERROR: Medium Set Present Number");
  if (req1->replaceIndicator != req2->replaceIndicator)
    LogError(refnr, "**ERROR: Replace Indicator");
  if (strcmp(req1->proposedResultSetId, req2->proposedResultSetId))
    LogError(refnr, "**ERROR: Proposed Result Set Id");
  if (req1->noDatabaseIds != req2->noDatabaseIds)
    LogError(refnr, "**ERROR: # of Database Id's ");
  else
  {
    for (i = 1; i <= req1->noDatabaseIds; i++)
    {
      if (req1->databaseId[i] != req2->databaseId[i])
      {
	LogError(refnr, "**ERROR: Database Id");
	break;
      }
    }
  }
  if (req1->smallSetRecordComposition->genericRecordComposition !=
      req2->smallSetRecordComposition->genericRecordComposition)
    LogError(refnr, "**ERROR: Small Set Rec Comp's Generic Rec Comp");
  else
  {
    if (req1->smallSetRecordComposition->genericRecordComposition)
    {
      if (strcmp(req1->smallSetRecordComposition->u.generic,
		 req2->smallSetRecordComposition->u.generic))
	LogError(refnr, "**ERROR: Generic RC (smSet)");
    } else
    {
      RCNameAndId    *rc1, *rc2;
      for (rc1 = req1->smallSetRecordComposition->u.databaseSpecific,
	   rc2 = req2->smallSetRecordComposition->u.databaseSpecific;
	   rc1 && rc2; rc1 = rc1->next, rc2 = rc2->next)
      {
	if (strcmp(rc1->databaseName, rc2->databaseName))
	{
	  LogError(refnr, "**ERROR: DBName (smSet)");
	  break;
	}
	if (strcmp(rc1->recordCompositionId, rc2->recordCompositionId))
	{
	  LogError(refnr, "**ERROR: RCid (smSet)");
	  break;
	}
      }
      if (rc1 != rc2)
	LogError(refnr, "**ERROR: # of DBNames / RCid's (smSet)");
    }
  }
  if (req1->mediumSetRecordComposition->genericRecordComposition !=
      req2->mediumSetRecordComposition->genericRecordComposition)
    LogError(refnr, "**ERROR: Medium Set Rec Comp's Generic Rec Comp");
  else
  {
    if (req1->mediumSetRecordComposition->genericRecordComposition)
    {
      if (strcmp(req1->mediumSetRecordComposition->u.generic,
		 req2->mediumSetRecordComposition->u.generic))
	LogError(refnr, "**ERROR: Generic RC (medSet)");
    } else
    {
      RCNameAndId    *rc1, *rc2;
      for (rc1 = req1->mediumSetRecordComposition->u.databaseSpecific,
	   rc2 = req2->mediumSetRecordComposition->u.databaseSpecific;
	   rc1 && rc2; rc1 = rc1->next, rc2 = rc2->next)
      {
	if (strcmp(rc1->databaseName, rc2->databaseName))
	{
	  LogError(refnr, "**ERROR: DBName (medSet)");
	  break;
	}
	if (strcmp(rc1->recordCompositionId, rc2->recordCompositionId))
	{
	  LogError(refnr, "**ERROR: RCid (medSet)");
	  break;
	}
      }
      if (rc1 != rc2)
	LogError(refnr, "**ERROR: # of DBNames / RCid's (medSet)");
    }
  }
  if (OID_cmp (req1->preferredRecordSyntax, req2->preferredRecordSyntax))
    LogError(refnr, "**ERROR: Preferred Record Syntax");
  if (req1->query->kind != req2->query->kind)
    LogError(refnr, "**ERROR: Query kind");
  else
  {
    if (req1->query->kind == queryRpnQuery)
    {
      if (OID_cmp(req1->query->q.rpnQuery->attributeSetId,
		  req2->query->q.rpnQuery->attributeSetId))
	LogError(refnr, "**ERROR: RPNq - Attribute Set Id");
      CompRPN(refnr, req1->query->q.rpnQuery->rpnStructure, req2->query->q.rpnQuery->rpnStructure);
    } else
    {
      if (strcmp(os2str(req1->query->q.iso8777Query), os2str(req2->query->q.iso8777Query)))
	LogError(refnr, "**ERROR: ISO 8777 Query");
    }
  }
  if (!error)
    ToLog(refnr, "No differences found in SearchRequest.");
}

void
ShowSRSearchRespV(int refnr, SRSearchResponse * rsp)
{
  char            buf[MAX_BUF];
  sprintf(buf, "Number of Records Found: %s", int2str(rsp->numberOfRecordsFound));
  ToLog(refnr, buf);
  sprintf(buf, "Number of Records Returned: %s", int2str(rsp->numberOfRecordsReturned));
  ToLog(refnr, buf);
  sprintf(buf, "Next Result Set Position: %s", int2str(rsp->nextResultSetPosition));
  ToLog(refnr, buf);
  sprintf(buf, "Search Status: %s", b2str(rsp->searchStatus));
  ToLog(refnr, buf);
  sprintf(buf, "Result Set Status: %s", int2str(rsp->resultSetStatus));
  ToLog(refnr, buf);
  sprintf(buf, "Present Status: %s", int2str(rsp->presentStatus));
  ToLog(refnr, buf);
  sprintf(buf, "Kind of Records: %s", int2str(rsp->records->recKind));
  ToLog(refnr, buf);
  ToLog(refnr, "The Records: ");
  for (i = 1; i <= rsp->numberOfRecordsReturned; i++)
  {
    if (rsp->records->recKind == 1)
    {
      sprintf(buf, "Database Name: %s", rsp->records->u.databaseOrSurDiagnostics->databaseName);
      ToLog(refnr, buf);
      sprintf(buf, "Kind of Record: %s", int2str(rsp->records->u.databaseOrSurDiagnostics->nprKind));
      ToLog(refnr, buf);
      if (rsp->records->u.databaseOrSurDiagnostics->nprKind == 1)
      {
	/*
	 * ToLog(refnr,strcat("Direct Reference: ", OID_Oid2name(rsp->records->u.databaseOrSurDiagno
	 * stics->u.databaseRecord->directReference))) ; ToLog(refnr,strcat("Indirect Reference: ",
	 * int2str(rsp->records->u.databaseOrSurDiagno stics->u.databaserecord->indirectReference) ));
	 * ToLog(refnr,strcat("Data Value Descriptor: ", os2str(rsp->records->u.databaseOrSurDiagnos
	 * tics->u.databaseRecord->dataValueDescriptor )));
	 */
	sprintf(buf, "Extern Encoding: %s",
		int2str(rsp->records->u.databaseOrSurDiagnostics->u.databaseRecord->externEncoding));
	ToLog(refnr, buf);
	sprintf(buf, "Octetstring content:\n%s",
		os2str(rsp->records->u.databaseOrSurDiagnostics->u.databaseRecord->octStr));
	ToLog(refnr, buf);
      } else
      {
	sprintf(buf, "Diagnostic Set Id: %s",
		OID_Oid2name(rsp->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->diagnosticSetId));
	ToLog(refnr, buf);
	sprintf(buf, "Condition: %s",
		int2str(rsp->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->condition));
	ToLog(refnr, buf);
	sprintf(buf, "Additional information: %s",
		rsp->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->addinfo);
	ToLog(refnr, buf);
      }
      rsp->records->u.databaseOrSurDiagnostics = rsp->records->u.databaseOrSurDiagnostics->next;
    } else
    {
      sprintf(buf, "Diagnostic Set Id: %s",
	      OID_Oid2name(rsp->records->u.nonSurrogateDiagnostic->diagnosticSetId));
      ToLog(refnr, buf);
      sprintf(buf, "Condition: %s",
	      int2str(rsp->records->u.nonSurrogateDiagnostic->condition));
      ToLog(refnr, buf);
      sprintf(buf, "Additional information: %s",
	      rsp->records->u.nonSurrogateDiagnostic->addinfo);
      ToLog(refnr, buf);
    }
  }
}

void
SRsrpComp(int refnr, SRSearchResponse * rsp1, SRSearchResponse * rsp2)
{
  int error;
  if (rsp1->numberOfRecordsFound != rsp2->numberOfRecordsFound)
    LogError(refnr, "**ERROR: # of Records Found");
  if (rsp1->numberOfRecordsReturned != rsp2->numberOfRecordsReturned)
    LogError(refnr, "**ERROR: # of Records Returned");
  if (rsp1->nextResultSetPosition != rsp2->nextResultSetPosition)
    LogError(refnr, "**ERROR: Next Res Set Pos");
  if (rsp1->searchStatus != rsp2->searchStatus)
    LogError(refnr, "**ERROR: Search Status");
  if (rsp1->resultSetStatus != rsp2->resultSetStatus)
    LogError(refnr, "**ERROR: Result Set Status");
  if (rsp1->presentStatus != rsp2->presentStatus)
    LogError(refnr, "**ERROR: Present Status");
  if (rsp1->records->recKind != rsp2->records->recKind)
    LogError(refnr, "**ERROR: Kind of Records");
  else
  {
    if (rsp1->numberOfRecordsReturned == rsp2->numberOfRecordsReturned)
    {
      for (i = 1; i <= rsp1->numberOfRecordsReturned; i++)
      {
	if (rsp1->records->recKind == 1)
	{
	  if (strcmp(rsp1->records->u.databaseOrSurDiagnostics->databaseName,
		     rsp2->records->u.databaseOrSurDiagnostics->databaseName))
	    LogError(refnr, "**ERROR: Database Name");
	  if (rsp1->records->u.databaseOrSurDiagnostics->nprKind !=
	      rsp2->records->u.databaseOrSurDiagnostics->nprKind)
	    LogError(refnr, "**ERROR: Kind of Name Plus Record");
	  else if (rsp1->records->u.databaseOrSurDiagnostics->nprKind == 2)
	  {
	    if (OID_cmp(rsp1->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->diagnosticSetId,
			rsp2->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->diagnosticSetId))
	      LogError(refnr, "**ERROR: Diagnostic Set Id (npr)");
	    if (rsp1->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->condition !=
		rsp2->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->condition)
	      LogError(refnr, "**ERROR: Condition (npr)");
	    if (strcmp(rsp1->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->addinfo,
		       rsp2->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->addinfo))
	      LogError(refnr, "**ERROR: Additional info");
	  }
	  rsp1->records->u.databaseOrSurDiagnostics = rsp1->records->u.databaseOrSurDiagnostics->next;
	  rsp2->records->u.databaseOrSurDiagnostics = rsp2->records->u.databaseOrSurDiagnostics->next;
	} else
	{
	  if (OID_cmp(rsp1->records->u.nonSurrogateDiagnostic->diagnosticSetId,
		      rsp2->records->u.nonSurrogateDiagnostic->diagnosticSetId))
	    LogError(refnr, "**ERROR: Diagnostic Set Id (dr)");
	  if (rsp1->records->u.nonSurrogateDiagnostic->condition !=
	      rsp2->records->u.nonSurrogateDiagnostic->condition)
	    LogError(refnr, "**ERROR: Condition (dr)");
	  if (strcmp(rsp1->records->u.nonSurrogateDiagnostic->addinfo,
		     rsp2->records->u.nonSurrogateDiagnostic->addinfo))
	    LogError(refnr, "**ERROR: Additional info");
	}
      }
    }
  }
  if (!error)
    ToLog(refnr, "No differences found in SearchResponse.");
}

void
ShowSRPresentReqV(int refnr, SRPresentRequest * req)
{
  char            buf[MAX_BUF];
  sprintf(buf, "Result Set Id: %s", req->resultSetId);
  ToLog(refnr, buf);
  sprintf(buf, "Result Set Starting Point: %s", int2str(req->resultSetStartPoint));
  ToLog(refnr, buf);
  sprintf(buf, "Number Of Records Requested: %s", int2str(req->numberOfRecordsRequested));
  ToLog(refnr, buf);
  ToLog(refnr, "Record Composition:");
  ShowRecordComposition(refnr, req->recordComposition);
  sprintf(buf, "Preferred Record Syntax: %s", OID_Oid2name(req->preferredRecordSyntax));
  ToLog(refnr, buf);
}

void
SRprqComp(int refnr, SRPresentRequest * req1, SRPresentRequest * req2)
{
  int error;
  if (strcmp(req1->resultSetId, req2->resultSetId))
    LogError(refnr, "**ERROR: Result Set Id");
  if (req1->resultSetStartPoint != req2->resultSetStartPoint)
    LogError(refnr, "**ERROR: Result Set Starting Point");
  if (req1->numberOfRecordsRequested != req2->numberOfRecordsRequested)
    LogError(refnr, "**ERROR: # of Records Requested");
  CompareRecordCompositions(refnr, req1->recordComposition, req2->recordComposition, "");
  if (OID_cmp(req1->preferredRecordSyntax, req2->preferredRecordSyntax))
    LogError(refnr, "**ERROR: Preferred Record Syntax");
  if (!error)
    ToLog(refnr, "No differences found in PresentRequest.");
}

void
ShowSRPresentRespV(int refnr, SRPresentResponse * rsp)
{
  char            buf[MAX_BUF];
  sprintf(buf, "Number Of Records Returned: %s", int2str(rsp->numberOfRecordsReturned));
  ToLog(refnr, buf);
  sprintf(buf, "Next Result Set Position: %s", int2str(rsp->nextResultSetPosition));
  ToLog(refnr, buf);
  sprintf(buf, "Present Status: %s", int2str(rsp->presentStatus));
  ToLog(refnr, buf);
  sprintf(buf, "Kind of Records: %s", int2str(rsp->records->recKind));
  ToLog(refnr, buf);
  ToLog(refnr, "The Records: ");
  for (i = 1; i <= rsp->numberOfRecordsReturned; i++)
  {
    if (rsp->records->recKind == 1)
    {
      sprintf(buf, "Database Name: %s", rsp->records->u.databaseOrSurDiagnostics->databaseName);
      ToLog(refnr, buf);
      sprintf(buf, "Kind of Record: %s", int2str(rsp->records->u.databaseOrSurDiagnostics->nprKind));
      ToLog(refnr, buf);
      if (rsp->records->u.databaseOrSurDiagnostics->nprKind == 1)
      {
	/*
	 * ToLog(refnr,strcat("Direct Reference: ", OID_Oid2name(rsp->records->u.databaseOrSurDiagno
	 * stics->u.databaseRecord->directReference))) ; ToLog(refnr,strcat("Indirect Reference: ",
	 * int2str(rsp->records->u.databaseOrSurDiagno stics->u.databaseRecord->indirectReference) ));
	 * ToLog(refnr,strcat("Data Value Descriptor: ", os2str(rsp->records->u.databaseOrSurDiagnos
	 * tics->u.databaseRecord->dataValueDescriptor )));
	 */
	sprintf(buf, "Extern Encoding: %s",
		int2str(rsp->records->u.databaseOrSurDiagnostics->u.databaseRecord->externEncoding));
	ToLog(refnr, buf);
	sprintf(buf, "Octetstring content:\n%s",
		os2str(rsp->records->u.databaseOrSurDiagnostics->u.databaseRecord->octStr));
	ToLog(refnr, buf);
      } else
      {
	sprintf(buf, "Diagnostic Set Id: %s",
		OID_Oid2name(rsp->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->diagnosticSetId));
	ToLog(refnr, buf);
	sprintf(buf, "Condition: %s",
		int2str(rsp->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->condition));
	ToLog(refnr, buf);
	sprintf(buf, "Additional information: %s",
		rsp->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->addinfo);
	ToLog(refnr, buf);
      }
      rsp->records->u.databaseOrSurDiagnostics = rsp->records->u.databaseOrSurDiagnostics->next;
    } else
    {
      sprintf(buf, "Diagnostic Set Id: %s",
	      OID_Oid2name(rsp->records->u.nonSurrogateDiagnostic->diagnosticSetId));
      ToLog(refnr, buf);
      sprintf(buf, "Condition: %s",
	      int2str(rsp->records->u.nonSurrogateDiagnostic->condition));
      ToLog(refnr, buf);
      sprintf(buf, "Additional information: %s",
	      rsp->records->u.nonSurrogateDiagnostic->addinfo);
      ToLog(refnr, buf);
    }
  }
}

void
SRprpComp(int refnr, SRPresentResponse * rsp1, SRPresentResponse * rsp2)
{
  int error = 0;
  if (rsp1->numberOfRecordsReturned != rsp2->numberOfRecordsReturned)
    LogError(refnr, "**ERROR: # of Records Returned");
  if (rsp1->nextResultSetPosition != rsp2->nextResultSetPosition)
    LogError(refnr, "**ERROR: Next Result Set Position");
  if (rsp1->presentStatus != rsp2->presentStatus)
    LogError(refnr, "**ERROR: Present Status");
  if (rsp1->numberOfRecordsReturned == rsp2->numberOfRecordsReturned)
  {
    for (i = 1; i <= rsp1->numberOfRecordsReturned; i++)
    {
      if (rsp1->records->recKind == 1)
      {
	if (strcmp(rsp1->records->u.databaseOrSurDiagnostics->databaseName,
		   rsp2->records->u.databaseOrSurDiagnostics->databaseName))
	  LogError(refnr, "**ERROR: Database Name");
	if (rsp1->records->u.databaseOrSurDiagnostics->nprKind !=
	    rsp2->records->u.databaseOrSurDiagnostics->nprKind)
	  LogError(refnr, "**ERROR: Kind of Name Plus Record");
	else if (rsp1->records->u.databaseOrSurDiagnostics->nprKind == 2)
	{
	  if (OID_cmp(rsp1->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->diagnosticSetId,
		     rsp2->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->diagnosticSetId))
	    LogError(refnr, "**ERROR: Diagnostic Set Id (npr)");
	  if (rsp1->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->condition !=
	      rsp2->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->condition)
	    LogError(refnr, "**ERROR: Condition (npr)");
	  if (strcmp(rsp1->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->addinfo,
		     rsp2->records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->addinfo))
	    LogError(refnr, "**ERROR: Additional info");
	}
	rsp1->records->u.databaseOrSurDiagnostics = rsp1->records->u.databaseOrSurDiagnostics->next;
	rsp2->records->u.databaseOrSurDiagnostics = rsp2->records->u.databaseOrSurDiagnostics->next;
      } else
      {
	if (OID_cmp(rsp1->records->u.nonSurrogateDiagnostic->diagnosticSetId,
		    rsp2->records->u.nonSurrogateDiagnostic->diagnosticSetId))
	  LogError(refnr, "**ERROR: Diagnostic Set Id (dr)");
	if (rsp1->records->u.nonSurrogateDiagnostic->condition !=
	    rsp2->records->u.nonSurrogateDiagnostic->condition)
	  LogError(refnr, "**ERROR: Condition (dr)");
	if (strcmp(rsp1->records->u.nonSurrogateDiagnostic->addinfo,
		   rsp2->records->u.nonSurrogateDiagnostic->addinfo))
	  LogError(refnr, "**ERROR: Additional info");
      }
    }
  }
  if (!error)
    ToLog(refnr, "No differences found in PresentResponse.");
}

void
ShowSRDelResSetReqV(int refnr, SRDeleteResultSetRequest * req)
{
  char            buf[MAX_BUF];
  sprintf(buf, "Delete Set Function: %s", int2str(req->deleteSetFunction));
  ToLog(refnr, buf);
  ToLog(refnr, "Result Set List:");
  while (req->resultSetList != NULL)
  {
    ToLog(refnr, req->resultSetList->resultSetId);
    req->resultSetList = req->resultSetList->next;
  }
}

void
SRdrqComp(int refnr, SRDeleteResultSetRequest * req1, SRDeleteResultSetRequest * req2)
{
  int error = 0;
  if (req1->deleteSetFunction != req2->deleteSetFunction)
    LogError(refnr, "**ERROR: Delete Set Function");
  while ((req1->resultSetList != NULL) && (req2->resultSetList != NULL))
  {
    if (strcmp(req1->resultSetList->resultSetId, req2->resultSetList->resultSetId))
    {
      LogError(refnr, "**ERROR: Result Set Id");
      break;
    }
    req1->resultSetList = req1->resultSetList->next;
    req2->resultSetList = req2->resultSetList->next;
  }
  if (!error)
    ToLog(refnr, "No differences found in DeleteResultSetRequest.");
}

void
ShowSRDelResSetRespV(int refnr, SRDeleteResultSetResponse * rsp)
{
  char            buf[MAX_BUF];
  sprintf(buf, "Delete Operation Status: %s", int2str(rsp->deleteOperationStatus));
  ToLog(refnr, buf);
  ToLog(refnr, "Delete List Statuses (RSid + DelSetStatus):");
  while (rsp->deleteListStatuses != NULL)
  {
    sprintf(buf, "%s %s", rsp->deleteListStatuses->resultSetId, int2str(rsp->deleteListStatuses->deleteSetStatus));
    ToLog(refnr, buf);
    rsp->deleteListStatuses = rsp->deleteListStatuses->next;
  }
  sprintf(buf, "Number not Deleted: %s", int2str(rsp->numberNotDeleted));
  ToLog(refnr, buf);
  ToLog(refnr, "Bulk Statuses (RSid + DelSetStatus):");
  while (rsp->bulkStatuses != NULL)
  {
    sprintf(buf, "%s %s", rsp->bulkStatuses->resultSetId, int2str(rsp->bulkStatuses->deleteSetStatus));
    ToLog(refnr, buf);
    rsp->bulkStatuses = rsp->bulkStatuses->next;
  }
  ToLog(refnr, "Delete Message:");
  ToLog(refnr, rsp->deleteMessage);
}

void
SRdrpComp(int refnr, SRDeleteResultSetResponse * rsp1, SRDeleteResultSetResponse * rsp2)
{
  int error = 0;
  if (rsp1->deleteOperationStatus != rsp2->deleteOperationStatus)
    LogError(refnr, "**ERROR: Delete Operation Status");
  while ((rsp1->deleteListStatuses != NULL) && (rsp2->deleteListStatuses != NULL))
  {
    if (strcmp(rsp1->deleteListStatuses->resultSetId, rsp2->deleteListStatuses->resultSetId))
    {
      LogError(refnr, "**ERROR: Result Set Id");
      break;
    }
    if (rsp1->deleteListStatuses->deleteSetStatus != rsp2->deleteListStatuses->deleteSetStatus)
    {
      LogError(refnr, "**ERROR: Delete Set Status");
      break;
    }
    rsp1->deleteListStatuses = rsp1->deleteListStatuses->next;
    rsp2->deleteListStatuses = rsp2->deleteListStatuses->next;
  }
  while ((rsp1->bulkStatuses != NULL) && (rsp2->bulkStatuses != NULL))
  {
    if (strcmp(rsp1->bulkStatuses->resultSetId, rsp2->bulkStatuses->resultSetId))
    {
      LogError(refnr, "**ERROR: Result Set Id");
      break;
    }
    if (rsp1->bulkStatuses->deleteSetStatus != rsp2->bulkStatuses->deleteSetStatus)
    {
      LogError(refnr, "**ERROR: Delete Set Status");
      break;
    }
    rsp1->bulkStatuses = rsp1->bulkStatuses->next;
    rsp2->bulkStatuses = rsp2->bulkStatuses->next;
  }
  if (strcmp(rsp1->deleteMessage, rsp2->deleteMessage))
    LogError(refnr, "**ERROR: Delete Message");
  if (!error)
    ToLog(refnr, "No differences found in DeleteResultSetResponse.");
}

SRInitialiseRequest *
GetSRInitReqValuesM()
{
  static SRInitialiseRequest req;
  req.protocolVersion = atoi(gnu_gets("ProtocolVersion: ", stdin, instr, inlen));
  req.options = atoi(gnu_gets("Options: ", stdin, instr, inlen));
  req.preferredMessageSize = atoi(gnu_gets("Preferred Message Size: ", stdin, instr, inlen));
  req.maximumMessageSize = atoi(gnu_gets("Maximum Message Size: ", stdin, instr, inlen));
  req.authentication = (Authentication *) NULL;
  gnu_gets("Implementation Id: ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.implementationId = strdup("");
  else
    req.implementationId = strdup(instr);
  gnu_gets("Implementation Name: ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.implementationName = strdup("");
  else
    req.implementationName = strdup(instr);
  gnu_gets("Implementation Version: ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.implementationVersion = strdup("");
  else
    req.implementationVersion = strdup(instr);
  /* printf("User Information Field: "); */
  req.userInformationField = (EXTERN *) NULL;
  return (&req);
}

SRInitialiseRequest *
GetSRInitReqValuesA(char *fnm)
{
  static SRInitialiseRequest req;
  if ((ASPF = fopen(fnm, "rt")) == NULL)
  {
    ToLog(rmrefnr, "NO SRInitReq value file opened!");
    return ((SRInitialiseRequest *) NULL);
  } else
  {
    req.protocolVersion = atoi(fgets(instr, 80, ASPF));
    req.options = atoi(fgets(instr, 80, ASPF));
    req.preferredMessageSize = atoi(fgets(instr, 80, ASPF));
    req.maximumMessageSize = atoi(fgets(instr, 80, ASPF));
    req.authentication = (Authentication *) NULL;
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit",4))
      req.implementationId = strdup("");
    else
      req.implementationId = strdup(instr);
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.implementationName = strdup("");
    else
      req.implementationName = strdup(instr);
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.implementationVersion = strdup("");
    else
      req.implementationVersion = strdup(instr);
    req.userInformationField = (EXTERN *) NULL;
    fclose(ASPF);
    return (&req);
  }
}

SRInitialiseResponse *
GetSRInitRespValuesM()
{
  static SRInitialiseResponse req;
  req.protocolVersion = atoi(gnu_gets("ProtocolVersion: ", stdin, instr, inlen));
  req.options = atoi(gnu_gets("Options: ", stdin, instr, inlen));
  req.preferredMessageSize = atoi(gnu_gets("Preferred Message Size: ", stdin, instr, inlen));
  req.maximumMessageSize = atoi(gnu_gets("Maximum Message Size: ", stdin, instr, inlen));
  req.initializationStatus = a2b(gnu_gets("Initialisation Status: ", stdin, instr, inlen));
  gnu_gets("Implementation Id: ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.implementationId = strdup("");
  else
    req.implementationId = strdup(instr);
  gnu_gets("Implementation Name: ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.implementationName = strdup("");
  else
    req.implementationName = strdup(instr);
  gnu_gets("Implementation Version: ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.implementationVersion = strdup("");
  else
    req.implementationVersion = strdup(instr);
  /* printf("User Information Field: "); */
  req.userInformationField = (EXTERN *) NULL;
  return (&req);
}


SRInitialiseResponse *
GetSRInitRespValuesA(char *fnm)
{
  static SRInitialiseResponse req;
  if ((ASPF = fopen(fnm, "rt")) == NULL)
  {
    ToLog(rmrefnr, "NO SRInitResp value file opened!");
    return ((SRInitialiseResponse *) NULL);
  } else
  {
    req.protocolVersion = atoi(fgets(instr, 80, ASPF));
    req.options = atoi(fgets(instr, 80, ASPF));
    req.preferredMessageSize = atoi(fgets(instr, 80, ASPF));
    req.maximumMessageSize = atoi(fgets(instr, 80, ASPF));
    req.initializationStatus = a2b(fgets(instr, 80, ASPF));
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.implementationId = strdup("");
    else
      req.implementationId = strdup(instr);
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.implementationName = strdup("");
    else
      req.implementationName = strdup(instr);
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.implementationVersion = strdup("");
    else
      req.implementationVersion = strdup(instr);
    req.userInformationField = (EXTERN *) NULL;
    fclose(ASPF);
    return (&req);
  }
}

RCNameAndId *
ReadDatabaseSpecificRecordCompositions(char *name) {
  char buf[MAX_BUF];
  RCNameAndId *ret = (RCNameAndId *) NULL, *cur, *last = (RCNameAndId *) NULL;
  char yn;

  do
  {
    cur = (RCNameAndId *) malloc(sizeof(RCNameAndId));
    cur->databaseName = strdup(gnu_gets("Database Name: ", stdin, instr, inlen));
    sprintf(buf, "%sRecordCompositionId: ", name);
    cur->recordCompositionId = strdup(gnu_gets(buf, stdin, instr, inlen));
    cur->next = (RCNameAndId *) NULL;
    if (last)
      last->next = cur;
    else
      ret = cur;
    last = cur;
    yn = gnu_getchar("More base / Id info (y/n)? ");
  } while (yn == 'y' || yn == 'Y');
  return ret;
}

SRSearchRequest *
GetSRSrchReqValuesM()
{
  char            qt;
  char            yn2;
  char            yn3;
  static SRSearchRequest req;
  req.smallSetUpperBound = atoi(gnu_gets("Small Set Upper Bound: ", stdin, instr, inlen));
  req.largeSetLowerBound = atoi(gnu_gets("Large Set Lower Bound: ", stdin, instr, inlen));
  req.mediumSetPresentNumber = atoi(gnu_gets("Medium Set Present Number: ", stdin, instr, inlen));
  req.replaceIndicator = a2b(gnu_gets("Replace Indicator: ", stdin, instr, inlen));
  req.proposedResultSetId = strdup(gnu_gets("Proposed Result Set Id: ", stdin, instr, inlen));
  cnt = 0;
  req.databaseId = (char **) malloc(sizeof(char **) * 1);
  do
  {
    req.databaseId = (char **) realloc(req.databaseId, sizeof(char **) * (1 + cnt));
    req.databaseId[cnt] = strdup(gnu_gets("Database Id's: ", stdin, instr, inlen));
    cnt += 1;
    yn2 = gnu_getchar("More (y/n)? ");
  } while (yn2 == 'Y' || yn2 == 'y');
  req.noDatabaseIds = cnt;
  cnt = 0;
  printf("Small Set Record Composition:\n");
  gnu_gets("  Generic (y/n)? ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.smallSetRecordComposition = (RecordComposition *) NULL;
  else
  {
    req.smallSetRecordComposition = (RecordComposition *) malloc(sizeof(RecordComposition));
    if (!strcmp(instr, "y") || !strcmp(instr, "Y"))
    {
      req.smallSetRecordComposition->genericRecordComposition = True;
      req.smallSetRecordComposition->u.generic = strdup(gnu_gets("Composition Id: ", stdin, instr, inlen));
    } else
    {
      req.smallSetRecordComposition->genericRecordComposition = False;
      req.smallSetRecordComposition->u.databaseSpecific = ReadDatabaseSpecificRecordCompositions("Small Set ");
#if 0
      cnt = 0;
      do
      {
	req.smallSetRecordComposition->u.s.databaseName[cnt] = strdup(gnu_gets("Database Name: ", stdin, instr, inlen));
	printf("Small Set Record Composition Id: ");
	req.smallSetRecordComposition->u.s.recordCompositionId[cnt] = strdup(gnu_gets("Small Set Record Composition Id: ", stdin, instr, inlen));
	yn3 = gnu_getchar("More base / Id info (y/n)? ");
	cnt += 1;
      } while (yn3 == 'y' || yn3 == 'Y');
      req.smallSetRecordComposition->u.s.no = cnt;
#endif
    }
  }
  printf("Medium Set Record Composition:\n ");
  gnu_gets("  Generic (y/n)? ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.mediumSetRecordComposition = (RecordComposition *) NULL;
  else
  {
    req.mediumSetRecordComposition = (RecordComposition *) malloc(sizeof(RecordComposition));
    if (!strcmp(instr, "y") || !strcmp(instr, "Y"))
    {
      req.mediumSetRecordComposition->genericRecordComposition = True;
      printf("Generic composition Id:");
      req.mediumSetRecordComposition->u.generic = strdup(gnu_gets("Generic composition Id: ", stdin, instr, inlen));
    } else
    {
      req.mediumSetRecordComposition->genericRecordComposition = False;
      req.mediumSetRecordComposition->u.databaseSpecific = ReadDatabaseSpecificRecordCompositions("Medium Set ");
    }
  }
  gnu_gets("Preferred Record Syntax: ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.preferredRecordSyntax = OID_str2Oid("");
  else
    req.preferredRecordSyntax = OID_str2Oid(instr);
  req.query = (Query *) malloc(sizeof(Query));
  qt = gnu_getchar("Query type (<R>pn / <I>so8777): ");
  if (qt == 'r' || qt == 'R')
  {
    char *rpnbuf;
    req.query->kind = queryRpnQuery;
    req.query->q.rpnQuery = (RPNQuery *) malloc(sizeof(RPNQuery));
    req.query->q.rpnQuery->attributeSetId = OID_str2Oid(gnu_gets("Attribute Set Id: ", stdin, instr, inlen));
    rpnbuf = gnu_gets("The Query: ", stdin, instr, inlen);
    setInpStr(rpnbuf);
    req.query->q.rpnQuery->rpnStructure = parseRPN(getToken());
  } else
  {
    req.query->kind = queryIso8777Query;
    req.query->q.iso8777Query = str2os(gnu_gets("The Query: ", stdin, instr, inlen));
  }
  return (&req);
}

SRSearchRequest *
GetSRSrchReqValuesA(char *fnm)
{
  static SRSearchRequest req;
  if ((ASPF = fopen(fnm, "rt")) == NULL)
  {
    ToLog(rmrefnr, "NO SRSrchReq values file opened");
    return ((SRSearchRequest *) NULL);
  } else
  {
    req.smallSetUpperBound = atoi(fgets(instr, 80, ASPF));
    req.largeSetLowerBound = atoi(fgets(instr, 80, ASPF));
    req.mediumSetPresentNumber = atoi(fgets(instr, 80, ASPF));
    req.replaceIndicator = a2b(fgets(instr, 80, ASPF));
    fgets(req.proposedResultSetId, 80, ASPF);
    req.noDatabaseIds = atoi(fgets(instr, 80, ASPF));
    for (i = 0; i <= req.noDatabaseIds; i++)
      fgets(req.databaseId[i], 80, ASPF);
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.smallSetRecordComposition = (RecordComposition *) NULL;
    else
    {
      req.smallSetRecordComposition = (RecordComposition *) malloc(sizeof(RecordComposition));
      req.smallSetRecordComposition->genericRecordComposition = a2b(instr);
      if (atoi(instr) == 1)
	fgets(req.smallSetRecordComposition->u.generic, 80, ASPF);
      else
      {
#if 0				/* Laterfix: is now linked list */
	req.smallSetRecordComposition->u.s.no = atoi(fgets(instr, 80, ASPF));
	for (i = 0; i <= req.smallSetRecordComposition->u.s.no; i++)
	{
	  fgets(req.smallSetRecordComposition->u.s.databaseName[i], 80, ASPF);
	  fgets(req.smallSetRecordComposition->u.s.recordCompositionId[i], 80, ASPF);
	}
#endif
      }
    }
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.mediumSetRecordComposition = (RecordComposition *) NULL;
    else
    {
      req.mediumSetRecordComposition = (RecordComposition *) malloc(sizeof(RecordComposition));
      req.mediumSetRecordComposition->genericRecordComposition = a2b(instr);
      if (atoi(instr) == 1)
	fgets(req.mediumSetRecordComposition->u.generic, 80, ASPF);
      else
      {
#if 0				/* Laterfix: is now linked list */
	req.mediumSetRecordComposition->u.s.no = atoi(fgets(instr, 80, ASPF));
	for (i = 0; i <= req.mediumSetRecordComposition->u.s.no; i++)
	{
	  fgets(req.mediumSetRecordComposition->u.s.databaseName[i], 80, ASPF);
	  fgets(req.mediumSetRecordComposition->u.s.recordCompositionId[i], 80, ASPF);
	}
#endif
      }
    }
    fgets(instr, 80, ASPF);
    if (strncmp(instr, "omit", 4))
      req.preferredRecordSyntax = OID_str2Oid(instr);
    req.query = (Query *) malloc(sizeof(Query));
    req.query->kind = atoi(fgets(instr, 80, ASPF));
    if (req.query->kind == 1)
    {
      char *rpnbuf;
      req.query->q.rpnQuery = (RPNQuery *) malloc(sizeof(RPNQuery));
      req.query->q.rpnQuery->attributeSetId = OID_str2Oid(fgets(instr, 80, ASPF));
      rpnbuf = gnu_gets("The Query: ", stdin, instr, inlen);
      setInpStr(rpnbuf);
      req.query->q.rpnQuery->rpnStructure = parseRPN(getToken());
    } else
      req.query->q.iso8777Query = str2os(fgets(instr, 80, ASPF));
    fclose(ASPF);
    return (&req);
  }
}


SRSearchResponse *
GetSRSrchRespValuesM()
{
  char            nrt;
  char            yn1;
  static SRSearchResponse req;
  req.numberOfRecordsFound = atoi(gnu_gets("Number Of Records Found: ", stdin, instr, inlen));
  req.numberOfRecordsReturned = atoi(gnu_gets("Number Of Records Returned: ", stdin, instr, inlen));
  req.nextResultSetPosition = atoi(gnu_gets("Next Result Set Position: ", stdin, instr, inlen));
  req.searchStatus = a2b(gnu_gets("Search Status: ", stdin, instr, inlen));
  gnu_gets("Result Set Status: ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.resultSetStatus = 0;
  else
    req.resultSetStatus = atoi(instr);
  gnu_gets("Present Status: ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.presentStatus = 0;
  else
    req.presentStatus = atoi(instr);
  gnu_gets("Kind of Records (<N>PR / <D>iagRec)? ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.records = (Records *) NULL;
  else
  {
    req.records = (Records *) malloc(sizeof(Records));
    if (!strcmp(instr, "N") || !strcmp(instr, "n"))
    {
      req.records->recKind = recNamePlusRecord;
      do
      {
	req.records->u.databaseOrSurDiagnostics->databaseName = strdup(gnu_gets("Database name: ", stdin, instr, inlen));
	nrt = gnu_getchar(" Kind of NPR (npr<R>ec / npr<D>iag)? ");
	if (nrt == 'R' || nrt == 'r')
	{
	  req.records->u.databaseOrSurDiagnostics->nprKind = nprRecord;
	  req.records->u.databaseOrSurDiagnostics->u.databaseRecord = (EXTERN *) malloc(sizeof(EXTERN));
	  /*
	   * printf("Direct Reference: "); req->records->u.databaseOrSurDiagno stics->u.databaseRecord->directRefe
	   * rence = OID_str2Oid(gnu_gets(prompt,stdin,instr,inlen)); printf("Indirect Reference: ");
	   * req->records->u.databaseOrSurDiagno stics->u.databaseRecord->indirectRe ference =
	   * atoi(gnu_gets(prompt,stdin,instr,inlen)); printf("Data Value Descriptor:");
	   * req->records->u.databaseOrSurDiagno stics->u.databaseRecord->dataValueD escriptor =
	   * str2os(gnu_gets(prompt,stdin,instr,inlen));
	   */
	  req.records->u.databaseOrSurDiagnostics->u.databaseRecord->externEncoding =
	    atoi(gnu_gets("Extern Encoding: ", stdin, instr, inlen));
	  req.records->u.databaseOrSurDiagnostics->u.databaseRecord->octStr =
	    str2os(gnu_gets("The record: ", stdin, instr, inlen));
	} else
	{
	  req.records->u.databaseOrSurDiagnostics->nprKind = nprDiag;
	  req.records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic = (DiagRec *) malloc(sizeof(DiagRec));
	  req.records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->diagnosticSetId =
	    OID_str2Oid(gnu_gets("Diagnostic Set Id: ", stdin, instr, inlen));
	  req.records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->condition =
	    atoi(gnu_gets("Condition: ", stdin, instr, inlen));
	  req.records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->addinfo = strdup(gnu_gets("Additonal information:", stdin, instr, inlen));
	}
	yn1 = gnu_getchar("More Records (y/n) ? ");
	if (yn1 == 'y' || yn1 == 'Y')
	  req.records->u.databaseOrSurDiagnostics = req.records->u.databaseOrSurDiagnostics->next;
      } while (yn1 == 'y' || yn1 == 'Y');
      req.records->u.databaseOrSurDiagnostics->next = NULL;
    } else
    {
      req.records->recKind = recDiagRec;
      req.records->u.nonSurrogateDiagnostic = (DiagRec *) malloc(sizeof(DiagRec));
      req.records->u.nonSurrogateDiagnostic->diagnosticSetId = OID_str2Oid(gnu_gets("Diagnostic Set Id: ", stdin, instr, inlen));
      req.records->u.nonSurrogateDiagnostic->condition = atoi(gnu_gets("Condition: ", stdin, instr, inlen));
      req.records->u.nonSurrogateDiagnostic->addinfo = strdup(gnu_gets("Additional information: ", stdin, instr, inlen));
    }
  }
  return (&req);
}


SRSearchResponse *
GetSRSrchRespValuesA(char *fnm)
{
  static SRSearchResponse req;
  if ((ASPF = fopen(fnm, "rt")) == NULL)
  {
    ToLog(rmrefnr, "NO SRSrchResp value file opened!");
    return ((SRSearchResponse *) NULL);
  } else
  {
    req.numberOfRecordsFound = atoi(fgets(instr, 80, ASPF));
    req.numberOfRecordsReturned = atoi(fgets(instr, 80, ASPF));
    req.nextResultSetPosition = atoi(fgets(instr, 80, ASPF));
    req.searchStatus = a2b(fgets(instr, 80, ASPF));
    fgets(instr, 0, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.resultSetStatus = 0;
    else
      req.resultSetStatus = atoi(instr);
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.presentStatus = 0;
    else
      req.presentStatus = atoi(instr);
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.records = (Records *) NULL;
    else
    {
      req.records = (Records *) malloc(sizeof(Records));
      req.records->recKind = atoi(instr);
      if (req.records->recKind == 1)
      {
	for (i = 1; i <= req.numberOfRecordsReturned; i++)
	{
	  fgets(req.records->u.databaseOrSurDiagnostics->databaseName, 80, ASPF);
	  req.records->u.databaseOrSurDiagnostics->nprKind = atoi(fgets(instr, 80, ASPF));
	  if (req.records->u.databaseOrSurDiagnostics->nprKind == 1)
	  {
	    req.records->u.databaseOrSurDiagnostics->u.databaseRecord = (EXTERN *) malloc(sizeof(EXTERN));
	    /*
	     * req->records->u.databaseOrS urDiagnostics->u.databaseRe cord->directReference =
	     * OID_str2Oid(fgets(instr,80,ASPF )); req->records->u.databaseOrS urDiagnostics->u.databaseRe
	     * cord->indirectReference = atoi(fgets(instr,80,ASPF));
	     * 
	     * req->records->u.databaseOrSu rDiagnostics->u.databaseRec ord->dataValueDescriptor =
	     * str2os(fgets(instr,80,ASPF) );
	     */
	    req.records->u.databaseOrSurDiagnostics->u.databaseRecord->externEncoding =
	      atoi(fgets(instr, 80, ASPF));
	    req.records->u.databaseOrSurDiagnostics->u.databaseRecord->octStr =
	      str2os(fgets(instr, 80, ASPF));
	  } else
	  {
	    req.records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic = (DiagRec *) malloc(sizeof(DiagRec));
	    req.records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->diagnosticSetId =
	      OID_str2Oid(fgets(instr, 80, ASPF));
	    req.records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->condition =
	      atoi(fgets(instr, 80, ASPF));
	    req.records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->addinfo = strdup(gnu_gets("> ", stdin, instr, inlen));
	  }
	  req.records->u.databaseOrSurDiagnostics = req.records->u.databaseOrSurDiagnostics->next;
	}
	req.records->u.databaseOrSurDiagnostics->next = NULL;
      } else
      {
	req.records->u.nonSurrogateDiagnostic = (DiagRec *) malloc(sizeof(DiagRec));
	req.records->u.nonSurrogateDiagnostic->diagnosticSetId = OID_str2Oid(fgets(instr, 80, ASPF));
	req.records->u.nonSurrogateDiagnostic->condition = atoi(fgets(instr, 80, ASPF));
	fgets(req.records->u.nonSurrogateDiagnostic->addinfo, 80, ASPF);
      }
    }
    fclose(ASPF);
    return (&req);
  }
}
SRPresentRequest *
GetSRPresReqValuesM()
{
  static SRPresentRequest req;
  req.resultSetId = strdup(gnu_gets("Result Set Id: ", stdin, instr, inlen));
  req.resultSetStartPoint = atoi(gnu_gets("Result Set Starting Point: ", stdin, instr, inlen));
  req.numberOfRecordsRequested = atoi(gnu_gets("Number Of Records Requested: ", stdin, instr, inlen));
  printf("Record Composition: ");
  gnu_gets("  Generic (y/n)? ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.recordComposition = (RecordComposition *) NULL;
  else
  {
    req.recordComposition = (RecordComposition *) malloc(sizeof(RecordComposition));
    if (!strcmp(instr, "y") || !strcmp(instr, "Y"))
    {
      req.recordComposition->genericRecordComposition = True;
      req.recordComposition->u.generic = strdup(gnu_gets("Generic Composition Id: ", stdin, instr, inlen));
    } else
    {
      req.recordComposition->genericRecordComposition = False;
      req.recordComposition->u.databaseSpecific = ReadDatabaseSpecificRecordCompositions("");
    }
  }
  gnu_gets("Preferred Record Syntax: ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.preferredRecordSyntax = OID_NULLPTR;
  else
    req.preferredRecordSyntax = OID_str2Oid(instr);
  return (&req);
}

SRPresentRequest *
GetSRPresReqValuesA(char *fnm)
{
  static SRPresentRequest req;
  if ((ASPF = fopen(fnm, "rt")) == NULL)
  {
    ToLog(rmrefnr, "NO SRPresReq value file read!");
    return ((SRPresentRequest *) NULL);
  } else
  {
    fgets(req.resultSetId, 80, ASPF);
    req.resultSetStartPoint = atoi(fgets(instr, 80, ASPF));
    req.numberOfRecordsRequested = atoi(fgets(instr, 80, ASPF));
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.recordComposition = (RecordComposition *) NULL;
    else
    {
      req.recordComposition = (RecordComposition *) malloc(sizeof(RecordComposition));
      req.recordComposition->genericRecordComposition = a2b(instr);
      if (atoi(instr) == 1)
	fgets(req.recordComposition->u.generic, 80, ASPF);
      else
      {
#if 0				/* Laterfix: is now linked list */
	req.recordComposition->u.s.no = atoi(fgets(instr, 80, ASPF));
	for (i = 0; i <= req.recordComposition->u.s.no; i++)
	{
	  fgets(req.recordComposition->u.s.databaseName[i], 80, ASPF);
	  fgets(req.recordComposition->u.s.recordCompositionId[i], 80, ASPF);
	}
#endif
      }
    }
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.preferredRecordSyntax = OID_NULLPTR;
    else
      req.preferredRecordSyntax = OID_str2Oid(instr);
    fclose(ASPF);
    return (&req);
  }
}

SRPresentResponse *
GetSRPresRspValuesM()
{
  static SRPresentResponse req;
  char            yn1;
  char            nrt;
  req.numberOfRecordsReturned = atoi(gnu_gets("Number Of Records Returned: ", stdin, instr, inlen));
  req.nextResultSetPosition = atoi(gnu_gets("Next Result Set Position: ", stdin, instr, inlen));
  req.presentStatus = atoi(gnu_gets("Present Status: ", stdin, instr, inlen));
  gnu_gets("Kind of Records (<N>PR / <D>iagRec)? ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.records = (Records *) NULL;
  else
  {
    req.records = (Records *) malloc(sizeof(Records));
    if (!strcmp(instr, "N") || !strcmp(instr, "n"))
    {
      req.records->recKind = recNamePlusRecord;
      do
      {
	req.records->u.databaseOrSurDiagnostics->databaseName = strdup(gnu_gets("Database name: ", stdin, instr, inlen));
	nrt = gnu_getchar(" Kind of NPR (npr<R>ec / npr<D>iag)? ");
	if (nrt == 'R' || nrt == 'r')
	{
	  req.records->u.databaseOrSurDiagnostics->nprKind = nprRecord;
	  req.records->u.databaseOrSurDiagnostics->u.databaseRecord = (EXTERN *) malloc(sizeof(EXTERN));
	  /*
	   * printf("Direct Reference: "); req->records->u.databaseOrSurDiagno stics->u.databaseRecord->directRefe
	   * rence = OID_str2Oid(gnu_gets(prompt,stdin,instr,inlen)); printf("Indirect Reference: ");
	   * req->records->u.databaseOrSurDiagno stics->u.databaseRecord->indirectRe ference =
	   * atoi(gnu_gets(prompt,stdin,instr,inlen)); printf("Data Value Descriptor:");
	   * req->records->u.databaseOrSurDiagno stics->u.databaseRecord->dataValueD escriptor =
	   * str2os(gnu_gets(prompt,stdin,instr,inlen));
	   */
	  req.records->u.databaseOrSurDiagnostics->u.databaseRecord->externEncoding =
	    atoi(gnu_gets("Extern Encoding: ", stdin, instr, inlen));
	  req.records->u.databaseOrSurDiagnostics->u.databaseRecord->octStr =
	    str2os(gnu_gets("The record: ", stdin, instr, inlen));
	} else
	{
	  req.records->u.databaseOrSurDiagnostics->nprKind = nprDiag;
	  req.records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic = (DiagRec *) malloc(sizeof(DiagRec));
	  req.records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->diagnosticSetId =
	    OID_str2Oid(gnu_gets("Diagnostic Set ID: ", stdin, instr, inlen));
	  req.records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->condition =
	    atoi(gnu_gets("Condition: ", stdin, instr, inlen));
	  req.records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->addinfo = strdup(gnu_gets("Additional information: ", stdin, instr, inlen));
	}
	yn1 = gnu_getchar("More Records (y/n) ? ");
	if (yn1 == 'y' || yn1 == 'Y')
	  req.records->u.databaseOrSurDiagnostics = req.records->u.databaseOrSurDiagnostics->next;
      } while (yn1 == 'y' || yn1 == 'Y');
      req.records->u.databaseOrSurDiagnostics->next = NULL;
    } else
    {
      req.records->recKind = recDiagRec;
      req.records->u.nonSurrogateDiagnostic = (DiagRec *) malloc(sizeof(DiagRec));
      req.records->u.nonSurrogateDiagnostic->diagnosticSetId = OID_str2Oid(gnu_gets("Diagnostic Set Id: ", stdin, instr, inlen));
      req.records->u.nonSurrogateDiagnostic->condition = atoi(gnu_gets("Condition: ", stdin, instr, inlen));
      req.records->u.nonSurrogateDiagnostic->addinfo = strdup(gnu_gets("Additional information: ", stdin, instr, inlen));
    }
  }
  return (&req);
}

SRPresentResponse *
GetSRPresRspValuesA(char *fnm)
{
  static SRPresentResponse req;
  if ((ASPF = fopen(fnm, "rt")) == NULL)
  {
    ToLog(rmrefnr, "NO SRPresResp value file read!");
    return ((SRPresentResponse *) NULL);
  } else
  {
    req.numberOfRecordsReturned = atoi(fgets(instr, 80, ASPF));
    req.nextResultSetPosition = atoi(fgets(instr, 80, ASPF));
    req.presentStatus = atoi(fgets(instr, 80, ASPF));
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.records = (Records *) NULL;
    else
    {
      req.records = (Records *) malloc(sizeof(Records));
      req.records->recKind = atoi(instr);
      if (req.records->recKind == 1)
      {
	for (i = 1; i <= req.numberOfRecordsReturned; i++)
	{
	  fgets(req.records->u.databaseOrSurDiagnostics->databaseName, 80, ASPF);
	  req.records->u.databaseOrSurDiagnostics->nprKind = atoi(fgets(instr, 80, ASPF));
	  if (req.records->u.databaseOrSurDiagnostics->nprKind == 1)
	  {
	    req.records->u.databaseOrSurDiagnostics->u.databaseRecord = (EXTERN *) malloc(sizeof(EXTERN));
	    /*
	     * req->records->u.databaseOrS urDiagnostics->u.databaseRe cord->directReference =
	     * OID_str2Oid(fgets(instr,80,ASPF )); req->records->u.databaseOrS urDiagnostics->u.databaseRe
	     * cord->indirectReference = atoi(fgets(instr,80,ASPF));
	     * 
	     * req->records->u.databaseOrSu rDiagnostics->u.databaseRec ord->dataValueDescriptor =
	     * str2os(fgets(instr,80,ASPF) );
	     */
	    req.records->u.databaseOrSurDiagnostics->u.databaseRecord->externEncoding =
	      atoi(fgets(instr, 80, ASPF));
	    req.records->u.databaseOrSurDiagnostics->u.databaseRecord->octStr =
	      str2os(fgets(instr, 80, ASPF));
	  } else
	  {
	    req.records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic = (DiagRec *) malloc(sizeof(DiagRec));
	    req.records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->diagnosticSetId =
	      OID_str2Oid(fgets(instr, 80, ASPF));
	    req.records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->condition =
	      atoi(fgets(instr, 80, ASPF));
	    req.records->u.databaseOrSurDiagnostics->u.surrogateDiagnostic->addinfo = strdup(gnu_gets("> ", stdin, instr, inlen));
	  }
	  req.records->u.databaseOrSurDiagnostics = req.records->u.databaseOrSurDiagnostics->next;
	}
	req.records->u.databaseOrSurDiagnostics->next = NULL;
      } else
      {
	req.records->u.nonSurrogateDiagnostic = (DiagRec *) malloc(sizeof(DiagRec));
	req.records->u.nonSurrogateDiagnostic->diagnosticSetId = OID_str2Oid(fgets(instr, 80, ASPF));
	req.records->u.nonSurrogateDiagnostic->condition = atoi(fgets(instr, 80, ASPF));
	fgets(req.records->u.nonSurrogateDiagnostic->addinfo, 80, ASPF);
      }
    }
    fclose(ASPF);
    return (&req);
  }
}

SRDeleteResultSetRequest *
GetSRDelRSReqValuesM()
{
  char            yn1;
  static SRDeleteResultSetRequest req;
  req.deleteSetFunction = atoi(gnu_gets("Delete Result Set Function: ", stdin, instr, inlen));
  gnu_gets("Result Set Id: ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.resultSetList = (ResultSetList *) NULL;
  else
  {
    do
    {
      req.resultSetList = (ResultSetList *) malloc(sizeof(ResultSetList));
      req.resultSetList->resultSetId = strdup(instr);
      yn1 = gnu_getchar("More Id's (y/n)? ");
      if (yn1 == 'y' || yn1 == 'Y')
      {
	req.resultSetList = req.resultSetList->next;
	gnu_gets("Result set id: ", stdin, instr, inlen);
      }
    } while (yn1 == 'y' || yn1 == 'Y');
    req.resultSetList->next = NULL;
  }
  return (&req);
}


SRDeleteResultSetRequest *
GetSRDelRSReqValuesA(char *fnm)
{
  static SRDeleteResultSetRequest req;
  int             i;
  if ((ASPF = fopen(fnm, "rt")) == NULL)
  {
    ToLog(rmrefnr, "NO SRDelResSetReq value file read!");
    return ((SRDeleteResultSetRequest *) NULL);
  } else
  {
    req.deleteSetFunction = atoi(fgets(instr, 80, ASPF));
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.resultSetList = (ResultSetList *) NULL;
    else
    {
      cnt = atoi(instr);
      for (i = 1; i <= cnt; i++)
      {
	req.resultSetList = (ResultSetList *) malloc(sizeof(ResultSetList));
	fgets(req.resultSetList->resultSetId, 80, ASPF);
	if (i < cnt)
	  req.resultSetList = req.resultSetList->next;
      }
      req.resultSetList->next = NULL;
    }
    fclose(ASPF);
    return (&req);
  }
}

SRDeleteResultSetResponse *
GetSRDelRSRspValuesM()
{
  static SRDeleteResultSetResponse req;
  char            yn1;
  req.deleteOperationStatus = atoi(gnu_gets("Delete Operation Status: ", stdin, instr, inlen));
  printf("Delete List Status:\n");
  gnu_gets("Result Set Id: ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.deleteListStatuses = (ListStatuses *) NULL;
  else
  {
    do
    {
      req.deleteListStatuses = (ListStatuses *) malloc(sizeof(ListStatuses));
      req.deleteListStatuses->resultSetId = strdup(instr);
      req.deleteListStatuses->deleteSetStatus = atoi(gnu_gets("Delete Set Status: ", stdin, instr, inlen));
      yn1 = gnu_getchar("More Set / Status info (y/n)? ");
      if (yn1 == 'y' || yn1 == 'Y')
      {
	req.deleteListStatuses = req.deleteListStatuses->next;
	gnu_gets("Result Set Id: ", stdin, instr, inlen);
      }
    } while (yn1 == 'y' || yn1 == 'Y');
    req.deleteListStatuses->next = NULL;
  }
  gnu_gets("Number of Sets Not Deleted: ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.numberNotDeleted = 0;
  else
    req.numberNotDeleted = atoi(instr);
  printf("Bulk Delete List Status:\n");
  gnu_gets("Result Set Id: ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.bulkStatuses = (ListStatuses *) NULL;
  else
  {
    do
    {
      req.bulkStatuses = (ListStatuses *) malloc(sizeof(ListStatuses));
      req.bulkStatuses->resultSetId = strdup(instr);
      req.bulkStatuses->deleteSetStatus = atoi(gnu_gets("Delete Set Status: ", stdin, instr, inlen));
      yn1 = gnu_getchar("More Set / Status info (y/n)? ");
      if (yn1 == 'y' || yn1 == 'Y')
      {
	req.bulkStatuses = req.bulkStatuses->next;
	gnu_gets("Result Set Id: ", stdin, instr, inlen);
      }
    } while (yn1 == 'y' || yn1 == 'Y');
    req.bulkStatuses->next = NULL;
  }
  gnu_gets("Delete Message: ", stdin, instr, inlen);
  if (!strncmp(instr, "omit", 4))
    req.deleteMessage = strdup("");
  else
    req.deleteMessage = strdup(instr);
  return (&req);
}

SRDeleteResultSetResponse *
GetSRDelRSRspValuesA(char *fnm)
{
  static SRDeleteResultSetResponse req;
  int             i;
  if ((ASPF = fopen(fnm, "rt")) == NULL)
  {
    ToLog(rmrefnr, "NO SRDelResSetResp value file read!");
    return ((SRDeleteResultSetResponse *) NULL);
  } else
  {
    req.deleteOperationStatus = atoi(fgets(instr, 80, ASPF));
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.deleteListStatuses = (ListStatuses *) NULL;
    else
    {
      cnt = atoi(instr);
      for (i = 1; i <= cnt; i++)
      {
	req.deleteListStatuses = (ListStatuses *) malloc(sizeof(ListStatuses));
	fgets(req.deleteListStatuses->resultSetId, 80, ASPF);
	req.deleteListStatuses->deleteSetStatus = atoi(fgets(instr, 80, ASPF));
	if (i < cnt)
	  req.deleteListStatuses = req.deleteListStatuses->next;
      }
      req.deleteListStatuses->next = NULL;
    }
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.numberNotDeleted = 0;
    else
      req.numberNotDeleted = atoi(instr);
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.bulkStatuses = (ListStatuses *) NULL;
    else
    {
      cnt = atoi(instr);
      for (i = 1; i <= cnt; i++)
      {
	req.bulkStatuses = (ListStatuses *) malloc(sizeof(ListStatuses));
	fgets(req.bulkStatuses->resultSetId, 80, ASPF);
	req.bulkStatuses->deleteSetStatus = atoi(fgets(instr, 80, ASPF));
	if (i < cnt)
	  req.bulkStatuses = req.bulkStatuses->next;
      }
      req.bulkStatuses->next = NULL;
    }
    fgets(instr, 80, ASPF);
    if (!strncmp(instr, "omit", 4))
      req.deleteMessage = strdup("");
    else
      req.deleteMessage = strdup(instr);
    fclose(ASPF);
    return (&req);
  }
}

SRCloseResponse *
GetSRCloseRespM()
{
  static SRCloseResponse req;
  char            yn1;
  yn1 = gnu_getchar("Close accepted (y/n) ?");
  if (yn1 == 'y' || yn1 == 'Y')
    req.closeAccepted = True;
  else
    req.closeAccepted = False;
  return (&req);
}

SRCloseResponse *
GetSRCloseRespA(char *fnm)
{
  static SRCloseResponse req;
  if ((ASPF = fopen(fnm, "rt")) == NULL)
  {
    ToLog(rmrefnr, "NO SRCloseResp value file read!");
    return ((SRCloseResponse *) NULL);
  } else
  {
    req.closeAccepted = atoi(fgets(instr, 80, ASPF));
    fclose(ASPF);
    return (&req);
  }
}

Boolean
SendASP_O(int refnr)
{
  SRCloseRequest *clreq;
  char           *choice;
  int             ASPno;
  char            pve;
  Boolean         NotOK = False;
  clreq = (SRCloseRequest *) NULL;
  printf("ASP to send:\n");
  printf("1) Initialize request\n");
  printf("2) Search Request\n");
  printf("3) Present Request\n");
  printf("4) Delete Result Set Request\n");
  printf("5) Close Request\n");
  printf("6) Abort\n");
  choice = gnu_gets("Action on #: ", stdin, instr, inlen);
  ASPno = atoi(choice);
  pve = gnu_getchar("<M>anual / <A>utomatic parameter value entry? ");
  if (pve == 'a' || pve == 'A')
  {
    pve = 'a';
    ASPfilename = gnu_gets("Filename for ASP values: ", stdin, instr, inlen);
  }
  switch (ASPno)
  {
  case 1:
    if (pve != 'a')
    {
      if (!SR_SendInitialiseRequest(refnr, GetSRInitReqValuesM()))
      {
	ToLog(refnr, "Initialize Request not sent");
	NotOK = True;
      } else
	ToLog(refnr, "InitReq sent");
    } else
    {
      if (!SR_SendInitialiseRequest(refnr,
				    GetSRInitReqValuesA(ASPfilename)))
      {
	ToLog(refnr, "Initialize Request not sent");
	NotOK = True;
      } else
	ToLog(refnr, "InitReq sent");
    }
    break;
  case 2:
    if (pve != 'a')
    {
      if (!SR_SendSearchRequest(refnr, GetSRSrchReqValuesM()))
      {
	ToLog(refnr, "Search Request not sent");
	NotOK = True;
      } else
	ToLog(refnr, "SrchReq sent");
    } else
    {
      if (!SR_SendSearchRequest(refnr,
				GetSRSrchReqValuesA(ASPfilename)))
      {
	ToLog(refnr, "Search Request not sent");
	NotOK = True;
      } else
	ToLog(refnr, "SrchReq sent");
    }
    break;
  case 3:
    if (pve != 'a')
    {
      if (!SR_SendPresentRequest(refnr, GetSRPresReqValuesM()))
      {
	ToLog(refnr, "Present Request not sent");
	NotOK = True;
      } else
	ToLog(refnr, "PresReq sent");
    } else
    {
      if (!SR_SendPresentRequest(refnr,
				 GetSRPresReqValuesA(ASPfilename)))
      {
	ToLog(refnr, "Present Request not sent");
	NotOK = True;
      } else
	ToLog(refnr, "PresReq sent");
    }
    break;
  case 4:
    if (pve != 'a')
    {
      if (!SR_SendDeleteResultSetRequest(refnr,
					 GetSRDelRSReqValuesM()))
      {
	ToLog(refnr, "Delete Result Set Request not sent");
	NotOK = True;
      } else
	ToLog(refnr, "DelResSetReq sent");
    } else
    {
      if (!SR_SendDeleteResultSetRequest(refnr,
					 GetSRDelRSReqValuesA(ASPfilename)))
      {
	ToLog(refnr, "Delete Result Set Request not sent");
	NotOK = True;
      } else
	ToLog(refnr, "DelResSetReq sent");
    }
    break;
  case 5:
    if (!SR_SendCloseRequest(refnr, clreq))
    {
      ToLog(refnr, "Close Request not sent");
      NotOK = True;
    } else
      ToLog(refnr, "CloseReq sent");
    break;
  case 6:
    if (!SR_AbortAssociation(refnr))
      ToLog(refnr, "Abort NOT sent");
    else
      ToLog(refnr, "Abort sent");
    NotOK = True;
    break;
  }
  return (!NotOK);
}

Boolean
RecASP_O(int refnr)
{
  SRInitialiseResponse *sirp;
  SRInitialiseResponse *sirp2;
  SRSearchResponse *ssrp;
  SRSearchResponse *ssrp2;
  SRPresentResponse *sprp;
  SRPresentResponse *sprp2;
  SRDeleteResultSetResponse *sdrp;
  SRDeleteResultSetResponse *sdrp2;
  SRCloseResponse *scrp;
  SRCloseResponse *scrp2;
  SROperation     SROpr;
  char            yn1;
  Boolean         NotOK = False;
  int             foo;


  ToLog(refnr, "Polling Network ...");
  foo = (-1);
  SROpr = SR_PollNetwork(0, 0, 0, 0, 0, &foo);	/* SETT INN RIKTIGE VERDIER!!! */
  switch (SROpr)
  {
  case oprInitialiseResponse:
    if (!(sirp = SR_ReadInitialiseResponse(refnr)))
    {
      ToLog(refnr, "Initialize Confirm NOT received / recognized");
      NotOK = True;
    } else
    {
      ToLog(refnr, "Initialize Confirm received / recognized");
      ToLog(refnr, "Initialize Confirm ASP values:");
      ShowSRInitRespV(refnr, sirp);
      yn1 = gnu_getchar("Compare to ASPfile (y/n)? ");
      if (yn1 == 'y' || yn1 == 'Y')
      {
	ASPfilename = strdup(gnu_gets("Filename: ", stdin, instr, inlen));
	sirp2 = GetSRInitRespValuesA(ASPfilename);
	SRirpComp(refnr, sirp, sirp2);
      }
    }
    break;
  case oprSearchResponse:
    if (!(ssrp = SR_ReadSearchResponse(refnr)))
    {
      ToLog(refnr, "Search Confirm NOT received / recognized");
      NotOK = True;
    } else
    {
      ToLog(refnr, "Search Confirm received / recognized");
      ToLog(refnr, "Search Confirm ASP values:");
      ShowSRSearchRespV(refnr, ssrp);
      yn1 = gnu_getchar("Compare to ASPfile (y/n)? ");
      if (yn1 == 'y' || yn1 == 'Y')
      {
	ASPfilename = strdup(gnu_gets("Filename: ", stdin, instr, inlen));
	ssrp2 = GetSRSrchRespValuesA(ASPfilename);
	SRsrpComp(refnr, ssrp, ssrp2);
      }
    }
    break;
  case oprPresentResponse:
    if (!(sprp = SR_ReadPresentResponse(refnr)))
    {
      ToLog(refnr, "Present Confirm NOT received / recognized");
      NotOK = True;
    } else
    {
      ToLog(refnr, "Present Confirm received / recognized");
      ToLog(refnr, "Present Confirm ASP values:");
      ShowSRPresentRespV(refnr, sprp);
      yn1 = gnu_getchar("Compare to ASPfile (y/n)? ");
      if (yn1 == 'y' || yn1 == 'Y')
      {
	ASPfilename = strdup(gnu_gets("Filename: ", stdin, instr, inlen));
	sprp2 = GetSRPresRspValuesA(ASPfilename);
	SRprpComp(refnr, sprp, sprp2);
      }
    }
    break;
  case oprDeleteResultSetResponse:
    if (!(sdrp = SR_ReadDeleteResultSetResponse(refnr)))
    {
      ToLog(refnr, "Delete Result Set Confirm NOT received / recognized");
      NotOK = True;
    } else
    {
      ToLog(refnr, "Delete Result Set Confirm received / recognized");
      ToLog(refnr, "Delete Result Set Confirm ASP values:");
      ShowSRDelResSetRespV(refnr, sdrp);
      yn1 = gnu_getchar("Compare to ASPfile (y/n)? ");
      if (yn1 == 'y' || yn1 == 'Y')
      {
	ASPfilename = strdup(gnu_gets("Filename: ", stdin, instr, inlen));
	sdrp2 = GetSRDelRSRspValuesA(ASPfilename);
	SRdrpComp(refnr, sdrp, sdrp2);
      }
    }
    break;
  case oprCloseResponse:
    if (!(scrp = SR_ReadCloseResponse(refnr)))
      ToLog(refnr, "Close Confirm NOT received / recognized");
    else
    {
      char            buf[MAX_BUF];
      ToLog(refnr, "Close Confirm received");
      ToLog(refnr, "Close Confirm ASP values:");
      sprintf(buf, "Close Accepted = %s", b2str(scrp->closeAccepted));
      ToLog(refnr, buf);
      yn1 = gnu_getchar("Compare to ASPfile (y/n)? ");
      if (yn1 == 'y' || yn1 == 'Y')
      {
	ASPfilename = strdup(gnu_gets("Filename: ", stdin, instr, inlen));
	scrp2 = GetSRCloseRespA(ASPfilename);
	if (scrp2->closeAccepted != scrp->closeAccepted)
	  ToLog(refnr, "**ERROR: Close Accept");
      }
    }
    NotOK = True;
    break;
  case oprAbort:
    ToLog(refnr, "Abort received");
    NotOK = True;
    break;
  case oprNone:
    ToLog(refnr, "Nothing received");
    NotOK = True;
    break;
  default:
    ToLog(refnr, "Unrecognized message received from network / SRPM");
    NotOK = True;
    break;
  }
  return (!NotOK);
}

Boolean
SendASP_T(int refnr)
{
  int             ASPno;
  char            pve;
  Boolean         NotOK = False;
  char           *choice;
  printf("ASP to send:\n");
  printf("1) Initialize response\n");
  printf("2) Search Response\n");
  printf("3) Present Response\n");
  printf("4) Delete Result Set Response\n");
  printf("5) Close Response\n");
  printf("6) Abort\n");
  choice = gnu_gets("Action on #: ", stdin, instr, inlen);
  ASPno = atoi(choice);
  pve = gnu_getchar("<M>anual / <A>utomatic parameter value entry?");
  if (pve == 'a' || pve == 'A')
  {
    pve = 'a';
    ASPfilename = strdup(gnu_gets("Filename: ", stdin, instr, inlen));
  }
  switch (ASPno)
  {
  case 1:
    if (pve != 'a')
    {
      if (!SR_SendInitialiseResponse(refnr, GetSRInitRespValuesM()))
      {
	ToLog(refnr, "Initialize Response NOT sent");
	NotOK = True;
      } else
	ToLog(refnr, "Initialize Response sent");
    } else
    {
      if (!SR_SendInitialiseResponse(refnr,
				     GetSRInitRespValuesA(ASPfilename)))
      {
	ToLog(refnr, "Initialize Response NOT sent");
	NotOK = True;
      } else
	ToLog(refnr, "Initialize Response sent");
    }
    break;
  case 2:
    if (pve != 'a')
    {
      if (!SR_SendSearchResponse(refnr, GetSRSrchRespValuesM()))
      {
	ToLog(refnr, "Search Response NOT sent");
	NotOK = True;
      } else
	ToLog(refnr, "Search Response sent");
    } else
    {
      if (!SR_SendSearchResponse(refnr,
				 GetSRSrchRespValuesA(ASPfilename)))
      {
	ToLog(refnr, "Search Response NOT sent");
	NotOK = True;
      } else
	ToLog(refnr, "Search Response sent");
    }
    break;
  case 3:
    if (pve != 'a')
    {
      if (!SR_SendPresentResponse(refnr, GetSRPresRspValuesM()))
      {
	ToLog(refnr, "Present Request NOT sent");
	NotOK = True;
      } else
	ToLog(refnr, "Present Response sent");
    } else
    {
      if (!SR_SendPresentResponse(refnr,
				  GetSRPresRspValuesA(ASPfilename)))
      {
	ToLog(refnr, "Present Response NOT sent");
	NotOK = True;
      } else
	ToLog(refnr, "Present Response sent");
    }
    break;
  case 4:
    if (pve != 'a')
    {
      if (!SR_SendDeleteResultSetResponse(refnr,
					  GetSRDelRSRspValuesM()))
      {
	ToLog(refnr, "Delete Result Set Response NOT sent");
	NotOK = True;
      } else
	ToLog(refnr, "Delete Result Set Response sent");
    } else
    {
      if (!SR_SendDeleteResultSetResponse(refnr,
					  GetSRDelRSRspValuesA(ASPfilename)))
      {
	ToLog(refnr, "Delete Result Set Response NOT sent");
	NotOK = True;
      } else
	ToLog(refnr, "Delete Result Set Response sent");
    }
    break;
  case 5:
    if (pve != 'a')
    {
      if (!SR_SendCloseResponse(refnr, GetSRCloseRespM()))
	ToLog(refnr, "Close Response NOT sent");
      else
	ToLog(refnr, "Close Response sent");
    } else
    {
      if (!SR_SendCloseResponse(refnr, GetSRCloseRespA(ASPfilename)))
	ToLog(refnr, "Close Response NOT sent");
      else
	ToLog(refnr, "Close Response sent");
    }
    NotOK = True;
    break;
  case 6:
    if (!SR_AbortAssociation(refnr))
      ToLog(refnr, "Abort NOT sent");
    else
      ToLog(refnr, "Abort sent");
    NotOK = True;
    break;
  }
  return !NotOK;
}



Boolean
RecASP_T(int refnr)
{
  SRInitialiseRequest *sirq;
  SRInitialiseRequest *sirq2;
  SRSearchRequest *ssrq;
  SRSearchRequest *ssrq2;
  SRPresentRequest *sprq;
  SRPresentRequest *sprq2;
  SRDeleteResultSetRequest *sdrq;
  SRDeleteResultSetRequest *sdrq2;
  SRCloseRequest *scrq;
  SROperation     SROpr;
  char            yn1;
  Boolean         NotOK = False;
  int to = (-1);
  SROpr = SR_PollNetwork(0, 0, 0, 0, 0, &to);	/* SETT INN RIKTIGE VERDIER!!! */
  switch (SROpr)
  {
  case oprInitialiseRequest:
    if (!(sirq = SR_ReadInitialiseRequest(refnr)))
    {
      ToLog(refnr, "Initialize Indication NOT received / recognized");
      NotOK = True;
    } else
    {
      ToLog(refnr, "Initialize Indication received / recognized");
      ToLog(refnr, "Initialize Indication ASP values:");
      ShowSRInitReqV(refnr, sirq);
      yn1 = gnu_getchar("Compare to ASPfile (y/n)? ");
      if (yn1 == 'y' || yn1 == 'Y')
      {
	ASPfilename = strdup(gnu_gets("Filename: ", stdin, instr, inlen));
	sirq2 = GetSRInitReqValuesA(ASPfilename);
	SRirqComp(refnr, sirq, sirq2);
      }
    }
    break;
  case oprSearchRequest:
    if (!(ssrq = SR_ReadSearchRequest(refnr)))
    {
      ToLog(refnr, "Search Indication NOT received / recognized");
      NotOK = True;
    } else
    {
      ToLog(refnr, "Search Indication received / recognized");
      ToLog(refnr, "Search Indication ASP values:");
      ShowSRSearchReqV(refnr, ssrq);
      yn1 = gnu_getchar("Compare to ASPfile (y/n)? ");
      if (yn1 == 'y' || yn1 == 'Y')
      {
	ASPfilename = strdup(gnu_gets("Filename: ", stdin, instr, inlen));
	ssrq2 = GetSRSrchReqValuesA(ASPfilename);
	SRsrqComp(refnr, ssrq, ssrq2);
      }
    }
    break;
  case oprPresentRequest:
    if (!(sprq = SR_ReadPresentRequest(refnr)))
    {
      ToLog(refnr, "Present Indication NOT received / recognized");
      NotOK = True;
    } else
    {
      ToLog(refnr, "Present Indication received / recognized");
      ToLog(refnr, "Present Indication ASP values:");
      ShowSRPresentReqV(refnr, sprq);
      yn1 = gnu_getchar("Compare to ASPfile (y/n)? ");
      if (yn1 == 'y' || yn1 == 'Y')
      {
	ASPfilename = strdup(gnu_gets("Filename: ", stdin, instr, inlen));
	sprq2 = GetSRPresReqValuesA(ASPfilename);
	SRprqComp(refnr, sprq, sprq2);
      }
    }
    break;
  case oprDeleteResultSetRequest:
    if (!(sdrq = SR_ReadDeleteResultSetRequest(refnr)))
    {
      ToLog(refnr, "Delete Result Set Indication NOT received / recognized");
      NotOK = True;
    } else
    {
      ToLog(refnr, "Delete Result Set Indication received / recognized");
      ToLog(refnr, "Delete Result Set Indication ASP values:");
      ShowSRDelResSetReqV(refnr, sdrq);
      yn1 = gnu_getchar("Compare to ASPfile (y/n)? ");
      if (yn1 == 'y' || yn1 == 'Y')
      {
	ASPfilename = strdup(gnu_gets("Filename: ", stdin, instr, inlen));
	sdrq2 = GetSRDelRSReqValuesA(ASPfilename);
	SRdrqComp(refnr, sdrq, sdrq2);
      }
    }
    break;
  case oprCloseRequest:
    if (!(scrq = SR_ReadCloseRequest(refnr)))
    {
      ToLog(refnr, "Close Indication NOT received / recognized");
      NotOK = True;
    } else
    {
      ToLog(refnr, "Close Indication received / recognized");
    }
    break;
  case oprAbort:
    ToLog(refnr, "Abort received");
    NotOK = True;
    break;
  case oprNone:
    ToLog(refnr, "Nothing received");
    NotOK = True;
    break;
  default:
    ToLog(refnr, "Unrecognized message received from network / SRPM");
    NotOK = True;
    break;
  }
  return (!NotOK);
}


Boolean
AcceptAssociation(int refnr, presContext * pc)
{
  return (True);
}

void
changeLogfile()
{
  char            logfilename[256];
  gnu_gets("Log File Name (or none): ", stdin, logfilename, 255);
  if (*logfilename == '\0' || !strcmp(logfilename, "none"))
    logf = (FILE *) NULL;
  else if ((logf = fopen(logfilename, "a")) == NULL)
  {
    printf("Unable to open log-file.\n");
    return;
  }
}

int
main(void)
{
  char            UT_OT = ' ';
  presContext    *pcon;
  FILE           *attrfp;
  changeLogfile();
  if ((attrfp = fopen("../bib-1/attrset.bib-1","r")) == NULL ||
      parseAttrSet(attrfp) == False) {
    ToLog(rmrefnr, "Failed to parse Attribut Elements.");
    /* exit(1); */
  }
  if (!OSI_Initialise(llevAll, stderr))
    ToLog(rmrefnr, "OSI not initialized");
  else
  {
    ToLog(rmrefnr, "OSI initialized");
    for (;;)
    {
      SR_Address		*where;
      char			*msg;
      if (UT_OT != ' ')
	changeLogfile();
      UT_OT = gnu_getchar("UT: <O>rigin/<T>arget/<Q>uit: ");
      if ((UT_OT != 'o' && UT_OT != 'O') && (UT_OT != 't' && UT_OT != 'T'))
	break;
      rmrefnr = atoi(gnu_gets("Reference Id: ", stdin, instr, inlen));
      if (!str2sr_address (ADDRESS, &where, &msg))
	 where = NULL;
      if (UT_OT == 'o' || UT_OT == 'O')
      {
	printf("Open Association...\n");
#if 0
	pcon = newPC(OID_str2Oid(SR_RECORDSYNTAX_UNIMARC), OID_str2Oid(ISO2709_TRANSFERSYNTAX_CHARENC), 0);
#else
	pcon = (presContext *) NULL;
#endif
	if (!(where && SR_OpenAssociation(where, &pcon, &rmrefnr)))
	  ToLog(rmrefnr, "Association NOT opened");	/* !! */
	else
	{
	  ToLog(rmrefnr, "Association opened");
	  while (1)
	  {
	    if (!SendASP_O(rmrefnr))
	      break;
	    if (!RecASP_O(rmrefnr))
	      break;
	  }
	}
      } else
      {
	printf("Create Listener...\n");
	/* SETT INN RIKTIGE VERDIER!!! */
	if (!(where && SR_CreateListener(where, AcceptAssociation)))
	  ToLog(rmrefnr, "NO Listener created");
	else
	{
	  ToLog(rmrefnr, "Listener created");
	  while (1)
	  {
	    if (!RecASP_T(rmrefnr))
	      break;
	    if (!SendASP_T(rmrefnr))
	      break;
	  }
	}
      }
      if (SR_VerifyAssociation(rmrefnr))
      {
	if (!SR_AbortAssociation(rmrefnr))
	  ToLog(rmrefnr, "Association NOT finally closed");
	else
	  ToLog(rmrefnr, "Association finally closed");
      } else
	ToLog(rmrefnr, "NO Association finally present");
    }
    changeLogfile();
    /* OSI_Close; */
  }
  return 0;
}
