/*
 * testserver.c,v 1.1 1994/01/28 17:21:57 franktor Exp
 */

#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>

#include <high/sr_structcodec.h>

connectionParameters    conn;
int			FD;
EapiPacket		*pkt;

main ()
{
  conn.method = connect_tcpip;
  conn.u.ip.address = strdup ( "gandalf.uio.no" );
  conn.u.ip.port = 2401;

  (void) CreateListener ( &conn, &FD );

  fprintf ( stderr, "server returned pid=%d, fd=%d\n", getpid(), FD );

  while ( 1 )
  {
     fd_set	readfds, writefds, exceptfds;
     Boolean	selectOnWrite			= False;

     FD_ZERO ( &readfds), FD_ZERO ( &writefds ), FD_ZERO ( &exceptfds );
     FD_SET ( FD, &readfds ),  FD_SET ( FD, &exceptfds );
     if ( selectOnWrite )
	FD_SET ( FD, &writefds );
     
     if ( select ( 64, &readfds, &writefds, &exceptfds, (struct timeval *) NULL ) < 0 )
     {
	if ( errno = EINTR )
	   continue;
	
	fprintf ( stderr, "select() failed with errno=%d - closing\n", errno );
	break;
     }

     switch ( handle_socket ( FD,
			      FD_ISSET(FD, &readfds) ? True : False, 
			      FD_ISSET(FD, &writefds) ? True : False, 
			      FD_ISSET(FD, &exceptfds) ? True : False, &selectOnWrite ) )
     {
      case sockStatOK:
	fprintf ( stderr, "handle_socket() returned OK\n" );
	break;
	
      case sockStatFailed:
      case sockStatClosed:
	fprintf ( stderr, "handle_socket() returned one of Failed or Closed\n" );
	goto EXIT;
	break;
	
      case sockStatPacketReady:
	fprintf ( stderr, "Packet ready\n" );
	if ( !read_struct ( FD, (void **) &pkt ) )
	   fprintf ( stderr, "Failed to read paket\n" );
	else
	{
	   fprintf ( stderr, "Packet read\n" );
	}
	break;
     }
  }

 EXIT:;

  LOG ( facApp, llevTrace, "Exiting" );

  closeConnection ( FD );
  return 0;
}
