/*
 * prescont.c,v 1.1 1994/01/28 17:21:42 franktor Exp
 *
 * prescont.c  -  Utility routines for presentation contexts
 *
*/

#include <sr-api.h>
#include <sr-logger.h>

presContext *newPC ( Oid AS, Oid TS, int PCI )
{
   presContext		*pc	= (presContext *) smalloc ( sizeof ( presContext ) );

   pc->abstractSyntax = OID_dup ( AS );
   pc->transferSyntax = OID_dup ( TS );
   pc->PCI = PCI;
   pc->accepted = True;
   pc->next = (presContext *) NULL;

   return pc;
}

presContext *addPC ( presContext *PClist, presContext *PC )
{
   PC->next = PClist;
   return PC;
}

presContext *subPC ( presContext *PClist, presContext *PC )
{
   presContext		*ths, *prv;

   for ( ths = PClist, prv = (presContext *) NULL; ths && ths != PC; prv = ths, ths=ths->next );

   if ( ths == PC )
   {
      if ( prv )
	 prv->next = ths->next;
      else
	 PClist = ths->next;
   }

   ths->next = (presContext *) NULL;

   return PClist;
}

Boolean isPCin ( presContext *PClist, presContext *PC )
{
   presContext		*ths;

   for ( ths = PClist; ths && ths != PC; ths = ths->next );

   if ( ths == PC )
      return True;
   else
      return False;
}

char *PC2str ( presContext *PC )
{
   static char		buf[512];

   sprintf ( buf, "Presentation Context %d: AbstractSyntax %s, TransferSyntax %s", PC->PCI,
	     !OID_isNull ( PC->abstractSyntax ) ? OID_Oid2name ( PC->abstractSyntax ) : "NULLOID",
	     !OID_isNull ( PC->transferSyntax ) ? OID_Oid2name ( PC->transferSyntax ) : "NULLOID" );

   return buf;
}


void freePClist ( presContext *PClist )
{
   presContext		*p;

   if ( !PClist )
      return;

   for ( p = PClist->next; PClist; PClist = p, p = p ? p->next : (presContext *) NULL )
   {
      OID_free ( PClist->abstractSyntax );
      OID_free ( PClist->transferSyntax ); 
      free ( PClist );
   }
}


presContext *findPCI ( presContext *PClist, int PCI )
{
   while ( PClist && PClist->PCI != PCI )
      PClist = PClist->next;

   return PClist;
}


