










Boolean         _ISODE_SendInitialiseRequest (int ref, SRInitialiseRequest * ir)
{
   struct _InitialiseRequest *irq = (struct _InitialiseRequest *) NULL;
   PE              pe = NULLPE;
   struct _SR_APDU sr_apdu;
   irq = encode_InitialiseRequest (ir);
   if (encode_ISO10163__SR__1_InitialiseRequest (&sr_apdu.pe, 1, 0, NULLCP, irq) == NOTOK)
   {
      LOG (facLow, llevExceptions, "encode_ISO10163__SR__1_%s%s%s", "Initialise", "Request", " () failed");
      return False;
   }
   switch (oprInitialiseRequest)
   {
   case oprInitialiseRequest:
      sr_apdu.offset = 1;
      break;
   case oprInitialiseResponse:
      sr_apdu.offset = 2;
      break;
   case oprSearchRequest:
      sr_apdu.offset = 3;
      break;
   case oprSearchResponse:
      sr_apdu.offset = 4;
      break;
   case oprPresentRequest:
      sr_apdu.offset = 5;
      break;
   case oprPresentResponse:
      sr_apdu.offset = 6;
      break;
   case oprDeleteResultSetRequest:
      sr_apdu.offset = 7;
      break;
   case oprDeleteResultSetResponse:
      sr_apdu.offset = 8;
      break;
   case oprCloseRequest:
      sr_apdu.offset = 9;
      break;
   case oprCloseResponse:
      sr_apdu.offset = 10;
      break;
   }
   if (encode_ISO10163__SR__1_SR__APDU (&pe, 1, 0, NULLCP, &sr_apdu) == NOTOK)
   {
      LOG (facLow, llevExceptions, "encode_ISO10163__SR__1_SR__APDU() failed");
      return False;
   }
   pe->pe_context = 1;
   return SendPE (ref, pe, "Initialise", "Request");
}


Boolean         _ISODE_SendInitialiseResponse (int ref, SRInitialiseResponse * ir)
{
   struct _InitialiseResponse *irq = (struct _InitialiseResponse *) NULL;
   PE              pe = NULLPE;
   struct _SR_APDU sr_apdu;
   irq = encode_InitialiseResponse (ir);
   if (encode_ISO10163__SR__1_InitialiseResponse (&sr_apdu.pe, 1, 0, NULLCP, irq) == NOTOK)
   {
      LOG (facLow, llevExceptions, "encode_ISO10163__SR__1_%s%s%s", "Initialise", "Response", " () failed");
      return False;
   }
   switch (oprInitialiseResponse)
   {
   case oprInitialiseRequest:
      sr_apdu.offset = 1;
      break;
   case oprInitialiseResponse:
      sr_apdu.offset = 2;
      break;
   case oprSearchRequest:
      sr_apdu.offset = 3;
      break;
   case oprSearchResponse:
      sr_apdu.offset = 4;
      break;
   case oprPresentRequest:
      sr_apdu.offset = 5;
      break;
   case oprPresentResponse:
      sr_apdu.offset = 6;
      break;
   case oprDeleteResultSetRequest:
      sr_apdu.offset = 7;
      break;
   case oprDeleteResultSetResponse:
      sr_apdu.offset = 8;
      break;
   case oprCloseRequest:
      sr_apdu.offset = 9;
      break;
   case oprCloseResponse:
      sr_apdu.offset = 10;
      break;
   }
   if (encode_ISO10163__SR__1_SR__APDU (&pe, 1, 0, NULLCP, &sr_apdu) == NOTOK)
   {
      LOG (facLow, llevExceptions, "encode_ISO10163__SR__1_SR__APDU() failed");
      return False;
   }
   pe->pe_context = 1;
   return SendPE (ref, pe, "Initialise", "Response");
}


SRInitialiseRequest *_ISODE_ReadInitialiseRequest (int ref)
{
   struct _InitialiseRequest *_irs = (struct _InitialiseRequest *) NULL;
   SRInitialiseRequest *irs = (SRInitialiseRequest *) NULL;
   qElem          *qe = (qElem *) NULL;
   for (qe = incomming; qe && qe->ref != ref; qe = qe->next);
   if (!qe)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s%d", "Initialise", "Request", " failed - no APDU waiting for association ", ref);
      return (SRInitialiseRequest *) NULL;
   }
   if (qe->opr != oprInitialiseRequest)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s%s%s%s%s%s%d", "Initialise", "Request", " failed - found ", sro2str (qe->opr), "when expected ", "Initialise", "Request", " for association ", ref);
      return (SRInitialiseRequest *) NULL;
   }
   if (decode_ISO10163__SR__1_InitialiseRequest (incomming->oprPE, 1, 0, NULLCP, &_irs) == NOTOK)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s", "Initialise", "Request", " () ASN.1 decode failed");
      return (SRInitialiseRequest *) NULL;
   }
   irs = decode_InitialiseRequest (_irs);
   incomming = incomming->next;
   return irs;
}


SRInitialiseResponse *_ISODE_ReadInitialiseResponse (int ref)
{
   struct _InitialiseResponse *_irs = (struct _InitialiseResponse *) NULL;
   SRInitialiseResponse *irs = (SRInitialiseResponse *) NULL;
   qElem          *qe = (qElem *) NULL;
   for (qe = incomming; qe && qe->ref != ref; qe = qe->next);
   if (!qe)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s%d", "Initialise", "Response", " failed - no APDU waiting for association ", ref);
      return (SRInitialiseResponse *) NULL;
   }
   if (qe->opr != oprInitialiseResponse)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s%s%s%s%s%s%d", "Initialise", "Response", " failed - found ", sro2str (qe->opr), "when expected ", "Initialise", "Response", " for association ", ref);
      return (SRInitialiseResponse *) NULL;
   }
   if (decode_ISO10163__SR__1_InitialiseResponse (incomming->oprPE, 1, 0, NULLCP, &_irs) == NOTOK)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s", "Initialise", "Response", " () ASN.1 decode failed");
      return (SRInitialiseResponse *) NULL;
   }
   irs = decode_InitialiseResponse (_irs);
   incomming = incomming->next;
   return irs;
}


Boolean         _ISODE_SendSearchRequest (int ref, SRSearchRequest * ir)
{
   struct _SearchRequest *irq = (struct _SearchRequest *) NULL;
   PE              pe = NULLPE;
   struct _SR_APDU sr_apdu;
   irq = encode_SearchRequest (ir);
   if (encode_ISO10163__SR__1_SearchRequest (&sr_apdu.pe, 1, 0, NULLCP, irq) == NOTOK)
   {
      LOG (facLow, llevExceptions, "encode_ISO10163__SR__1_%s%s%s", "Search", "Request", " () failed");
      return False;
   }
   switch (oprSearchRequest)
   {
   case oprInitialiseRequest:
      sr_apdu.offset = 1;
      break;
   case oprInitialiseResponse:
      sr_apdu.offset = 2;
      break;
   case oprSearchRequest:
      sr_apdu.offset = 3;
      break;
   case oprSearchResponse:
      sr_apdu.offset = 4;
      break;
   case oprPresentRequest:
      sr_apdu.offset = 5;
      break;
   case oprPresentResponse:
      sr_apdu.offset = 6;
      break;
   case oprDeleteResultSetRequest:
      sr_apdu.offset = 7;
      break;
   case oprDeleteResultSetResponse:
      sr_apdu.offset = 8;
      break;
   case oprCloseRequest:
      sr_apdu.offset = 9;
      break;
   case oprCloseResponse:
      sr_apdu.offset = 10;
      break;
   }
   if (encode_ISO10163__SR__1_SR__APDU (&pe, 1, 0, NULLCP, &sr_apdu) == NOTOK)
   {
      LOG (facLow, llevExceptions, "encode_ISO10163__SR__1_SR__APDU() failed");
      return False;
   }
   pe->pe_context = 1;
   return SendPE (ref, pe, "Search", "Request");
}


Boolean         _ISODE_SendSearchResponse (int ref, SRSearchResponse * ir)
{
   struct _SearchResponse *irq = (struct _SearchResponse *) NULL;
   PE              pe = NULLPE;
   struct _SR_APDU sr_apdu;
   irq = encode_SearchResponse (ir);
   if (encode_ISO10163__SR__1_SearchResponse (&sr_apdu.pe, 1, 0, NULLCP, irq) == NOTOK)
   {
      LOG (facLow, llevExceptions, "encode_ISO10163__SR__1_%s%s%s", "Search", "Response", " () failed");
      return False;
   }
   switch (oprSearchResponse)
   {
   case oprInitialiseRequest:
      sr_apdu.offset = 1;
      break;
   case oprInitialiseResponse:
      sr_apdu.offset = 2;
      break;
   case oprSearchRequest:
      sr_apdu.offset = 3;
      break;
   case oprSearchResponse:
      sr_apdu.offset = 4;
      break;
   case oprPresentRequest:
      sr_apdu.offset = 5;
      break;
   case oprPresentResponse:
      sr_apdu.offset = 6;
      break;
   case oprDeleteResultSetRequest:
      sr_apdu.offset = 7;
      break;
   case oprDeleteResultSetResponse:
      sr_apdu.offset = 8;
      break;
   case oprCloseRequest:
      sr_apdu.offset = 9;
      break;
   case oprCloseResponse:
      sr_apdu.offset = 10;
      break;
   }
   if (encode_ISO10163__SR__1_SR__APDU (&pe, 1, 0, NULLCP, &sr_apdu) == NOTOK)
   {
      LOG (facLow, llevExceptions, "encode_ISO10163__SR__1_SR__APDU() failed");
      return False;
   }
   pe->pe_context = 1;
   return SendPE (ref, pe, "Search", "Response");
}


SRSearchRequest *_ISODE_ReadSearchRequest (int ref)
{
   struct _SearchRequest *_irs = (struct _SearchRequest *) NULL;
   SRSearchRequest *irs = (SRSearchRequest *) NULL;
   qElem          *qe = (qElem *) NULL;
   for (qe = incomming; qe && qe->ref != ref; qe = qe->next);
   if (!qe)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s%d", "Search", "Request", " failed - no APDU waiting for association ", ref);
      return (SRSearchRequest *) NULL;
   }
   if (qe->opr != oprSearchRequest)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s%s%s%s%s%s%d", "Search", "Request", " failed - found ", sro2str (qe->opr), "when expected ", "Search", "Request", " for association ", ref);
      return (SRSearchRequest *) NULL;
   }
   if (decode_ISO10163__SR__1_SearchRequest (incomming->oprPE, 1, 0, NULLCP, &_irs) == NOTOK)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s", "Search", "Request", " () ASN.1 decode failed");
      return (SRSearchRequest *) NULL;
   }
   irs = decode_SearchRequest (_irs);
   incomming = incomming->next;
   return irs;
}


SRSearchResponse *_ISODE_ReadSearchResponse (int ref)
{
   struct _SearchResponse *_irs = (struct _SearchResponse *) NULL;
   SRSearchResponse *irs = (SRSearchResponse *) NULL;
   qElem          *qe = (qElem *) NULL;
   for (qe = incomming; qe && qe->ref != ref; qe = qe->next);
   if (!qe)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s%d", "Search", "Response", " failed - no APDU waiting for association ", ref);
      return (SRSearchResponse *) NULL;
   }
   if (qe->opr != oprSearchResponse)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s%s%s%s%s%s%d", "Search", "Response", " failed - found ", sro2str (qe->opr), "when expected ", "Search", "Response", " for association ", ref);
      return (SRSearchResponse *) NULL;
   }
   if (decode_ISO10163__SR__1_SearchResponse (incomming->oprPE, 1, 0, NULLCP, &_irs) == NOTOK)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s", "Search", "Response", " () ASN.1 decode failed");
      return (SRSearchResponse *) NULL;
   }
   irs = decode_SearchResponse (_irs);
   incomming = incomming->next;
   return irs;
}


Boolean         _ISODE_SendPresentRequest (int ref, SRPresentRequest * ir)
{
   struct _PresentRequest *irq = (struct _PresentRequest *) NULL;
   PE              pe = NULLPE;
   struct _SR_APDU sr_apdu;
   irq = encode_PresentRequest (ir);
   if (encode_ISO10163__SR__1_PresentRequest (&sr_apdu.pe, 1, 0, NULLCP, irq) == NOTOK)
   {
      LOG (facLow, llevExceptions, "encode_ISO10163__SR__1_%s%s%s", "Present", "Request", " () failed");
      return False;
   }
   switch (oprPresentRequest)
   {
   case oprInitialiseRequest:
      sr_apdu.offset = 1;
      break;
   case oprInitialiseResponse:
      sr_apdu.offset = 2;
      break;
   case oprSearchRequest:
      sr_apdu.offset = 3;
      break;
   case oprSearchResponse:
      sr_apdu.offset = 4;
      break;
   case oprPresentRequest:
      sr_apdu.offset = 5;
      break;
   case oprPresentResponse:
      sr_apdu.offset = 6;
      break;
   case oprDeleteResultSetRequest:
      sr_apdu.offset = 7;
      break;
   case oprDeleteResultSetResponse:
      sr_apdu.offset = 8;
      break;
   case oprCloseRequest:
      sr_apdu.offset = 9;
      break;
   case oprCloseResponse:
      sr_apdu.offset = 10;
      break;
   }
   if (encode_ISO10163__SR__1_SR__APDU (&pe, 1, 0, NULLCP, &sr_apdu) == NOTOK)
   {
      LOG (facLow, llevExceptions, "encode_ISO10163__SR__1_SR__APDU() failed");
      return False;
   }
   pe->pe_context = 1;
   return SendPE (ref, pe, "Present", "Request");
}


Boolean         _ISODE_SendPresentResponse (int ref, SRPresentResponse * ir)
{
   struct _PresentResponse *irq = (struct _PresentResponse *) NULL;
   PE              pe = NULLPE;
   struct _SR_APDU sr_apdu;
   irq = encode_PresentResponse (ir);
   if (encode_ISO10163__SR__1_PresentResponse (&sr_apdu.pe, 1, 0, NULLCP, irq) == NOTOK)
   {
      LOG (facLow, llevExceptions, "encode_ISO10163__SR__1_%s%s%s", "Present", "Response", " () failed");
      return False;
   }
   switch (oprPresentResponse)
   {
   case oprInitialiseRequest:
      sr_apdu.offset = 1;
      break;
   case oprInitialiseResponse:
      sr_apdu.offset = 2;
      break;
   case oprSearchRequest:
      sr_apdu.offset = 3;
      break;
   case oprSearchResponse:
      sr_apdu.offset = 4;
      break;
   case oprPresentRequest:
      sr_apdu.offset = 5;
      break;
   case oprPresentResponse:
      sr_apdu.offset = 6;
      break;
   case oprDeleteResultSetRequest:
      sr_apdu.offset = 7;
      break;
   case oprDeleteResultSetResponse:
      sr_apdu.offset = 8;
      break;
   case oprCloseRequest:
      sr_apdu.offset = 9;
      break;
   case oprCloseResponse:
      sr_apdu.offset = 10;
      break;
   }
   if (encode_ISO10163__SR__1_SR__APDU (&pe, 1, 0, NULLCP, &sr_apdu) == NOTOK)
   {
      LOG (facLow, llevExceptions, "encode_ISO10163__SR__1_SR__APDU() failed");
      return False;
   }
   pe->pe_context = 1;
   return SendPE (ref, pe, "Present", "Response");
}


SRPresentRequest *_ISODE_ReadPresentRequest (int ref)
{
   struct _PresentRequest *_irs = (struct _PresentRequest *) NULL;
   SRPresentRequest *irs = (SRPresentRequest *) NULL;
   qElem          *qe = (qElem *) NULL;
   for (qe = incomming; qe && qe->ref != ref; qe = qe->next);
   if (!qe)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s%d", "Present", "Request", " failed - no APDU waiting for association ", ref);
      return (SRPresentRequest *) NULL;
   }
   if (qe->opr != oprPresentRequest)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s%s%s%s%s%s%d", "Present", "Request", " failed - found ", sro2str (qe->opr), "when expected ", "Present", "Request", " for association ", ref);
      return (SRPresentRequest *) NULL;
   }
   if (decode_ISO10163__SR__1_PresentRequest (incomming->oprPE, 1, 0, NULLCP, &_irs) == NOTOK)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s", "Present", "Request", " () ASN.1 decode failed");
      return (SRPresentRequest *) NULL;
   }
   irs = decode_PresentRequest (_irs);
   incomming = incomming->next;
   return irs;
}


SRPresentResponse *_ISODE_ReadPresentResponse (int ref)
{
   struct _PresentResponse *_irs = (struct _PresentResponse *) NULL;
   SRPresentResponse *irs = (SRPresentResponse *) NULL;
   qElem          *qe = (qElem *) NULL;
   for (qe = incomming; qe && qe->ref != ref; qe = qe->next);
   if (!qe)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s%d", "Present", "Response", " failed - no APDU waiting for association ", ref);
      return (SRPresentResponse *) NULL;
   }
   if (qe->opr != oprPresentResponse)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s%s%s%s%s%s%d", "Present", "Response", " failed - found ", sro2str (qe->opr), "when expected ", "Present", "Response", " for association ", ref);
      return (SRPresentResponse *) NULL;
   }
   if (decode_ISO10163__SR__1_PresentResponse (incomming->oprPE, 1, 0, NULLCP, &_irs) == NOTOK)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s", "Present", "Response", " () ASN.1 decode failed");
      return (SRPresentResponse *) NULL;
   }
   irs = decode_PresentResponse (_irs);
   incomming = incomming->next;
   return irs;
}


Boolean         _ISODE_SendDeleteResultSetRequest (int ref, SRDeleteResultSetRequest * ir)
{
   struct _DeleteResultSetRequest *irq = (struct _DeleteResultSetRequest *) NULL;
   PE              pe = NULLPE;
   struct _SR_APDU sr_apdu;
   irq = encode_DeleteResultSetRequest (ir);
   if (encode_ISO10163__SR__1_DeleteResultSetRequest (&sr_apdu.pe, 1, 0, NULLCP, irq) == NOTOK)
   {
      LOG (facLow, llevExceptions, "encode_ISO10163__SR__1_%s%s%s", "DeleteResultSet", "Request", " () failed");
      return False;
   }
   switch (oprDeleteResultSetRequest)
   {
   case oprInitialiseRequest:
      sr_apdu.offset = 1;
      break;
   case oprInitialiseResponse:
      sr_apdu.offset = 2;
      break;
   case oprSearchRequest:
      sr_apdu.offset = 3;
      break;
   case oprSearchResponse:
      sr_apdu.offset = 4;
      break;
   case oprPresentRequest:
      sr_apdu.offset = 5;
      break;
   case oprPresentResponse:
      sr_apdu.offset = 6;
      break;
   case oprDeleteResultSetRequest:
      sr_apdu.offset = 7;
      break;
   case oprDeleteResultSetResponse:
      sr_apdu.offset = 8;
      break;
   case oprCloseRequest:
      sr_apdu.offset = 9;
      break;
   case oprCloseResponse:
      sr_apdu.offset = 10;
      break;
   }
   if (encode_ISO10163__SR__1_SR__APDU (&pe, 1, 0, NULLCP, &sr_apdu) == NOTOK)
   {
      LOG (facLow, llevExceptions, "encode_ISO10163__SR__1_SR__APDU() failed");
      return False;
   }
   pe->pe_context = 1;
   return SendPE (ref, pe, "DeleteResultSet", "Request");
}


Boolean         _ISODE_SendDeleteResultSetResponse (int ref, SRDeleteResultSetResponse * ir)
{
   struct _DeleteResultSetResponse *irq = (struct _DeleteResultSetResponse *) NULL;
   PE              pe = NULLPE;
   struct _SR_APDU sr_apdu;
   irq = encode_DeleteResultSetResponse (ir);
   if (encode_ISO10163__SR__1_DeleteResultSetResponse (&sr_apdu.pe, 1, 0, NULLCP, irq) == NOTOK)
   {
      LOG (facLow, llevExceptions, "encode_ISO10163__SR__1_%s%s%s", "DeleteResultSet", "Response", " () failed");
      return False;
   }
   switch (oprDeleteResultSetResponse)
   {
   case oprInitialiseRequest:
      sr_apdu.offset = 1;
      break;
   case oprInitialiseResponse:
      sr_apdu.offset = 2;
      break;
   case oprSearchRequest:
      sr_apdu.offset = 3;
      break;
   case oprSearchResponse:
      sr_apdu.offset = 4;
      break;
   case oprPresentRequest:
      sr_apdu.offset = 5;
      break;
   case oprPresentResponse:
      sr_apdu.offset = 6;
      break;
   case oprDeleteResultSetRequest:
      sr_apdu.offset = 7;
      break;
   case oprDeleteResultSetResponse:
      sr_apdu.offset = 8;
      break;
   case oprCloseRequest:
      sr_apdu.offset = 9;
      break;
   case oprCloseResponse:
      sr_apdu.offset = 10;
      break;
   }
   if (encode_ISO10163__SR__1_SR__APDU (&pe, 1, 0, NULLCP, &sr_apdu) == NOTOK)
   {
      LOG (facLow, llevExceptions, "encode_ISO10163__SR__1_SR__APDU() failed");
      return False;
   }
   pe->pe_context = 1;
   return SendPE (ref, pe, "DeleteResultSet", "Response");
}


SRDeleteResultSetRequest *_ISODE_ReadDeleteResultSetRequest (int ref)
{
   struct _DeleteResultSetRequest *_irs = (struct _DeleteResultSetRequest *) NULL;
   SRDeleteResultSetRequest *irs = (SRDeleteResultSetRequest *) NULL;
   qElem          *qe = (qElem *) NULL;
   for (qe = incomming; qe && qe->ref != ref; qe = qe->next);
   if (!qe)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s%d", "DeleteResultSet", "Request", " failed - no APDU waiting for association ", ref);
      return (SRDeleteResultSetRequest *) NULL;
   }
   if (qe->opr != oprDeleteResultSetRequest)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s%s%s%s%s%s%d", "DeleteResultSet", "Request", " failed - found ", sro2str (qe->opr), "when expected ", "DeleteResultSet", "Request", " for association ", ref);
      return (SRDeleteResultSetRequest *) NULL;
   }
   if (decode_ISO10163__SR__1_DeleteResultSetRequest (incomming->oprPE, 1, 0, NULLCP, &_irs) == NOTOK)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s", "DeleteResultSet", "Request", " () ASN.1 decode failed");
      return (SRDeleteResultSetRequest *) NULL;
   }
   irs = decode_DeleteResultSetRequest (_irs);
   incomming = incomming->next;
   return irs;
}


SRDeleteResultSetResponse *_ISODE_ReadDeleteResultSetResponse (int ref)
{
   struct _DeleteResultSetResponse *_irs = (struct _DeleteResultSetResponse *) NULL;
   SRDeleteResultSetResponse *irs = (SRDeleteResultSetResponse *) NULL;
   qElem          *qe = (qElem *) NULL;
   for (qe = incomming; qe && qe->ref != ref; qe = qe->next);
   if (!qe)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s%d", "DeleteResultSet", "Response", " failed - no APDU waiting for association ", ref);
      return (SRDeleteResultSetResponse *) NULL;
   }
   if (qe->opr != oprDeleteResultSetResponse)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s%s%s%s%s%s%d", "DeleteResultSet", "Response", " failed - found ", sro2str (qe->opr), "when expected ", "DeleteResultSet", "Response", " for association ", ref);
      return (SRDeleteResultSetResponse *) NULL;
   }
   if (decode_ISO10163__SR__1_DeleteResultSetResponse (incomming->oprPE, 1, 0, NULLCP, &_irs) == NOTOK)
   {
      LOG (facLow, llevExceptions, "_ISODE_Read%s%s%s", "DeleteResultSet", "Response", " () ASN.1 decode failed");
      return (SRDeleteResultSetResponse *) NULL;
   }
   irs = decode_DeleteResultSetResponse (_irs);
   incomming = incomming->next;
   return irs;
}
