/*
 * sr-low.h,v 1.1 1994/01/28 17:05:47 franktor Exp
 *
 * sr-low.h
 *
 * Describes the procedural interface between the protocol machine
 * and the lower level for network access. Currently a low level for
 * TCPIP and for OSI though ISODE is defined.
 *
*/

#ifndef SR_LOW_H
#define SR_LOW_H

#include <sr-general.h>
#include <sr-api.h>

extern SR_protocolVersion	currentProtocolVersion;
				/* This variable is set before each call to
				 * lower layer (_ISODE/_TCPIP) functions. */

#define	OID_GET(o)  str2oid (OID_Oid2str ((o),(int)currentProtocolVersion + 1))


Boolean _OSI_Initialise ( LogLevel logLevel, FILE *log, void (*Abort)(int) );
Boolean _OSI_Verify ( void );
void _OSI_Close ( void );

char *_OSI_LastError ( void  );

/* ISODE */

fd_set *_ISODE_GetSelectFD_SET ( void );

Boolean _ISODE_OpenAssociation ( SR_Address *to, presContext **pci, int *ref );
Boolean _ISODE_CreateListener ( SR_Address *where, Boolean (*accept)( int, SR_protocolVersion, LowerLayerKind, presContext *pci ) );
Boolean _ISODE_VerifyAssociation ( int ref );
void _ISODE_AbortAssociation ( int ref );
void _ISODE_ClearAssociation ( int ref ); /* clears any queued incomming PDUs on this ref */

SROperation _ISODE_PollNetwork ( struct timeval *timeout,
				 int nfds, fd_set *rfds, fd_set *wfds, fd_set *efds,
				 int *ref );

Boolean _ISODE_SendInitialiseRequest ( int ref, SRInitialiseRequest *irq );
Boolean _ISODE_SendInitialiseResponse ( int ref, SRInitialiseResponse *irp );
SRInitialiseRequest *_ISODE_ReadInitialiseRequest ( int ref );
SRInitialiseResponse *_ISODE_ReadInitialiseResponse ( int ref );

Boolean _ISODE_SendSearchRequest ( int ref, SRSearchRequest *irq );
Boolean _ISODE_SendSearchResponse ( int ref, SRSearchResponse *irp );
SRSearchRequest *_ISODE_ReadSearchRequest ( int ref );
SRSearchResponse *_ISODE_ReadSearchResponse ( int ref );

Boolean _ISODE_SendPresentRequest ( int ref, SRPresentRequest *irq );
Boolean _ISODE_SendPresentResponse ( int ref, SRPresentResponse *irp );
SRPresentRequest *_ISODE_ReadPresentRequest ( int ref );
SRPresentResponse *_ISODE_ReadPresentResponse ( int ref );

Boolean _ISODE_SendDeleteResultSetRequest ( int ref, SRDeleteResultSetRequest *irq );
Boolean _ISODE_SendDeleteResultSetResponse ( int ref, SRDeleteResultSetResponse *irp );
SRDeleteResultSetRequest *_ISODE_ReadDeleteResultSetRequest ( int ref );
SRDeleteResultSetResponse *_ISODE_ReadDeleteResultSetResponse ( int ref );

Boolean _ISODE_SendCloseRequest ( int ref, SRCloseRequest *crq );
Boolean _ISODE_SendCloseResponse ( int ref, SRCloseResponse *crp );
SRCloseRequest *_ISODE_ReadCloseRequest ( int ref );
SRCloseResponse *_ISODE_ReadCloseResponse ( int ref );

/* TCPIP */

void _TCPIP_GetSelectFD_SET ( fd_set **rs, fd_set **ws );

Boolean _TCPIP_OpenAssociation ( SR_Address *to, presContext **pci, int *ref );
Boolean _TCPIP_CreateListener ( SR_Address *where, Boolean (*accept)( int, SR_protocolVersion, LowerLayerKind, presContext *pci ) );
Boolean _TCPIP_VerifyAssociation ( int ref );
void _TCPIP_AbortAssociation ( int ref );
void _TCPIP_ClearAssociation ( int ref ); /* clears any queued incomming PDUs on this ref */

SROperation _TCPIP_PollNetwork ( struct timeval *timeout, int *ref );

Boolean _TCPIP_SendInitialiseRequest ( int ref, SRInitialiseRequest *irq );
Boolean _TCPIP_SendInitialiseResponse ( int ref, SRInitialiseResponse *irp );
SRInitialiseRequest *_TCPIP_ReadInitialiseRequest ( int ref );
SRInitialiseResponse *_TCPIP_ReadInitialiseResponse ( int ref );

Boolean _TCPIP_SendSearchRequest ( int ref, SRSearchRequest *irq );
Boolean _TCPIP_SendSearchResponse ( int ref, SRSearchResponse *irp );
SRSearchRequest *_TCPIP_ReadSearchRequest ( int ref );
SRSearchResponse *_TCPIP_ReadSearchResponse ( int ref );

Boolean _TCPIP_SendPresentRequest ( int ref, SRPresentRequest *irq );
Boolean _TCPIP_SendPresentResponse ( int ref, SRPresentResponse *irp );
SRPresentRequest *_TCPIP_ReadPresentRequest ( int ref );
SRPresentResponse *_TCPIP_ReadPresentResponse ( int ref );

Boolean _TCPIP_SendDeleteResultSetRequest ( int ref, SRDeleteResultSetRequest *irq );
Boolean _TCPIP_SendDeleteResultSetResponse ( int ref, SRDeleteResultSetResponse *irp );
SRDeleteResultSetRequest *_TCPIP_ReadDeleteResultSetRequest ( int ref );
SRDeleteResultSetResponse *_TCPIP_ReadDeleteResultSetResponse ( int ref );

Boolean _TCPIP_SendCloseRequest ( int ref, SRCloseRequest *crq );
Boolean _TCPIP_SendCloseResponse ( int ref, SRCloseResponse *crp );
SRCloseRequest *_TCPIP_ReadCloseRequest ( int ref );
SRCloseResponse *_TCPIP_ReadCloseResponse ( int ref );

#endif /* SR_LOW_H */
