/*
 * sr-converter.h,v 1.1 1994/01/28 17:05:44 franktor Exp
 */

typedef enum ConverterType {
  convert_in, convert_out
} ConverterType;

typedef struct Converter {
  struct Converter *next;		/* Next converter in a linked list */
  struct Class *class;			/* Pointer back to the class */
  void *(*read_func) (void *);		/* Function for reading that format */
  void *(*write_func) (void *);		/* Function for writing that format */
  char *name;				/* Name of format */
} Converter;

typedef struct Class {
  struct Class *next;
  char *name;				/* Class of format */
  struct Converter *converters;
  void (*free_func) (void *);		/* Function for freeing format */
					/* which is used internally */
} Class;

/*
 * Converter status, returned from the Convert() function:
 */

typedef enum {
  CV_OK = 0, CV_NoConverterFound = 1, CV_ConverterNotInitialised = 2,
  CV_ConversionError = 3
} CV_Status;
