/*
 * logger.c,v 1.1 1994/01/28 17:07:07 franktor Exp
 *
 * logger.c
 *
 *
*/

#define HAS_STDARG 0
#if (HAS_STDARG)
#  include <stdarg.h>
#else
#  include <varargs.h>
#endif
#include <sr-logger.h>

#include <sys/types.h>
#include <sys/time.h>
#ifndef VMS
#include <errno.h>
extern int errno;
#endif

FILE		*logFile		= (FILE *) NULL;
LogLevel	logLevels[NOFACILITIES] = {
   llevExceptions, llevExceptions, llevExceptions, llevExceptions,
   llevExceptions, llevExceptions, llevExceptions, llevExceptions,
   llevExceptions, llevExceptions
};

void facLogLevel ( fac, logLevel )
   Facility fac;
   LogLevel logLevel;
{
   int i;
   if ( (int)fac == (-1) )
      for (i = 0;  i < NOFACILITIES; logLevels[i++] = logLevel );
   else
      logLevels[(int) fac] = logLevel;
}

void initLogger ( where  )
   CONST char *where;
{
   FILE	     	*f;
   char		buf[500];
   CONST char	*bufp = buf;
   int		oldmask;

   if ( !where )
      logFile = stderr;

   if ( !*where )
      where = (DEFAULT_LOG_FILE);
#ifndef VMS
   if ( (*where == '/') || (*where == '.') )
      bufp = where;
   else
#endif
      sprintf ( buf, "%s%s", (DEFAULT_LOG_PREFIX), where );

   oldmask = umask ( 0 );
   if ( !((f = fopen ( bufp, "a+" )) ||
	  (bufp != where && (f = fopen ( bufp = where, "a+" ))) ) )
      LOG ( facLog, llevExceptions, "Failed to open logfile %s: %m", bufp );
   else
   {
      if ( logFile )
	 fclose ( logFile );
      logFile = f;
   }
   umask ( oldmask );
}

#ifdef VMS
void SR_LOG
#else
void LOG
#endif
#if (HAS_STDARG)
   ( Facility facility, LogLevel logLevel, CONST char *format, ... )
#else
   ( va_alist ) va_dcl
#endif
{
   va_list		ap;
   VA_START ( ap, format ); {
#if !(HAS_STDARG)
      Facility		facility = va_arg ( ap, Facility );
      LogLevel		logLevel = va_arg ( ap, LogLevel );
      CONST char	*format  = va_arg ( ap, CONST char * );
#endif

      if (logLevels[(int) facility] <= logLevel) /* This seemed appropriate. -Frank */
      {
	 FILE		*logf	= (logFile ? logFile : stderr);

	 time_t		now	= time(NULL);
	 static char	date[100];
	 strftime ( date, 100, "%d/%m %T", localtime(&now) );

	 fprintf ( logf, "%s ", date );
#ifndef VMS
	 fprintf ( logf, "%4d ", getpid() );
#endif
   
	 switch ( facility )
	 {
	  case facApp:
	    fprintf ( logf, "APPL " );
	    break;
      
	  case facLow:
	    fprintf ( logf, "LOW  " );
	    break;
      
	  case facHigh:
	    fprintf ( logf, "HIGH " );
	    break;

	  case facPM:
	    fprintf ( logf, "PM   " );
	    break;
      
	  case facMarc:
	    fprintf ( logf, "MARC " );
	    break;
      
	  case facLog:
	    fprintf ( logf, "LOG  " );
	    break;
      
	  case facStruct:
	    fprintf ( logf, "STRU " );
	    break;

	  case facTLV:
	    fprintf ( logf, "TLVP " );
	    break;

	  case facAddr:
	    fprintf ( logf, "ADDR " );
	    break;

	  default:
	    fprintf ( logf, "???? " );
	    break;
	 }

	 switch ( logLevel )
	 {
	  case llevAll:
	    fprintf ( logf, "ALL    " );
	    break;

	  case llevTrace:
	    fprintf ( logf, "TRACE  " );
	    break;
      
	  case llevDebug:
	    fprintf ( logf, "DEBUG  " );
	    break;
      
	  case llevExceptions:
	    fprintf ( logf, "EXCEPT " );
	    break;
      
	  case llevNotice:
	    fprintf ( logf, "NOTICE " );
	    break;
      
	  case llevNone:
	    fprintf ( logf, "NONE   " );
	    break;

	  default:
	    fprintf ( logf, "????   " );
	    break;
	 }

	 vfprintf ( logf, format, ap );
	 fputc ( '\n', logf );
	 fflush ( logf );
      }
   } va_end ( ap );
}

#ifndef VMS /* VAX C has a similar function.  -Frank */

extern char *sys_errlist[];

char * strerror()
{
  return sys_errlist[errno];
}
#endif
