/*
 * server-structdesc.h,v 1.1 1994/01/28 17:06:00 franktor Exp
 *
 * structdesc.h
 *
 * Description of datastructures usable for code
 *
*/

#ifndef HIGH_SERVER_STRUCTDESC_H
#define HIGH_SERVER_STRUCTDESC_H

#include <sr-general.h>
#ifndef VMS
#include <high/structcodec.h>
#include <high/eapi.h>
#else
#include <structcodec.h>
#include <eapi.h>
#endif

				/* structures from general.h */
extern elemDesc desc_octetString[];

				/* structures from eapi.h */
extern elemDesc desc_DatabaseName[];
extern elemDesc desc_SearchRequest[];
extern elemDesc desc_SearchResponse[];
extern elemDesc desc_PresentRequest[];
extern elemDesc desc_PresentResponse[];
extern elemDesc desc_EapiRecords[];
extern elemDesc desc_EapiNamePlusRecord[];
extern elemDesc desc_EapiDiagRec[];
extern elemDesc desc_DeleteResultSetRequest[];
extern elemDesc desc_DeleteResultSetResponse[];
extern elemDesc desc_InterruptRequest[];
extern elemDesc desc_InterruptResponse[];
extern elemDesc desc_OpenRequest[];
extern elemDesc desc_OpenResponse[];
extern elemDesc desc_CloseRequest[];
extern elemDesc desc_CloseResponse[];
extern elemDesc desc_EapiPacket[];

				/* structures from sr-api.h */
extern elemDesc desc_RCNameAndId[];
extern elemDesc desc_RecordComposition_u_u[];
extern elemDesc desc_RecordComposition[];
extern elemDesc desc_Query[];
extern elemDesc desc_RPNQuery[];
extern elemDesc desc_AttributeElement[];
extern elemDesc desc_AttributeList[];
extern elemDesc desc_AttributesPlusTerm[];
extern elemDesc desc_operandType[];
extern elemDesc desc_Operand[];
extern elemDesc desc_RPNStructureType[];
extern elemDesc desc_Operator[];
extern elemDesc desc_RPNStructure[];
extern elemDesc desc_DiagRec[];
extern elemDesc desc_NamePlusRecord[];
extern elemDesc desc_Records[];
extern elemDesc desc_EXTERN[]; 


/* structures from general.h */

elemDesc desc_octetString[] = {
  { elemInt,	   	0,		  	sizeof(int) },  
  { elemCharPtr,   	0,		  	sizeof(char *) },  
  { elemDone, 		0, 			0 } 
};




/* structures from eapi.h */

elemDesc desc_DatabaseName [] = {
  { elemCharPtr, 	0, 			sizeof(char*) },
  { elemStructPtr, 	desc_DatabaseName, 	sizeof(struct DatabaseName*) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_SearchRequest [] = {
  { elemStructPtr, 	desc_DatabaseName, 	sizeof(struct DatabaseName *) },
  { elemStructPtr, 	desc_Query, 		sizeof(struct Query *) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_SearchResponse[] = {
  { elemInt,		0,			sizeof(int) }, 
  { elemBoolean,	0,			sizeof(Boolean) }, 
  { elemEnum,		0,			sizeof(ResultSetStatus) }, 
  { elemInt,		0,			sizeof(int) }, 
  { elemDone, 		0, 			0 } 
};

elemDesc desc_PresentRequest[] = {
  { elemInt,		0,			sizeof(int) }, 
  { elemInt,		0,			sizeof(int) }, 
  { elemInt,		0,			sizeof(int) }, 
  { elemStructPtr,	desc_RecordComposition,	sizeof(RecordComposition *) }, 
  { elemCharPtr,	0,			sizeof(char *) }, 
  { elemDone, 		0, 			0 } 
};

elemDesc desc_PresentResponse[] = {
  { elemInt,		0,			sizeof(int) }, 
  { elemEnum,		0,			sizeof(PresentStatus) }, 
  { elemStructPtr,	desc_EapiRecords,	sizeof(struct EapiRecords *) }, 
  { elemDone, 		0, 			0 } 
};

elemDesc desc_EapiRecords_u_u[] = {
  { elemStructPtr,	desc_EapiNamePlusRecord, sizeof(EapiNamePlusRecord *) }, 
  { elemStructPtr,	desc_EapiDiagRec,	sizeof(DiagRec *) }, 
  { elemDone,		0,			0}
};

elemDesc desc_EapiRecords[] = {
  { elemEnum,		0,			sizeof(EapiRecordKind) },
  { elemUnion,		desc_EapiRecords_u_u,	0,			0 },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_EapiRecord[] = {
  { elemStruct,		desc_octetString,	sizeof(octetString) },
  { elemCharPtr,	0,			sizeof(char *) },
  { elemCharPtr,	0,			sizeof(char *) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_EapiNamePlusRecord_u_u[] = {
  { elemStruct,		desc_EapiRecord,	sizeof(struct EapiRecord) },
  { elemStructPtr,	desc_EapiDiagRec,	sizeof(EapiDiagRec *) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_EapiNamePlusRecord[] = {
  { elemEnum,		0,		sizeof(EapiNamePlusRecordKind) },
  { elemUnion,		desc_EapiNamePlusRecord_u_u, sizeof(struct EapiNamePlusRecord_u_u *), 0},
  { elemStructPtr,	desc_EapiNamePlusRecord, sizeof(EapiNamePlusRecord *) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_EapiDiagRec[] = {
  { elemCharPtr,	0,			sizeof(char *) },
  { elemInt,		0,			sizeof(int) },
  { elemCharPtr,	0,			sizeof(char *) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_DeleteResultSetRequest[] = { 
  { elemBoolean,	0,			sizeof(Boolean) }, 
  { elemInt,		0,			sizeof(int) }, 
  { elemDone, 		0, 			0 } 
};

elemDesc desc_DeleteResultSetResponse[] = {
  { elemBoolean,	0,			sizeof(Boolean) }, 
  { elemDone, 		0, 			0 } 
};

elemDesc desc_InterruptRequest[] = {
  { elemInt,		0,			sizeof(int) }, 
  { elemDone, 		0, 			0 } 
};

elemDesc desc_InterruptResponse[] = {
  { elemBoolean,	0,			sizeof(Boolean) }, 
  { elemDone, 		0, 			0 } 
};

elemDesc desc_EapiPacket_u_u[] = {
  { elemStructPtr,   	desc_SearchRequest,  	sizeof(SearchRequest) },  
  { elemStructPtr,   	desc_SearchResponse,  	sizeof(SearchResponse) },  
  { elemStructPtr,   	desc_PresentRequest,	sizeof(PresentRequest) },  
  { elemStructPtr,   	desc_PresentResponse,	sizeof(PresentResponse) },  
  { elemStructPtr,   	desc_DeleteResultSetRequest, sizeof(DeleteResultSetRequest) },  
  { elemStructPtr,   	desc_DeleteResultSetResponse, sizeof(DeleteResultSetResponse) },  
  { elemStructPtr,   	desc_InterruptRequest,	sizeof(InterruptRequest) },  
  { elemStructPtr,   	desc_InterruptResponse,	sizeof(InterruptResponse) },  
  { elemStructPtr,   	desc_OpenRequest,	sizeof(OpenRequest) },  
  { elemStructPtr,   	desc_OpenResponse,	sizeof(OpenResponse) },  
  { elemStructPtr,   	desc_CloseRequest,	sizeof(CloseRequest) },  
  { elemStructPtr,   	desc_CloseResponse,	sizeof(CloseResponse) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_EapiPacket[] = {
  { elemEnum,   	0,		  	sizeof(EapiTypes) },  
  { elemInt,	   	0,		  	sizeof(int) },  
  { elemUnion,   	desc_EapiPacket_u_u,	0,			0 },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_OpenRequest[] = {
  { elemInt,	       	0,			sizeof(int) },
  { elemDone,	       	0,			0 },
};

elemDesc desc_OpenResponse[] = {
  { elemBoolean,       	0,			sizeof(Boolean) },
  { elemCharPtr,       	0,			sizeof(char *) },
  { elemDone,	       	0,			0 },
};

elemDesc desc_CloseRequest[] = {
  { elemInt,	       	0,			sizeof(int) },
  { elemDone,	       	0,			0 },
};

elemDesc desc_CloseResponse[] = {
  { elemBoolean,	0,			sizeof(Boolean) },
  { elemCharPtr,	0,			sizeof(char *) },
  { elemDone,	       	0,			0 },
};


/* Structures from sr-api.h */

elemDesc desc_RCNameAndId[] = {
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemStructPtr,	desc_RCNameAndId,	sizeof(struct RCNameAndId *), 0},
  { elemDone,		0,			0,			0 }
};

elemDesc desc_RecordComposition_u_u[] = {
  { elemStructPtr,	desc_RCNameAndId,	sizeof(struct RCNameAndId *), 0},
  { elemCharPtr,	0,			sizeof(char *),		0 },
  { elemDone,		0, 			0,			0 }
};

elemDesc desc_RecordComposition[] = {
  { elemBoolean,	0,			sizeof(Boolean),	0 },
  { elemUnion,		desc_RecordComposition_u_u,	0,		0 },
  { elemDone,		0,			0,			0 }
};

elemDesc desc_Query_u_q[] = {
  { elemStructPtr,      desc_RPNQuery,          sizeof(RPNQuery *) },
  { elemStructPtr,      desc_octetString,       sizeof(octetString *) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_Query[] = {
  { elemEnum,   	0,		  	sizeof(queryType) },  
  { elemUnion,   	desc_Query_u_q,	  	0,			0 },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_RPNQuery[] = {
  { elemCharPtr,   	0,		  	sizeof(char *) },  
  { elemStructPtr,   	desc_RPNStructure, 	sizeof(RPNStructure *) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_AttributeElement[] = {
  { elemInt,	   	0,		  	sizeof(int) },  
  { elemInt,	   	0,		  	sizeof(int) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_AttributeList[] = {
  { elemStructPtr,   	desc_AttributeElement, 	sizeof(AttributeElement *) },  
  { elemStructPtr,   	desc_AttributeList,	sizeof(AttributeList *) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_AttributesPlusTerm[] = {
  { elemStructPtr,   	desc_AttributeList,  	sizeof(AttributeList *) },  
  { elemStructPtr,   	desc_octetString,	sizeof(octetString *) },  
  { elemStructPtr,   	desc_AttributesPlusTerm,sizeof(AttributesPlusTerm *) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_Operand[] = {
  { elemEnum,   	0,		  	sizeof(operandType) },  
  { elemStructPtr,   	desc_AttributesPlusTerm,sizeof(AttributesPlusTerm) },  
  { elemCharPtr,   	0,		  	sizeof(char *) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_RPNStructure_u_u[] = {
  { elemStructPtr,   	desc_Operand,	  	sizeof(Operand *) },  
  { elemStructPtr,   	desc_RPNStructure,  	sizeof(RPNStructure *) },  
  { elemStructPtr,   	desc_RPNStructure,  	sizeof(RPNStructure *) },  
  { elemEnum,   	0,		  	sizeof(Operator) },  
  { elemDone, 		0, 			0 } 
};


elemDesc desc_RPNStructure[] = {
  { elemEnum,   	0,		  	sizeof(RPNStructureType) },  
  { elemUnion,   	desc_RPNStructure_u_u,	0,				0 },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_DiagRec[] = {
  { elemCharPtr,   	0,		  	sizeof(char *) },  
  { elemInt,	   	0,		  	sizeof(int) },  
  { elemCharPtr,   	0,		  	sizeof(char *) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_NamePlusRecord_u_u[] = {
  { elemStructPtr,   	desc_EXTERN,	  	sizeof(EXTERN *) },  
  { elemStructPtr,   	desc_DiagRec,	  	sizeof(DiagRec *) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_NamePlusRecord[] = {
  { elemCharPtr,   	0,		  	sizeof(char *) },  
  { elemEnum,   	0,		  	sizeof(nprRecord) },  
  { elemUnion,   	desc_NamePlusRecord_u_u, 0,			1 },  
  { elemStructPtr,   	desc_NamePlusRecord,	sizeof(NamePlusRecord *) },  
  { elemDone, 		0, 			0 } 
};

#if 0
elemDesc desc_Records_u_u[] = {
  { elemStructPtr,   	desc_NamePlusRecord,	sizeof(NamePlusRecord *) },  
  { elemStructPtr,   	desc_DiagRec,		sizeof(DiagRec *) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_Records[] = {
  { elemEnum,   	0,		  	sizeof(recNamePlusRecord) },  
  { elemUnion,   	desc_Records_u_u,  	0,			0 },  
  { elemDone, 		0, 			0 } 
};
#endif

elemDesc desc_EXTERN[] = {
  { elemCharPtr,   	0,		  	sizeof(char *) },  
  { elemInt,	   	0,		  	sizeof(int) },  
  { elemStructPtr,   	desc_octetString,  	sizeof(octetString *) },  
  { elemEnum,   	0,		  	sizeof(externEncodeType) },  
  { elemStructPtr,   	desc_octetString,  	sizeof(octetString *) },  
  { elemDone, 		0, 			0 } 
};
#endif
