/*
 * common-structs.h,v 1.1 1994/01/28 17:05:57 franktor Exp
 *
 * EAPI definitions:
 */

#ifndef COMMON_STRUCTS_H
#define COMMON_STRUCTS_H

#include <sr-api.h>

typedef struct DatabaseName {
  char *database;
  struct DatabaseName *next;
} DatabaseName;

typedef enum HlvlRecordKind {
  recHlvlNamePlusRecord = 0, recHlvlNonSurrogateDiagRec = 1
} HlvlRecordKind;

typedef struct HlvlRecords {
  HlvlRecordKind recKind;
  union {
    struct HlvlNamePlusRecord *databaseOrSurDiagnostics;
    struct HlvlDiagRec *nonSurrogateDiagnosticRecord;
  } u;
} HlvlRecords;

typedef enum HlvlNamePlusRecordKind {
  recHlvlRecord = 0, recHlvlSurrogateDiagRec = 1
} HlvlNamePlusRecordKind;

typedef struct HlvlNamePlusRecord {
  HlvlNamePlusRecordKind recKind;
  union {
    struct HlvlRecord {
      octetString databaseRecord;
      char *databaseName;
      char *recordSyntax;
    } record;
    struct HlvlDiagRec *surrogateDiagnostic;
  } u;
  struct HlvlNamePlusRecord *next;
} HlvlNamePlusRecord;

typedef struct HlvlDiagRec {
  char *diagnosticSetId;		/* OID name, ie "DIAGSET BIB1" */
  int condition;			/* may change in the future */
  char *addinfo;
} HlvlDiagRec;

#endif /* COMMON_STRUCTS_H */
