/*
 * gets.c,v 1.1 1994/01/28 17:04:58 franktor Exp
 *
 * gets.c  -  Prompt the user for a line of text and return it.
 *		This is a simple interface to the GNU readline library.
 *
 * Copyright (C) 1990,1992 UNINETT
 *
 * Geir Pedersen, Geir.Pedersen@usit.uio.no
 *
*/

#include <stdio.h>

#ifdef USE_READLINE

extern int	rl_bind_key (), *rl_insert ();
extern char	*readline ();
extern 		add_history ( );

void gnu_gets_setup ()
{
   rl_bind_key ( '\t', rl_insert );
}

#endif


char *gnu_gets ( prompt, from, buf, len )
   char			*prompt;
   FILE			*from;
   char	   		*buf;
   int               	len;
{
#ifndef USE_READLINE
   if ( from == stdin )
   {
      fputs ( prompt, stdout );
      fflush ( stdout );
   }
#else
   static char          *gets_line      = (char *) NULL;

   if ( from != stdin )
#endif
   {
      char	*cp;

      if ( !fgets ( buf, len, from ) )
	 return (char *) NULL;
      if ( (cp = (char *) index ( buf, '\n' )) )
	 *cp = '\0';
      return buf;
   }

#ifdef USE_READLINE
   if ( gets_line != (char *) NULL )
      free ( gets_line );

   gets_line = readline ( prompt );

   if ( gets_line && *gets_line )
      add_history ( gets_line );

   if ( gets_line )
   {
      strncpy ( buf, gets_line, len );
      return buf;
   }
   else
      return (char *) NULL;

#endif
}
