VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRemote"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Function LookupRemotePath() As String
    On Error Resume Next

    '** Returns the remote path for files to be saved
    '** and the location of the "poll.dat" file

    'Holds the final remote file path to save the info
    Dim sRemotePath As String
    
    'Holds next available file number
    Dim lFreeFile As Long
    
    'Holds each entire config line
    Dim sConfig As String

    'Holds the split config information
    Dim aConfig As Variant
    
    'Open the local config file to get the remote
    'location for saving the information
    '===================================================
    If Dir(App.Path & "\config.ini", vbNormal) <> "" Then
        'Get the next free file number
        lFreeFile = FreeFile
        
        'Open the local INI file
        Open App.Path & "\config.ini" For Input As lFreeFile
        
        'Get the first (only) line
        Line Input #lFreeFile, sConfig
        
        'Close the file
        Close lFreeFile
        
        'Split the input line by "="
        aConfig = Split(sConfig, "=", , vbTextCompare)
        
        'See if the remote file (specified in the local INI) is accessible
        If Dir(aConfig(1), vbNormal) <> "" Then
            'Get the next free file number
            lFreeFile = FreeFile
        
            'Open the remote INI file
            Open aConfig(1) For Input As lFreeFile
        
            'Get the first (only) line
            Line Input #lFreeFile, sConfig
            
            'Close the file
            Close lFreeFile
            
            'Split the input line by "="
            aConfig = Split(sConfig, "=", , vbTextCompare)

            'aConfig(1) should now contain the remote path to save
            'the data (text) files
            LookupRemotePath = aConfig(1)
        Else
            'Call error handler
            'Remote INI file doesn't exist
        End If
        
    Else
        'Call error handler
        'Local INI file doesn't exist
    End If

End Function

Public Function GetPollStatus() As Boolean
    On Error Resume Next

    Dim sRemotePath As String
    Dim lFreeFile As Long
    Dim sRemotePollData As String
    Dim sLocalPollData As String
    
    sRemotePath = LookupRemotePath

    If Dir(sRemotePath & "\poll.dat", vbNormal) <> "" Then
        'Get the remote poll dat string
        lFreeFile = FreeFile
        Open sRemotePath & "\poll.dat" For Input As lFreeFile
        Line Input #lFreeFile, sRemotePollData
        Close lFreeFile
        
        'Get the local poll dat string
        lFreeFile = FreeFile
        Open App.Path & "\poll.dat" For Input As lFreeFile
        Line Input #lFreeFile, sLocalPollData
        Close lFreeFile
        
        'Compare local to remote
        If sRemotePollData <> sLocalPollData Then
            'They are not the same, ok to save data
            Open App.Path & "\poll.dat" For Output As lFreeFile
            
            'Update the poll data to the local file
            Print #lFreeFile, sRemotePollData
            
            Close #1
            
            'The file exists, ok to write data
            GetPollStatus = True
        Else
            'They are the same, not ok to save data
            GetPollStatus = False
        End If
    Else
        'Call error handler
        'The poll data file does not exist
        
        'Don't allow a save
        GetPollStatus = False
    End If
End Function

Public Function GetRemoteErrorPath() As String
    On Error Resume Next
    
    'Return the full path and file name to the error log

    Dim sRemotePath As String
    
    sRemotePath = LookupRemotePath & "\rsi_error.log"
    
    GetRemoteErrorPath = sRemotePath
End Function


Public Function GetRemoteFilePath(sFileName As String) As String
    On Error Resume Next
    
    Dim sRemotePath As String
    
    'Save to the "data" sub folder
    sRemotePath = LookupRemotePath & "\Data"

    'See if we can reach the remote location to save the data.
    'If not we will just save the info locally.
    '===================================================
    If Dir(sRemotePath, vbDirectory) <> "" Then
        'Build the complete remote file path
        GetRemoteFilePath = sRemotePath & "\" & sFileName & ".rsi"
    Else
        'Call error handler, path can not be accessed. (Raise Error)
        
    End If
End Function
