////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// Item.cpp : Implementation of CIItem
#include "stdafx.h"
#include "CuteControls.h"
#include "Item.h"
#include "CuteBar.h"
#include "Combo.h"
#include "Edit.h"


/////////////////////////////////////////////////////////////////////////////
// CIItem
 CIItem::CIItem()
{
    m_pComboObj = NULL;
    m_pEditObj = NULL;
}
CIItem::~CIItem()
{
   if(m_pComboObj)
       m_pComboObj->Release();
   if (m_pEditObj)
       m_pEditObj->Release();
}

HRESULT CIItem::IPersistStreamInit_Load(LPSTREAM pStm, ATL_PROPMAP_ENTRY* pMap)
{
    HRESULT hr = S_OK;
    hr = IPersistStreamInitImpl<CIItem>::
                            IPersistStreamInit_Load( pStm, pMap);
    if(FAILED(hr))
        return hr;

    AFX_MANAGE_STATE(AfxGetStaticModuleState())
    try
    {
        COleStreamFile File;
        File.Attach(pStm);
        CArchive ar(&File,CArchive::load);
        Serialize(ar);
        ar.Close();
        File.Detach();
    }
    catch(CFileException* e)
    {
        e->Delete();
        hr = E_FAIL;
    }

    if(FAILED(hr))
        return hr;

    enItemType type = m_ItemType;
    if (type == ccTypeComboBox)
    {
        if(FAILED(CreateComboObj()))
            return E_FAIL;
        try
        {
            COleStreamFile File;
            File.Attach(pStm);
            CArchive ar(&File,CArchive::load);
            m_pComboObj->Serialize(ar);
            ar.Close();
            File.Detach();
        }
        catch(CFileException* e)
        {
            e->Delete();
            return E_FAIL;
        }
    }
    else if (type ==  ccTypeEdit)
    {
        if(FAILED(CreateEditObj()))
            return E_FAIL;

        try
        {
            COleStreamFile File;
            File.Attach(pStm);
            CArchive ar(&File,CArchive::load);
            m_pEditObj->Serialize(ar);
            ar.Close();
            File.Detach();
        }
        catch(CFileException* e)
        {
            e->Delete();
            hr = E_FAIL;
        }
    }
 
    return hr;
}

HRESULT CIItem::IPersistStreamInit_Save(LPSTREAM pStm, BOOL fClearDirty, ATL_PROPMAP_ENTRY* pMap)
{
    HRESULT hr = S_OK;
    hr = IPersistStreamInitImpl<CIItem>::
                            IPersistStreamInit_Save( pStm, fClearDirty, pMap);
    if(FAILED(hr))
        return hr;

    AFX_MANAGE_STATE(AfxGetStaticModuleState())
    try
    {
        COleStreamFile File;
        File.Attach(pStm);
        CArchive ar(&File,CArchive::store);
        Serialize(ar);
        ar.Close();
        File.Detach();
        
    }catch(CFileException* e)
    {
        e->Delete();
        hr = E_FAIL;
    }

    if(FAILED(hr))
        return hr;

    if (m_ItemType == ccTypeComboBox)
    {
        try
        {
            COleStreamFile File;
            File.Attach(pStm);
            CArchive ar(&File,CArchive::store);
            m_pComboObj->Serialize(ar);
            ar.Close();
            File.Detach();
        }
        catch(CFileException* e)
        {
            e->Delete();
            hr = E_FAIL;
        }
    }
    else if (m_ItemType == ccTypeEdit)
    {
        try
        {
            COleStreamFile File;
            File.Attach(pStm);
            CArchive ar(&File,CArchive::store);
            m_pEditObj->Serialize(ar);
            ar.Close();
            File.Detach();
        }
        catch(CFileException* e)
        {
            e->Delete();
            hr = E_FAIL;
        }
    }
    return hr;
}

STDMETHODIMP CIItem::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IItem
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

STDMETHODIMP CIItem::get_Type(enItemType *pVal)
{
    *pVal = m_ItemType;
	return S_OK;
}

STDMETHODIMP CIItem::put_Type(enItemType newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    if (m_ItemType == newVal || newVal > ccTypeSeparator ) 
	    return S_OK;
    enItemType type = m_ItemType; 
    switch (newVal)
    {

    case ccTypeButton:
    case ccTypeToggleButton:
    case ccTypeDropDown:
    case ccTypeToggleDropDown:
    case ccTypeSeparator:
        if (type != ccTypeComboBox && type != ccTypeEdit )
            m_ItemType = newVal;
        break;
    }
	return S_OK;
}

STDMETHODIMP CIItem::get_ID(long *pVal)
{
    *pVal = m_ID;
	return S_OK;
}

STDMETHODIMP CIItem::put_ID(long newVal)
{
    m_ID = newVal;
	return S_OK;
}

STDMETHODIMP CIItem::get_Name(BSTR *pVal)
{
    CComBSTR bstr;
    bstr.Append((LPCSTR)m_strName);
    *pVal = bstr.Copy();

	return S_OK;
}

STDMETHODIMP CIItem::put_Name(BSTR newVal)
{
    CComBSTR bstr;
    bstr.AppendBSTR( newVal);
    m_strName = bstr;

	return S_OK;
}

STDMETHODIMP CIItem::get_Description(BSTR *pVal)
{
    CComBSTR bstr;
    bstr.Append((LPCSTR)m_strDesc);
    *pVal=bstr.m_str;
    
	return S_OK;
}

STDMETHODIMP CIItem::put_Description(BSTR newVal)
{
    CComBSTR bstr;
    bstr.AppendBSTR( newVal);
    m_strDesc = bstr;

	return S_OK;
}

STDMETHODIMP CIItem::get_ToolTip(BSTR *pVal)
{
    CComBSTR bstr;
    bstr.Append((LPCSTR)m_strToolTip);
    *pVal=bstr.m_str;

	return S_OK;
}

STDMETHODIMP CIItem::put_ToolTip(BSTR newVal)
{
    CComBSTR bstr;
    bstr.AppendBSTR( newVal);
    m_strToolTip = bstr;

	return S_OK;
}

STDMETHODIMP CIItem::get_AccelKey(long *pVal)
{
    *pVal = m_AccelKey;
	return S_OK;
}

STDMETHODIMP CIItem::put_AccelKey(long newVal)
{
    m_AccelKey = newVal;
	return S_OK;
}

STDMETHODIMP CIItem::get_Enabled(VARIANT_BOOL *pVal)
{
    *pVal = m_bEnabled ? VARIANT_TRUE: VARIANT_FALSE;

	return S_OK;
}

STDMETHODIMP CIItem::put_Enabled(VARIANT_BOOL newVal)
{
    m_bEnabled = newVal == VARIANT_TRUE ? TRUE : FALSE;
	return S_OK;
}

STDMETHODIMP CIItem::get_Visible(VARIANT_BOOL *pVal)
{
    *pVal = m_bVisible ? VARIANT_TRUE: VARIANT_FALSE;
	return S_OK;
}

STDMETHODIMP CIItem::put_Visible(VARIANT_BOOL newVal)
{
    m_bVisible = newVal == VARIANT_TRUE ? TRUE : FALSE;

	return S_OK;
}

STDMETHODIMP CIItem::get_Style(enItemStyle *pVal)
{
    *pVal = m_ItemStyle;
	return S_OK;
}

STDMETHODIMP CIItem::put_Style(enItemStyle newVal)
{
    m_ItemStyle = newVal;
	return S_OK;
}

STDMETHODIMP CIItem::get_State(long *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

   *pVal = GetButtonState();
	return S_OK;
}


STDMETHODIMP CIItem::put_State(long newVal)
{
    m_ItemState = (UINT)newVal;
	return S_OK;
}

STDMETHODIMP CIItem::get_ControlWidth(long *pVal)
{
    *pVal = m_ControlWidth;

	return S_OK;
}

STDMETHODIMP CIItem::put_ControlWidth(long newVal)
{
    m_ControlWidth = newVal;
    m_bDirty = TRUE;
	return S_OK;
}

STDMETHODIMP CIItem::get_Edit(IEdit **pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    if (m_pEditObj == NULL)
        return S_FALSE ;

   return m_pEditObj->QueryInterface(IID_IDispatch,(void**)pVal);
}

STDMETHODIMP CIItem::get_ComboBox(ICombo **pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    if (m_pComboObj == NULL)
        return S_FALSE ;

    return m_pComboObj->QueryInterface(IID_IDispatch,(void**)pVal);
}

STDMETHODIMP CIItem::SetFocus()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    if (m_pComboObj)
        m_pComboObj->SetFocus();

    if (m_pEditObj)
        m_pEditObj->SetFocus();

	return S_OK;
}



STDMETHODIMP CIItem::get_Alignment(enAlignment *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

   *pVal = GetAlign();
	return S_OK;
}

STDMETHODIMP CIItem::put_Alignment(enAlignment newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    SetAlign(newVal);

	return S_OK;
}

STDMETHODIMP CIItem::get_ControlHeight(long *pVal)
{
    *pVal = m_ControlHeight;
	return S_OK;
}

STDMETHODIMP CIItem::put_ControlHeight(long newVal)
{
    m_ControlHeight = newVal;
	return S_OK;
}

STDMETHODIMP CIItem::get_ControlTop(long *pVal)
{
    *pVal = m_ControlTop;
	return S_OK;
}

STDMETHODIMP CIItem::put_ControlTop(long newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    m_ControlTop = newVal;
	return S_OK;
}

STDMETHODIMP CIItem::get_ControlLeft(long *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    *pVal = m_ControlLeft;
	return S_OK;
}

STDMETHODIMP CIItem::put_ControlLeft(long newVal)
{
    m_ControlLeft = newVal;
	return S_OK;
}

STDMETHODIMP CIItem::get_Image(Picture* *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	*pVal = m_spImage;
	if (*pVal != NULL)
		(*pVal)->AddRef();

	return S_OK;
}

STDMETHODIMP CIItem::put_Image(Picture* newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    ASSERT( m_pMainControl);

    CICuteBar* pCtrl = m_pMainControl;

	if (pCtrl->FireOnRequestEdit(DISPID_PICTURE) == S_FALSE)
		return S_FALSE;
	
    m_spImage = 0;

    HRESULT hr = E_FAIL;
    if(SetImage(newVal))
        hr = S_OK ;

	pCtrl->m_bRequiresSave = TRUE;
	pCtrl->FireOnChanged(DISPID_PICTURE);
	pCtrl->FireViewChange();
	pCtrl->SendOnDataChange(NULL);

	return hr;
}

STDMETHODIMP CIItem::putref_Image(Picture* newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    ASSERT( m_pMainControl);
    CICuteBar* pCtrl = m_pMainControl;

	if (pCtrl->FireOnRequestEdit(DISPID_PICTURE) == S_FALSE)
		return S_FALSE;

    m_spImage = newVal;

	pCtrl->m_bRequiresSave = TRUE;
	pCtrl->FireOnChanged(DISPID_PICTURE);
	pCtrl->FireViewChange();
	pCtrl->SendOnDataChange(NULL);
	return S_OK;
}

STDMETHODIMP CIItem::get_ImageHot(Picture* *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	*pVal = m_spImageHot;
	if (*pVal != NULL)
		(*pVal)->AddRef();

	return S_OK;
}

STDMETHODIMP CIItem::put_ImageHot(Picture* newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    ASSERT(m_pMainControl);

    CICuteBar* pCtrl = m_pMainControl;
	if (pCtrl->FireOnRequestEdit(DISPID_PICTURE) == S_FALSE)
		return S_FALSE;
	m_spImageHot = 0;

    HRESULT hr = E_FAIL;
    if(SetImageHot(newVal))
        hr = S_OK ;

	pCtrl->m_bRequiresSave = TRUE;
	pCtrl->FireOnChanged(DISPID_PICTURE);
	pCtrl->FireViewChange();
	pCtrl->SendOnDataChange(NULL);

	return S_OK;
}

STDMETHODIMP CIItem::get_ImageDisabled(Picture **pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	*pVal = m_spImageDsbl;
	if (*pVal != NULL)
		(*pVal)->AddRef();

	return S_OK;
}

STDMETHODIMP CIItem::put_ImageDisabled(Picture *newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    ASSERT(m_pMainControl);

    CICuteBar* pCtrl = m_pMainControl;
	if (pCtrl->FireOnRequestEdit(DISPID_PICTURE) == S_FALSE)
		return S_FALSE;

    m_spImageDsbl = 0;

    HRESULT hr = E_FAIL;
    if(SetImageDsbl(newVal))
        hr = S_OK ;

	pCtrl->m_bRequiresSave = TRUE;
	pCtrl->FireOnChanged(DISPID_PICTURE);
	pCtrl->FireViewChange();
	pCtrl->SendOnDataChange(NULL);

	return S_OK;
}

HRESULT CIItem::FinalConstruct()
{
    return S_OK;
}

void CIItem::FinalRelease()
{
   if(m_spCombo)
       m_spCombo.Release();
   if (m_spEdit)
       m_spEdit.Release();
}

HRESULT CIItem::CreateComboObj()
{
    HRESULT hr = CComObject<CICombo>::CreateInstance(&m_pComboObj);
    if (FAILED(hr))
        return hr;
    hr = m_pComboObj->QueryInterface(&m_spCombo);
    if (FAILED(hr))
        return hr;
    m_spCombo.p->AddRef();

    m_pComboObj->SetMainControl(m_pMainControl);
    m_pComboObj->SetHolder(this);

    return hr;
}

HRESULT CIItem::CreateEditObj()
{
    if (CComObject<CICEdit>::CreateInstance(&m_pEditObj))
        return E_FAIL;

    if (m_pEditObj->QueryInterface(&m_spEdit))
        return E_FAIL;

    m_spEdit.p->AddRef();

    m_pEditObj->SetMainControl(m_pMainControl);
    m_pEditObj->SetHolder(this);

    return S_OK;
}
