////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// CuteBar.h : Declaration of the CICuteBar

#ifndef __CUTEBAR_H_
#define __CUTEBAR_H_

#include "resource.h"       // main symbols
#include <atlctl.h>

#include "BaseFrame.h"
#include "CuteControls.h"
#include "BarCollection.h"
#include "ItemCollection.h"
#include "CuteControlsCP.h"

#define SC_ICONBMP_SIZE 32  //Size of Control presentation image

void  _SetMainControl(CICuteBar* pCtrl);
HBITMAP  _CopyBitmap(HBITMAP hBmpSrc);
void _PixelToTwips(POINT& ptPix, POINT* ptTwips);

extern const float g_Version;
extern float g_VersionRead;
extern const int  g_Build ;

/////////////////////////////////////////////////////////////////////////////
// CICuteBar
class ATL_NO_VTABLE CICuteBar : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CStockPropImpl<CICuteBar, ICuteBar, &IID_ICuteBar, &LIBID_CuteControlsLib>,
//	public IDispatchImpl<ICuteBar, &IID_ICuteBar, &LIBID_CuteControlsLib>,
	public CComControl<CICuteBar>,
	public IPersistStreamInitImpl<CICuteBar>,
	public IOleControlImpl<CICuteBar>,
	public IOleObjectImpl<CICuteBar>,
	public IOleInPlaceActiveObjectImpl<CICuteBar>,
	public IViewObjectExImpl<CICuteBar>,
	public IOleInPlaceObjectWindowlessImpl<CICuteBar>,
	public ISupportErrorInfo,
	public IConnectionPointContainerImpl<CICuteBar>,
	public IPersistStorageImpl<CICuteBar>,
	public ISpecifyPropertyPagesImpl<CICuteBar>,
	public IQuickActivateImpl<CICuteBar>,
	public IDataObjectImpl<CICuteBar>,
	public IPersistPropertyBagImpl<CICuteBar>,
	public IProvideClassInfo2Impl<&CLSID_CuteBar, &DIID__ICuteBarEvents, &LIBID_CuteControlsLib>,
	public IPropertyNotifySinkCP<CICuteBar>,
	public CComCoClass<CICuteBar, &CLSID_CuteBar>,
	public CProxy_ICuteBarEvents< CICuteBar >
{
public:
	CICuteBar()
	{
		m_bWindowOnly = TRUE;

        m_hParent = NULL;
        m_pWindow = NULL;       //init Main Frame class pointer
        m_pInPlaceSite = NULL;
        m_bDesignMode = FALSE;
        m_bToolBarON = FALSE;
        m_bSaveState = FALSE;
        m_bMDI = FALSE;

        m_bLargeIcons = 0;
        m_rcCliArea.SetRectEmpty();

		AFX_MANAGE_STATE(AfxGetStaticModuleState())
		m_ResInst = AfxGetResourceHandle();
        m_hLogoIcon = ::LoadIcon(m_ResInst,MAKEINTRESOURCE(IDI_LICON));
	}
	~CICuteBar()
	{
        ::DeleteObject(m_hLogoIcon);
    }

DECLARE_REGISTRY_RESOURCEID(IDR_CUTEBAR)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CICuteBar)
	COM_INTERFACE_ENTRY(ICuteBar)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IPersistPropertyBag)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY_AGGREGATE(IID_IBarCollection,m_spBarCollection.p)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_PROP_MAP(CICuteBar)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
//   	PROP_ENTRY("Enabled", DISPID_ENABLED, CLSID_NULL)
//   	PROP_ENTRY("LargeIcons", 1, CLSID_NULL)
   	PROP_ENTRY("SaveState", 4, CLSID_NULL)
   	PROP_ENTRY("RegistryCompanyKey", 5, CLSID_NULL)
   	PROP_ENTRY("RegistryApplKey", 6, CLSID_NULL)
	PROP_PAGE(CLSID_BarPropPage)
//	PROP_ENTRY("Font", DISPID_FONT, CLSID_StockFontPage)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
//	 PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(CICuteBar)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	CONNECTION_POINT_ENTRY(DIID__ICuteBarEvents)
END_CONNECTION_POINT_MAP()

BEGIN_MSG_MAP(CICuteBar)
	CHAIN_MSG_MAP(CComControl<CICuteBar>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);

public:
    ULONG InternalRelease();
//	void DestroyAll();
//	BOOL OnResizeBorder(CFrameWnd* pFrame,LPCRECT lpRectBorder);

//--- Stock properties
     BOOL m_bEnabled;
	CComPtr<IFontDisp> m_pFont;
//--- Aggeregated Objects 
    CComPtr<IUnknown> m_spBarCollection;
    CComAggObject<CIBarCollection>* m_pBarCol;

//--- Data Members
	BOOL m_bDesignMode; // current running mode
    BOOL m_bMDI;        // indicates MDI base window
    BOOL m_bSaveState; //  Toolbars dock state prop member
    CComPtr<IOleInPlaceSiteWindowless> m_pInPlaceSite;
//--- Custom properties
    VARIANT_BOOL m_bLargeIcons;

// --- Window data
	CBCBaseFrame*	m_pWindow;
    BOOL        m_bToolBarON;
    HWND        m_hParent;      
    HINSTANCE   m_ResInst;  // resource handle
    HICON       m_hLogoIcon;

    CRect   m_rcCliArea;
protected:
//*** Version Information 
//	void SetSize();
//	BOOL GetRunningMode();
//	BOOL CreateControl(HWND hWndParent, RECT &rcPos);
//	virtual HWND  CreateControlWindow(HWND hWndParent, RECT& rcPos);

/////////////////////////////////////////////////////////////////
/// Implementation

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid)
	{
		static const IID* arr[] = 
		{
			&IID_ICuteBar,
		};
		for (int i=0; i<sizeof(arr)/sizeof(arr[0]); i++)
		{
			if (InlineIsEqualGUID(*arr[i], riid))
				return S_OK;
		}
		return S_FALSE;
	}

// IViewObjectEx -- created by wizard, just no need fot that
//	DECLARE_VIEW_STATUS(0)
//	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// ICuteBar
public:
	void GenHFile(HFILETYPE Type, CString& Buffer);
	void UpdateImages(UINT id);
	STDMETHOD(get_Bars)(/*[out, retval]*/ BarCollection* *pVal);
	STDMETHOD(get_ScaleHeight)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_ScaleWidth)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_ScaleLeft)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_ScaleTop)(/*[out, retval]*/ long *pVal);
	STDMETHOD(Reset)();
	STDMETHOD(get_RegistryApplKey)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_RegistryApplKey)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_RegistryCompanyKey)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_RegistryCompanyKey)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_SaveState)(/*[out, retval]*/ VARIANT_BOOL *pVal);
	STDMETHOD(put_SaveState)(/*[in]*/ VARIANT_BOOL newVal);
	STDMETHOD(AboutBox)();
	STDMETHOD(Refresh)();
	STDMETHOD(get_LargeIcons)(/*[out, retval]*/ VARIANT_BOOL *pVal);
	STDMETHOD(put_LargeIcons)(/*[in]*/ VARIANT_BOOL newVal);
	virtual void FinalRelease();
	virtual HRESULT FinalConstruct();
	BOOL CreateControlBars(CFrameWnd* pWnd);
	void Serialize(CArchive &ar);

HRESULT OnDraw(ATL_DRAWINFO& di)
{
	if (m_bDesignMode)
    {
        RECT& rc = *(RECT*)di.prcBounds;
        COLORREF crColor = ::GetSysColor(COLOR_3DFACE); 
        COLORREF oldColor = ::SetBkColor(di.hdcDraw, crColor);
	    ::ExtTextOut(di.hdcDraw, 0, 0, ETO_OPAQUE, &rc, NULL, 0, NULL);
        ::DrawIconEx(di.hdcDraw, rc.left, rc.top, m_hLogoIcon,
                     rc.right - rc.left, rc.bottom - rc.top,0,NULL,DI_NORMAL);
        ::SetBkColor(di.hdcDraw, oldColor);
    }

    if (m_bToolBarON == FALSE) // User Mode
             m_bToolBarON = CreateControlBars(m_pWindow);

	return S_OK;
}

// Object Close
STDMETHOD(Close)(DWORD dwSaveOption)
{
    DestroyAll();
	CICuteBar* pT = static_cast<CICuteBar*>(this);
	ATLTRACE2(atlTraceControls,2,_T("IOleObjectImpl::Close\n"));
	return pT->IOleObject_Close(dwSaveOption);
}


// IOleInPlaceActiveObjectImpl
BOOL PreTranslateAccelerator(LPMSG pMsg, HRESULT& hRet);

STDMETHOD(OnFrameWindowActivate)(BOOL fActivate )
{
    if (fActivate && m_pWindow)
    {
        AFX_MANAGE_STATE(AfxGetStaticModuleState())
        if (m_bToolBarON == FALSE)
            m_bToolBarON = CreateControlBars(m_pWindow);

        if (m_pWindow && !m_bDesignMode && m_bSaveState && AfxGetApp()->m_pszRegistryKey)
        {
            CDockState DockState;
            DockState.LoadState(AfxGetApp()->m_pszRegistryKey);
            m_pWindow->SetDockState(DockState);
        }
    }
	ATLTRACE2(atlTraceControls,2,_T("IOleInPlaceActiveObjectImpl::OnFrameWindowActivate\n"));
	return S_OK;
}

// IOleControlImpl
STDMETHOD(FreezeEvents)(BOOL bFreeze)
{
    if (bFreeze == FALSE && m_pWindow)
    {
        AFX_MANAGE_STATE(AfxGetStaticModuleState())
//        m_pWindow->RecalcLayout(FALSE); // After form completely loaded
// Force Container reread ACCEL table
//    CComQIPtr<IOleControlSite, &IID_IOleControlSite> spSite(m_spClientSite);
//	if ( spSite != NULL)
//		spSite->OnControlInfoChanged();
    if (m_bToolBarON == FALSE)
        m_bToolBarON = CreateControlBars(m_pWindow);

    m_pWindow->DelayRecalcLayout();       // make sure controls are in place
    }

    return IOleControlImpl<CICuteBar>::FreezeEvents(bFreeze);
}

STDMETHOD(GetControlInfo)(LPCONTROLINFO  pCI );

STDMETHOD(OnMnemonic)(LPMSG  pMsg )
{
    ATLTRACE(_T("CuteBars::OnMnemonic"));

   HRESULT hRet = S_FALSE;
//   PreTranslateAccelerator (pMsg, hRet);
   return hRet;
}
// IOleObject
HRESULT IOleObject_SetClientSite(IOleClientSite *pClientSite);
// IPersistStreamInit
HRESULT IPersistStreamInit_Load(LPSTREAM pStm, ATL_PROPMAP_ENTRY* pMap);
HRESULT IPersistStreamInit_Save(LPSTREAM pStm, BOOL fClearDirty, ATL_PROPMAP_ENTRY* pMap);
HRESULT IPersistPropertyBag_Load(LPPROPERTYBAG pPropBag, LPERRORLOG pErrorLog, ATL_PROPMAP_ENTRY* pMap);
HRESULT IPersistPropertyBag_Save(LPPROPERTYBAG pPropBag, BOOL fClearDirty, BOOL fSaveAllProperties, ATL_PROPMAP_ENTRY* pMap);
// IOleInPlaceObject
HRESULT IOleInPlaceObject_SetObjectRects(LPCRECT prcPos,LPCRECT prcClip);
BOOL OnResizeBorder(CFrameWnd* pFrm, LPCRECT lpRectBorder);

protected:
	HRESULT GetVersion(IStream* pStm);
	HRESULT MarkVersion(IStream* pStm);
	BOOL DestroyToolBars();
    virtual HWND CreateControlWindow(HWND hWndParent, RECT &rcPos);
    void DestroyAll();
    BOOL CreateControl(HWND hWndParent, RECT &rcPos);
    BOOL GetRunningMode();    //  design mode == TRUE;
    void SetSize();

// IBarCollection
};

/////////////////////////////////////////////////////////////////////////////
// CAboutBox
class CAboutBox :
	public CDialogImpl<CAboutBox>
{
public:
    float m_Version;
    int m_Build;

	CAboutBox(float Version,int Build){m_Version = Version; m_Build = Build;}

	enum { IDD = IDD_ABOUT};

BEGIN_MSG_MAP(CAboutBox)
	COMMAND_ID_HANDLER(IDOK, OnOK)
	MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
END_MSG_MAP()

LRESULT OnOK(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);

LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
};

#endif //__CUTEBAR_H_
