// ColorSelector.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "ColorSelector.h"
#include "ToolBarImages.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHColorSelector

CHColorSelector::CHColorSelector()
{
	m_bReady = FALSE;
	m_iSel = 0;

	InitColors ();
}
//*******************************************************************************
CHColorSelector::~CHColorSelector()
{
}

BEGIN_MESSAGE_MAP(CHColorSelector, CButton)
	//{{AFX_MSG_MAP(CHColorSelector)
	ON_WM_ERASEBKGND()
	ON_WM_LBUTTONDOWN()
	ON_WM_SIZE()
	ON_WM_SYSCOLORCHANGE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHColorSelector message handlers

void CHColorSelector::DrawItem (LPDRAWITEMSTRUCT lpDIS)
{
	if (!m_bReady)
	{
		Adjust ();
	}

	CDC* pDC = CDC::FromHandle (lpDIS->hDC);
	ASSERT_VALID (pDC);

	CRect rectClient = lpDIS->rcItem;
	rectClient.bottom = m_Rect [COLORS_NUM - 1].bottom + 3;

	pDC->Draw3dRect (rectClient,
					::GetSysColor (COLOR_3DHILIGHT),
                    ::GetSysColor (COLOR_3DSHADOW));

	//--------------
	// Draw palette:
	//--------------
	for (int i = 0; i < COLORS_NUM; i ++)
	{
		CRect rect = m_Rect [i];
		rect.InflateRect (-1, -1);

		if (i == m_iSel)	// Selected color:
		{
			pDC->Draw3dRect (rect,
							::GetSysColor (COLOR_3DDKSHADOW),
							::GetSysColor (COLOR_3DLIGHT));
			rect.InflateRect (-1, -1);
			pDC->Draw3dRect (rect,
							::GetSysColor (COLOR_3DSHADOW),
							::GetSysColor (COLOR_3DHILIGHT));
			rect.InflateRect (-2, -2); // SDS
		}
		else
		{
			pDC->Draw3dRect (rect,
							::GetSysColor(COLOR_3DSHADOW),    //COLOR_3DHILIGHT),
							::GetSysColor(COLOR_3DHILIGHT));  // COLOR_3DSHADOW));
			rect.InflateRect (-1, -1);
		}

//		rect.InflateRect (-1, -1);
		pDC->FillSolidRect (&rect, m_rgbColors [i]);
	}
}
//*******************************************************************************
#define COLOR_ROWS 5
#define COLOR_COLOMNS 4

void CHColorSelector::Adjust () 
{
	CRect rectClient;	// Client area rectangle
	GetClientRect (&rectClient);

	rectClient.InflateRect (-3, -3);

	CRect rectColors = rectClient;

	int x = rectColors.left;
	int y = rectColors.top;

	int dx;
	int dy;

	if (rectClient.Width () > rectClient.Height ())
	{
		dx = rectColors.Width () / COLOR_ROWS;	// Assume COLORS_NUM = 20! :-(
		dy = rectColors.Height () / COLOR_COLOMNS;	// Assume COLORS_NUM = 20! :-(
	}
	else
	{
		dx = rectColors.Width () / COLOR_ROWS;	// Assume COLORS_NUM = 20! :-(
		dy = rectColors.Height () / COLOR_COLOMNS;	// Assume COLORS_NUM = 20! :-(
	}

	int delta = min (dx, dy);
	for (int i = 0; i < COLORS_NUM; i ++)
	{
		m_Rect [i] = CRect (x, y, x + delta, y + delta);

		x += delta;
		if (x + delta > rectColors.right)
		{
			x = rectColors.left;
			y += delta;
		}
	}

	m_bReady = TRUE;
}
//*******************************************************************************
BOOL CHColorSelector::OnEraseBkgnd(CDC* pDC) 
{
	CRect rectClient;	// Client area rectangle
	GetClientRect (&rectClient);
	pDC->FillSolidRect (&rectClient, ::GetSysColor (COLOR_3DFACE));
#ifdef DRAW_GRID
	//-----------
	// Draw grid:
	//-----------
	rectClient.InflateRect (-2, -2);
	CRect rectDraw = rectClient;

	CPen penGrid (PS_SOLID, 1, ::GetSysColor (COLOR_3DSHADOW));
	CPen* pOldPen = (CPen*) pDC->SelectObject (&penGrid);

	for (int x = rectDraw.left + m_sizeCell.cx; 
		x <= rectDraw.right - m_sizeCell.cx; x += m_sizeCell.cx)
	{
		pDC->MoveTo (x, rectDraw.top + 1);
		pDC->LineTo (x, rectDraw.bottom - 1);
	}

	for (int y = rectDraw.top + m_sizeCell.cy; 
		y <= rectDraw.bottom - m_sizeCell.cy; y += m_sizeCell.cy)
	{
		pDC->MoveTo (rectDraw.left + 1, y);
		pDC->LineTo (rectDraw.right - 1, y);
	}

	pDC->SelectObject (pOldPen);
#endif
	return TRUE;
}
//********************************************************************************
int CHColorSelector::HitTest (POINT point) const
{
	for (int i = 0; i < COLORS_NUM; i ++)
	{
		if (m_Rect [i].PtInRect (point))
		{
			return i;
		}
	}

	return -1;
}
//********************************************************************************
void CHColorSelector::OnLButtonDown(UINT /*nFlags*/, CPoint point) 
{
	int iHit = HitTest (point);
	if (iHit == -1)
	{
		return;
	}

	if (iHit == m_iSel)
	{
		return;
	}

	int iPrevSel = m_iSel;
	m_iSel = iHit;

	InvalidateRect (m_Rect [iPrevSel]);
	InvalidateRect (m_Rect [m_iSel]);
	UpdateWindow ();

	//-------------------------------------------------------
	// Trigger mouse up event (to button click notification):
	//-------------------------------------------------------
	CWnd* pParent = GetParent ();
	if (pParent != NULL)
	{
		pParent->SendMessage (	WM_COMMAND,
								MAKEWPARAM (GetDlgCtrlID (), BN_CLICKED), 
								(LPARAM) m_hWnd);
	}
}
//********************************************************************************
void CHColorSelector::OnSize(UINT nType, int cx, int cy) 
{
	CButton::OnSize(nType, cx, cy);
	Adjust ();
}
//********************************************************************************
void CHColorSelector::InitColors ()
{
	CPalette* pPalSystem = CPalette::FromHandle (
		(HPALETTE) ::GetStockObject (DEFAULT_PALETTE));
	ASSERT (pPalSystem != NULL);

	PALETTEENTRY palEntry;
	for (int i = 0; i < COLORS_NUM; i ++)
	{
		pPalSystem->GetPaletteEntries (i, 1, &palEntry);
		m_rgbColors [i] = CHCToolBarImages::MapToSysColor (
			RGB (palEntry.peRed, palEntry.peGreen, palEntry.peBlue),
			FALSE);
	}
}
//********************************************************************************
void CHColorSelector::OnSysColorChange() 
{
	CButton::OnSysColorChange();
	InitColors ();
}
//********************************************************************************
BOOL CHColorSelector::SelectColor (COLORREF color)
{
	for (int i = 0; i < COLORS_NUM; i ++)
	{
		if (m_rgbColors [i] == color)
		{
			int iPrevSel = m_iSel;
			m_iSel = i;

			InvalidateRect (m_Rect [iPrevSel]);
			InvalidateRect (m_Rect [m_iSel]);
			UpdateWindow ();

			//-------------------------------------------------------
			// Trigger mouse up event (to button click notification):
			//-------------------------------------------------------
			CWnd* pParent = GetParent ();
			if (pParent != NULL)
			{
				pParent->SendMessage (	WM_COMMAND,
										MAKEWPARAM (GetDlgCtrlID (), BN_CLICKED), 
										(LPARAM) m_hWnd);
			}

			return TRUE;
		}
	}

	return FALSE;
}
