////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// BarButton.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "BarButton.h"
#include "Item.h"
#include "CuteBar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

HBITMAP  _CopyBitmap(HBITMAP hBmpSrc);

/////////////////////////////////////////////////////////////////////////////
// CBCBarButton
#define CX__COMBO_CONTROL  120
IMPLEMENT_SERIAL(CBCBarButton, CObject, VERSIONABLE_SCHEMA | 1)

CBCBarButton::CBCBarButton()
{
    m_pMainControl = NULL;
    m_spImage = NULL;
	m_spImageHot = NULL;
	m_spImageDsbl = NULL;

    m_bEnabled = TRUE;
    m_bVisible = TRUE;
    m_ID = 0;
    m_AccelKey = 0;
    m_ItemType = ccTypeButton;
    m_ItemStyle = ccDefaultStyle;
    m_ItemState = ccItemUnpressed;

    m_ControlWidth = CX__COMBO_CONTROL;
    m_ControlHeight = ::GetSystemMetrics(SM_CYCAPTION) + CY_CONTROL_SPACE;
    m_ControlTop = CY_CONTROL_SPACE;
    m_ControlLeft = CX_CONTROL_SPACE;

    m_bDirty = FALSE;
    m_Algn = ccALeft;

}

CBCBarButton::~CBCBarButton()
{
}

/////////////////////////////////////////////////////////////////////////////
// CBCBarButton message handlers

void CBCBarButton::Serialize(CArchive &ar)
{
    CObject::Serialize(ar);

    if (ar.IsStoring())
	{
       ar << m_bEnabled;
       ar << m_bVisible;
       ar << m_ID;
       ar << m_strName;
       ar << m_strToolTip;
       ar << m_strDesc;
       ar << m_ItemType;
       ar << m_ItemStyle;
       ar << m_ItemState;
       ar << m_AccelKey;
       ar << m_ControlWidth;
       ar << m_ControlHeight;
       ar << m_ControlTop;
       ar << m_ControlLeft;
       ar << m_Algn;

       SaveImage(ar, m_spImage);
       SaveImage(ar, m_spImageHot);
       SaveImage(ar, m_spImageDsbl);

        if (m_ItemType == ccTypeLabel)
        {
            m_Label.Serialize(ar);
        }
    }
    else
    {
       ar >> m_bEnabled;
       ar >> m_bVisible;
       ar >> m_ID;
       ar >> m_strName;
       ar >> m_strToolTip;
       ar >> m_strDesc;
       int temp;
       ar >> temp;
       m_ItemType = (enItemType)temp;
       ar >> temp;
       m_ItemStyle = (enItemStyle)temp;
       ar >> m_ItemState;
       ar >> m_AccelKey;
       ar >> m_ControlWidth;
       ar >> m_ControlHeight;
       ar >> m_ControlTop;
       ar >> m_ControlLeft;
       ar >> temp;
       m_Algn = (enAlignment)temp;

       LoadImage(ar, &m_spImage);
       LoadImage(ar, &m_spImageHot);
       LoadImage(ar, &m_spImageDsbl);

        if (m_ItemType == ccTypeLabel)
        {
            m_Label.Serialize(ar);
        }

    }
}

enItemState CBCBarButton::GetButtonState()
{
   return (enItemState)m_ItemState;
}

BOOL CBCBarButton::SetImage(IPictureDisp *pPicture)
{
    BOOL bRet = FALSE;
	if (pPicture)
	{
		CComQIPtr<IPersistStream, &IID_IPersistStream> p(pPicture);
		if (p)
		{
			ULARGE_INTEGER l;
			p->GetSizeMax(&l);
			HGLOBAL hGlob = GlobalAlloc(GHND, l.LowPart);
			if (hGlob)
			{
				CComPtr<IStream> spStream;
				CreateStreamOnHGlobal(hGlob, TRUE, &spStream);
				if (spStream)
				{
					if (SUCCEEDED(p->Save(spStream, FALSE)))
					{
						LARGE_INTEGER l;
						l.QuadPart = 0;
						spStream->Seek(l, STREAM_SEEK_SET, NULL);
						OleLoadPicture(spStream, l.LowPart, FALSE, IID_IPictureDisp, (void**)&m_spImage);
                        bRet = TRUE;
					}
					spStream.Release();
				}
				GlobalFree(hGlob);
			}
		}
	}

    // Update Image dynamically when running
    if (!m_pMainControl->m_bDesignMode && pPicture && m_spImage)
    {
        if ( m_ItemType == ccTypeLabel) 
        {
            HBITMAP hBmp = NULL;
            CComQIPtr<IPicture,&IID_IPicture> pPic(m_spImage);
            if (pPic && SUCCEEDED(pPic->get_Handle((OLE_HANDLE*)&hBmp)) && hBmp)
            {
                m_Label.SetBitmap(_CopyBitmap(hBmp));
            }
        }else
     if ( m_ItemType == ccTypeButton ||  m_ItemType == ccTypeToggleButton ||
          m_ItemType == ccTypeDropDown ||  m_ItemType == ccTypeToggleDropDown)
        {
            m_pMainControl->UpdateImages(m_ID);
        }
     }
    return bRet;
}
BOOL CBCBarButton::SetImageHot(IPictureDisp *pPicture)
{
    BOOL bRet = FALSE;
	if (pPicture)
	{
		CComQIPtr<IPersistStream, &IID_IPersistStream> p(pPicture);
		if (p)
		{
			ULARGE_INTEGER l;
			p->GetSizeMax(&l);
			HGLOBAL hGlob = GlobalAlloc(GHND, l.LowPart);
			if (hGlob)
			{
				CComPtr<IStream> spStream;
				CreateStreamOnHGlobal(hGlob, TRUE, &spStream);
				if (spStream)
				{
					if (SUCCEEDED(p->Save(spStream, FALSE)))
					{
						LARGE_INTEGER l;
						l.QuadPart = 0;
						spStream->Seek(l, STREAM_SEEK_SET, NULL);
						OleLoadPicture(spStream, l.LowPart, FALSE, IID_IPictureDisp, (void**)&m_spImageHot);
                        bRet = TRUE;
					}
					spStream.Release();
				}
				GlobalFree(hGlob);
			}
		}
	}

    // Update Image dynamically when running
    if (!m_pMainControl->m_bDesignMode && pPicture && m_spImage)
    {
     if ( m_ItemType == ccTypeButton ||  m_ItemType == ccTypeToggleButton ||
          m_ItemType == ccTypeDropDown ||  m_ItemType == ccTypeToggleDropDown)
        {
            m_pMainControl->UpdateImages(m_ID);
        }
     }
    return bRet;
}

BOOL CBCBarButton::SetImageDsbl(IPictureDisp *pPicture)
{
    BOOL bRet = FALSE;
	if (pPicture)
	{
		CComQIPtr<IPersistStream, &IID_IPersistStream> p(pPicture);
		if (p)
		{
			ULARGE_INTEGER l;
			p->GetSizeMax(&l);
			HGLOBAL hGlob = GlobalAlloc(GHND, l.LowPart);
			if (hGlob)
			{
				CComPtr<IStream> spStream;
				CreateStreamOnHGlobal(hGlob, TRUE, &spStream);
				if (spStream)
				{
					if (SUCCEEDED(p->Save(spStream, FALSE)))
					{
						LARGE_INTEGER l;
						l.QuadPart = 0;
						spStream->Seek(l, STREAM_SEEK_SET, NULL);
						OleLoadPicture(spStream, l.LowPart, FALSE, IID_IPictureDisp, (void**)&m_spImageDsbl);
                        bRet = TRUE;
					}
					spStream.Release();
				}
				GlobalFree(hGlob);
			}
		}
	}

    // Update Image dynamically when running
    if (!m_pMainControl->m_bDesignMode && pPicture && m_spImage)
    {
     if ( m_ItemType == ccTypeButton ||  m_ItemType == ccTypeToggleButton ||
          m_ItemType == ccTypeDropDown ||  m_ItemType == ccTypeToggleDropDown)
        {
            m_pMainControl->UpdateImages(m_ID);
        }
     }
    return bRet;
}

void CBCBarButton::Update()
{
    if ( m_bDirty == FALSE)
        return;
    // Virtual /-  can be overwritten -/ To add runtime property sincronization
}

enAlignment CBCBarButton::GetAlign()
{
    return m_Algn;
}

void CBCBarButton::SetAlign(enAlignment Algn)
{
     m_Algn = Algn;
}

BOOL CBCBarButton::SaveImage(CArchive &ar, IPictureDisp *pPicDisp)
{
   BOOL bImage = FALSE;
   if (pPicDisp)
       bImage = TRUE;
   ar << bImage;
   LONG size = 0;
   ar << size;
   if (bImage)
   {
       COleStreamFile* pFile = (COleStreamFile*)ar.GetFile();
       IStream* pStream = pFile->GetStream(); 
       ar.Flush();     // Flush seeks back stream pointer 

       CComQIPtr<IPicture,&IID_IPicture> pPic(pPicDisp);
       
       if (pPic)
       {
           HRESULT hr = pPic->SaveAsFile(pStream,TRUE,&size);
           pFile->Seek(-(size + sizeof(size)), CFile::current);
           pStream->Write(&size, sizeof(size),NULL);
           pFile->Seek(size, CFile::current);
       }
       else
       {
           bImage = FALSE;
           ASSERT(FALSE);
           AfxThrowArchiveException(CArchiveException::badClass,NULL);
       }
    }

   return bImage;
}

BOOL CBCBarButton::LoadImage(CArchive &ar, IPictureDisp **pPicDisp)
{
   BOOL bImage;
   ar >> bImage;
   LONG  size;
   ar >> size;
   if (! size)
        bImage = FALSE;

   if (bImage )
   {
       COleStreamFile* pFile = (COleStreamFile*)ar.GetFile();
       IStream* pStream = pFile->GetStream(); 
       ar.Flush();     // Flush seeks back stream pointer

       OleLoadPicture(pStream, size, FALSE, IID_IPictureDisp,(void**)pPicDisp);
   }

   return bImage;   
}

void CBCBarButton::SetMainControl(CICuteBar *pControl)
{
    m_pMainControl = pControl;
}
