////////////////////////////////////////////////////////////////
// Copyright 1999-2001 Dmitri Sviridov, ActiveXStore.com
// 
//
// Bar.cpp : Implementation of CIBar
#include "stdafx.h"
#include <afxpriv.h>
#include "CuteControls.h"
#include "Bar.h"

#include "BarComboButton.h"
#include "Edit.h"
#include "CoreEdit.h"
#include "CoreCombo.h"
#include "CuteBar.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

BEGIN_MESSAGE_MAP(CIBar, CBCToolBarBase)
	//{{AFX_MSG_MAP(CIBar)
	ON_WM_SETTINGCHANGE()
	ON_WM_MOUSEMOVE()
	ON_WM_SHOWWINDOW()
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDOWN()
	ON_NOTIFY_REFLECT(NM_CLICK, OnToolBarBtnClick)
	ON_NOTIFY_REFLECT(NM_RCLICK, OnToolBarBtnClick)
	ON_NOTIFY_REFLECT(TBN_HOTITEMCHANGE, OnHotItemChange)
	ON_NOTIFY_REFLECT(NM_RDBLCLK, OnToolBarBtnDblClick)
	ON_NOTIFY_REFLECT(TBN_DROPDOWN, OnToolBarBtnDropDown)
	ON_NOTIFY_REFLECT(NM_KEYDOWN, OnToolBarOnKeyDown)
	ON_MESSAGE(WM_IDLEUPDATECMDUI, OnIdleUpdateCmdUI)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CIBar
CIBar::CIBar()
{
    m_pMainControl = NULL;
    m_HotID = 0;
    m_bDirty = FALSE;

    m_DockStyle = ccDSAny;
	m_enStyle = ccFlatBar;
    m_enType = ccStandard;
    m_enGripStyle = ccGripSingle;
    m_enMousePointer = ccDefault;
	m_ID = 0;
}

CIBar::~CIBar()
{
    RemoveControls();

    m_spItemCollection.Release();

    if (m_pStringsMap )
        delete m_pStringsMap;
}
        
HRESULT CIBar::IPersistStreamInit_Load(LPSTREAM pStm, ATL_PROPMAP_ENTRY* pMap)
{
    HRESULT hr = S_OK;
    hr = IPersistStreamInitImpl<CIBar>::
                            IPersistStreamInit_Load( pStm, pMap);
    if(FAILED(hr))
        return hr;

    AFX_MANAGE_STATE(AfxGetStaticModuleState())
    try
    {
        COleStreamFile File;
        File.Attach(pStm);
        CArchive ar(&File,CArchive::load);
        Serialize(ar);
        ar.Close();
        File.Detach();

    }
    catch(CFileException* e)
    {
        e->Delete();
        hr = E_FAIL;
    }

    if(FAILED(hr))
        return hr;

    CComPtr<IPersistStream> spPersistStm;
    hr = m_pItemCol->QueryInterface(&spPersistStm);

    if(FAILED(hr))
        return hr;

    m_pItemCol->m_contained.SetMainControl(m_pMainControl);

    return spPersistStm->Load(pStm);
}

HRESULT CIBar::IPersistStreamInit_Save(LPSTREAM pStm, BOOL fClearDirty, ATL_PROPMAP_ENTRY* pMap)
{
    HRESULT hr = S_OK;
    hr = IPersistStreamInitImpl<CIBar>::
                            IPersistStreamInit_Save( pStm, fClearDirty, pMap);
    if(FAILED(hr))
        return hr;


    AFX_MANAGE_STATE(AfxGetStaticModuleState())
    try
    {
        COleStreamFile File;
        File.Attach(pStm);
        CArchive ar(&File,CArchive::store);
        Serialize(ar);
        ar.Close();
        File.Detach();
        
    }catch(CFileException* e)
    {
        e->Delete();
        hr = E_FAIL;
    }

    if(FAILED(hr))
        return hr;

    CComPtr<IPersistStream> spPersistStm;
    hr = m_pItemCol->QueryInterface(&spPersistStm);
    if(FAILED(hr))
        return hr;
    
    return spPersistStm->Save(pStm,fClearDirty);
}
void CIBar::Serialize(CArchive &ar)
{   
    CBCToolBarBase::Serialize(ar);

    if (ar.IsStoring())
	{
        ar << m_enType;
	    ar << m_enStyle;
        ar << m_enGripStyle;
	    ar << m_ID;
        ar << m_enMousePointer;
	}
	else
	{
       int temp;
       ar >> temp;
       m_enType = (enBarType)temp;
	   ar >> temp; 
       m_enStyle = (enBarStyle)temp;
	   ar >> temp;
       m_enGripStyle = (enGripStyle)temp;
	   ar >> m_ID ;
       ar >> temp;
       m_enMousePointer = (enMousePointer)temp;
    }
}

STDMETHODIMP CIBar::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IBar
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}
HRESULT CIBar::FinalConstruct()
{
    HRESULT hr = CComAggObject<CIItemCollection>::CreateInstance(GetUnknown(),&m_pItemCol);
    if (FAILED(hr))
        return hr;
    hr = m_pItemCol->QueryInterface(&m_spItemCollection);

    return hr;
}

void CIBar::FinalRelease()
{
    m_spItemCollection.Release();
}

//////////////////////////////////////////////////////////////////////////

STDMETHODIMP CIBar::get_Style(enBarStyle *pVal)
{
   *pVal = m_enStyle;
	return S_OK;
}
STDMETHODIMP CIBar::put_Style(enBarStyle newVal)
{
    m_enStyle = newVal;
	return S_OK;
}

STDMETHODIMP CIBar::get_ID(long *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

   *pVal = m_ID;
	return S_OK;
}

STDMETHODIMP CIBar::put_ID(long NewVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    m_ID = NewVal;
	return S_OK;
}

STDMETHODIMP CIBar::get_Name(BSTR *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CComBSTR bstr;
    bstr.Append((LPCSTR)m_strName);
    *pVal= bstr.Copy();

	return S_OK;
}

STDMETHODIMP CIBar::put_Name(BSTR newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CComBSTR bstr;
    bstr.AppendBSTR( newVal);
    m_strName = bstr.Copy();
    
	return S_OK;
}

STDMETHODIMP CIBar::get_DockingStyle(long *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    *pVal = m_DockStyle;

	return S_OK;
}

STDMETHODIMP CIBar::put_DockingStyle(long newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    m_DockStyle = newVal;
	return S_OK;
}

STDMETHODIMP CIBar::Refresh()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    if (AfxGetApp()->m_pszRegistryKey)
     {
        CDockState DockState;
        DockState.Clear();
        DockState.SaveState(AfxGetApp()->m_pszRegistryKey);
     }
    UpdateBar();
	return S_OK;
}

STDMETHODIMP CIBar::get_Visible(VARIANT_BOOL *pVal)
{   
    *pVal = m_bVisible ? VARIANT_TRUE: VARIANT_FALSE;
	return S_OK;
}

STDMETHODIMP CIBar::put_Visible(VARIANT_BOOL newVal)
{
	m_bVisible = newVal;
    m_bDirty = TRUE;

	return S_OK;
}

STDMETHODIMP CIBar::get_DockState(enDockState *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    *pVal = GetDockState();
	return S_OK;
}

STDMETHODIMP CIBar::put_DockState(enDockState newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    SetDockState(newVal);
	return S_OK;
}

STDMETHODIMP CIBar::get_ImageHeight(short *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CSize sizeImage = m_sizeImage;
    *pVal = (int) sizeImage.cy;

	return S_OK;
}

STDMETHODIMP CIBar::put_ImageHeight(short newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    SetImageSize(0,newVal);    
	return S_OK;
}

STDMETHODIMP CIBar::get_ImageWidth(short *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CSize sizeImage = m_sizeImage;
    *pVal = (int) sizeImage.cx;

	return S_OK;
}

STDMETHODIMP CIBar::put_ImageWidth(short newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    SetImageSize(newVal,0);
	return S_OK;
}

STDMETHODIMP CIBar::get_ItemHeight(short *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CSize sizeItem = GetButtonSize();
    *pVal = sizeItem.cy;
	return S_OK;
}

STDMETHODIMP CIBar::put_ItemHeight(short newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    SetButtonSize(0,newVal);
	return S_OK;
}

STDMETHODIMP CIBar::get_ItemWidth(short *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CSize sizeItem = GetButtonSize();
    *pVal = sizeItem.cx;
	return S_OK;
}

STDMETHODIMP CIBar::put_ItemWidth(short newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    SetButtonSize(newVal,0);
	return S_OK;
}

STDMETHODIMP CIBar::get_ItemState(long ID, enItemState *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    *pVal = GetButtonState(ID);
	return S_OK;
}

STDMETHODIMP CIBar::put_ItemState(long ID, enItemState newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    SetButtonState(ID,newVal);
	return S_OK;
}

STDMETHODIMP CIBar::get_Type(enBarType *pVal)
{
    *pVal = m_enType;
	return S_OK;
}


STDMETHODIMP CIBar::get_GripStyle(enGripStyle *pVal)
{
    *pVal = m_enGripStyle;
	return S_OK;
}

STDMETHODIMP CIBar::put_GripStyle(enGripStyle newVal)
{
    m_enGripStyle = newVal;
	return S_OK;
}

STDMETHODIMP CIBar::get_Items(ItemCollection **pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    ASSERT(m_spItemCollection);
    return m_spItemCollection->QueryInterface(IID_IDispatch,(void**)pVal);
}

STDMETHODIMP CIBar::get_MousePointer(enMousePointer *pVal)
{
    *pVal = m_enMousePointer;
	return S_OK;
}

STDMETHODIMP CIBar::put_MousePointer(enMousePointer newVal)
{
    m_enMousePointer = newVal;
    m_bDirty = TRUE;
	return S_OK;
}

void CIBar::SetMainControl(CICuteBar *pControl)
{
    m_pMainControl = pControl;
    m_pItemCol->m_contained.SetMainControl(m_pMainControl);
}

STDMETHODIMP CIBar::get_HideControls(VARIANT_BOOL *pVal)
{
	*pVal = m_bHideControls ? VARIANT_TRUE : VARIANT_FALSE;
	return S_OK;
}

STDMETHODIMP CIBar::put_HideControls(VARIANT_BOOL newVal)
{
	m_bHideControls = newVal ? TRUE : FALSE;
	return S_OK;
}

STDMETHODIMP CIBar::get_UseImageList(VARIANT_BOOL *pVal)
{
	*pVal = m_bUseImageList ? VARIANT_TRUE : VARIANT_FALSE;
	return S_OK;
}

STDMETHODIMP CIBar::put_UseImageList(VARIANT_BOOL newVal)
{
	m_bUseImageList = newVal ? TRUE : FALSE;
	return S_OK;
}

BOOL CIBar::ConstructToolBar()
{
    ASSERT(m_pMainControl);
    CFrameWnd* pWnd = m_pMainControl->m_pWindow;
    ASSERT(pWnd);
    Update();

    DWORD dwCtlStyle =0; 
    DWORD dwGripStyle = 0; 
    DWORD dwWndState = CBRS_NOALIGN;
    DWORD dstyle =0;

    // define TB style
    if( m_enStyle == ccFlatBar)
        dwCtlStyle |= TBSTYLE_FLAT;
    else if (m_enStyle == cc3Dbar)
        dwCtlStyle &= ~TBSTYLE_FLAT;

    //Set gripper style
    if (m_enGripStyle == ccGripSingle)
        dwGripStyle |= CBRS_GRIPPER;
    else if(m_enGripStyle == ccGripNone)
        dwGripStyle &= ~CBRS_GRIPPER;

    dwWndState = m_DockState;
    if (m_DockStyle & ccPositionLocked)
       dwWndState &= ~CBRS_FLOATING;
    if (dwWndState & CBRS_FLOATING)
           dwWndState |= WS_VISIBLE;
    if (!m_hWnd)
    {
        if (!Create(pWnd, TBSTYLE_TOOLTIPS|dwCtlStyle, WS_CHILD| dwWndState  
		    | CBRS_TOOLTIPS | CBRS_SIZE_DYNAMIC |dwGripStyle,
            CRect(2,2,2,2), m_ID))
            return FALSE;
    }

    SetOwner(pWnd);    
    LoadToolBar();
    SetWindowText(m_strName);
    HCURSOR hCursor = GetBarCursor(m_enMousePointer);
    if (hCursor)
        DWORD ret = ::SetClassLong(m_hWnd,            // window handle 
                       GCL_HCURSOR,      // change cursor 
                       (LONG) hCursor);   // new cursor 

     // Define docking style and state
    if( m_DockStyle & ccDSLeft)
        dstyle |= CBRS_ALIGN_LEFT;

    if( m_DockStyle & ccDSRight)
        dstyle |= CBRS_ALIGN_RIGHT;

    if( m_DockStyle & ccDSBottom)
        dstyle |= CBRS_ALIGN_BOTTOM;

    if( m_DockStyle & ccDSTop)
        dstyle |= CBRS_ALIGN_TOP;

    if( m_DockStyle & ccDSAny)
        dstyle |= CBRS_ALIGN_ANY;
    EnableDocking(dstyle);

    if (dwWndState & CBRS_FLOATING)
    {
        FloatBar();
    }
    else  if (!(m_DockStyle & ccPositionLocked))
    {
        int DockState = AFX_IDW_DOCKBAR_TOP;
        switch (m_DockState)
        {
            case CBRS_LEFT:
                DockState = AFX_IDW_DOCKBAR_LEFT;
                break;
            case CBRS_TOP:
                DockState = AFX_IDW_DOCKBAR_TOP;
                break;
            case CBRS_RIGHT:
                DockState = AFX_IDW_DOCKBAR_RIGHT;
                break;
            case CBRS_BOTTOM:
                DockState = AFX_IDW_DOCKBAR_BOTTOM;
                break;
            default:
                DockState = AFX_IDW_DOCKBAR_TOP;
        }
        pWnd->DockControlBar(this,DockState);
    }

    int cmd = m_bVisible ? SW_SHOW : SW_HIDE;
    ShowWindow(cmd);

    return TRUE;
}

BOOL CIBar::DestructToolBar()
{    
	// hide first if changing to a new docking site to avoid flashing
	if (IsWindowVisible())
		SetWindowPos(NULL, 0, 0, 0, 0,
			SWP_NOSIZE|SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE|SWP_HIDEWINDOW);

    int nCount = DefWindowProc(TB_BUTTONCOUNT, 0, 0);
    for (int i = 0; i < nCount; i++)
    {
		TBBUTTON button;
		GetButton(nCount -i-1, &button);
        VERIFY(DeleteButton(nCount -i-1));
    }

    if (m_hbmImageWell)
    {
		TBREPLACEBITMAP replaceBitmap;
		replaceBitmap.hInstOld = NULL;
		replaceBitmap.nIDOld = (UINT)m_hbmImageWell;
		replaceBitmap.hInstNew = NULL;
		replaceBitmap.nIDNew = NULL ;
		replaceBitmap.nButtons = 0;
		BOOL bResult = (BOOL)DefWindowProc(TB_REPLACEBITMAP, 0,
			(LPARAM)&replaceBitmap);
	    AfxDeleteObject((HGDIOBJ*)&m_hbmImageWell);
        m_hbmImageWell = NULL;
    }
    RemoveControls();
    ASSERT(m_hWnd);
    return TRUE;
}

LRESULT CIBar::OnIdleUpdateCmdUI(WPARAM wParam, LPARAM)
{
// Syncronize m_bVisible with actual window state.
//*** KLUDGE - when Toolbar is docked VERT, after restoring state,
// it comes up invisible, here to make it visible code checks window state
// to match internal visible flag
    ASSERT(m_pMainControl);
	CFrameWnd* pFrameWnd = GetDockingFrame();
    CComPtr<IBar> pBar;
    HRESULT hr=QueryInterface(IID_IDispatch,(void**)&pBar);

    BOOL bVis = IsVisible();
//	UINT swpFlags = 0;
	if (!m_bVisible && bVis)
//		swpFlags = SWP_HIDEWINDOW;
    {
	    pFrameWnd->ShowControlBar(this, FALSE, FALSE);
	    m_pMainControl->Fire_BarClose(pBar);	
    }
	else if (m_bVisible && !bVis)
    {
        if (IsFloating())
        {
            if (m_bDirty)
            {
	            pFrameWnd->ShowControlBar(this, TRUE, FALSE);
	            m_pMainControl->Fire_BarOpen(pBar);
            }else
            {
                m_bVisible = FALSE;
	            pFrameWnd->ShowControlBar(this, FALSE, FALSE);
	            m_pMainControl->Fire_BarClose(pBar);	
            }
        }
        else
        {
	        pFrameWnd->ShowControlBar(this, TRUE, TRUE);
	        m_pMainControl->Fire_BarOpen(pBar);
        }
    }
//		swpFlags = SWP_SHOWWINDOW;

/*    if (swpFlags != 0)
	{
		SetWindowPos(NULL, 0, 0, 0, 0, swpFlags|
			SWP_NOMOVE|SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
        GetParentFrame()->DelayRecalcLayout();
	}
*/
//****************************************************************
   
   LRESULT result = CControlBar::OnIdleUpdateCmdUI(wParam, NULL);	 
   m_bDirty = FALSE;
   return result;
}

void CIBar::OnUpdateCmdUI(CFrameWnd *pTarget, BOOL bDisableIfNoHndler)
{
    CCToolCmdUI state;
	state.m_pOther = this;

    CComContainedObject< CIItemCollection>* pCol = &m_pItemCol->m_contained;
    int iButton = 0;
    ItemColl::ContainerType::iterator iter = pCol->m_coll.begin();
    CIItem* pItem;
	while (iter != pCol->m_coll.end())
	{
        pItem = *iter;
        if ( pItem->m_ItemType == ccTypeComboBox ||
            pItem->m_ItemType == ccTypeEdit )
        {
            pItem->Update();
        }
		iter++;
	}

	state.m_nIndexMax = (UINT)DefWindowProc(TB_BUTTONCOUNT, 0, 0);
	for (state.m_nIndex = 0; state.m_nIndex < state.m_nIndexMax; state.m_nIndex++)
	{
		// get buttons state
//		TBBUTTON button;
//		_GetButton(state.m_nIndex, &button);
		state.m_nID = GetItemID(state.m_nIndex);
        DWORD fsStyle = GetButtonStyle(state.m_nIndex);

		// ignore separators
		if (!(fsStyle & TBSTYLE_SEP))
		{
			// allow reflections
//			if (CWnd::OnCmdMsg(0,
//				MAKELONG((int)CN_UPDATE_COMMAND_UI, WM_COMMAND+WM_REFLECT_BASE),
//				&state, NULL))
//				continue;
            
			// allow the toolbar itself to have update handlers
			if (CWnd::OnCmdMsg(state.m_nID, CN_UPDATE_COMMAND_UI, &state, NULL))
				continue;
            CBCBarButton* pButton = FindItemByID(state.m_nID);
            if (pButton)
            {
                if (pButton->m_ItemType == ccTypeComboBox &&
                pButton->m_ItemType == ccTypeEdit )
                    continue;
                state.Enable(pButton->m_bEnabled);
                state.Visible(pButton->m_bVisible);

                switch (pButton->m_ItemState)
                {
                case  ccItemUnpressed:
                    state.SetCheck(0);
                    break;
                case  ccItemPressed:
                    state.SetCheck(1);
                    break;
                case  ccItemGrayed:
                    state.SetCheck(2);
                    break;
                default:
                    state.SetCheck(0);
                    break;
                }
                pButton->Update();
                continue;
            }

			// allow the owner to process the update
			state.DoUpdate(pTarget, bDisableIfNoHndler);
		}
	}

}

BOOL CIBar::AddControls()
{
    CComContainedObject< CIItemCollection>* pCol = &m_pItemCol->m_contained;

    // Build Controls
    ItemColl::ContainerType::iterator iter = pCol->m_coll.begin();
	CIItem* pTB;
    while (iter != pCol->m_coll.end())
	{
        pTB = *iter;
        ASSERT(pTB);

        if (pTB->m_ItemType == ccTypeComboBox)
        {
            UINT uiCmdId = pTB->m_ID;
            CRect rect;
            rect.SetRectEmpty();
            rect.top = pTB->m_ControlTop; //CY_CONTROL_SPACE;
            rect.left = pTB->m_ControlLeft;
            rect.right = pTB->m_ControlLeft + pTB->m_ControlWidth + CX_CONTROL_SPACE; // 2*CX_CONTROL_SPACE;
            rect.bottom = pTB->m_ControlTop + pTB->m_ControlHeight; // CY_EDIT_CNTRL + 3;
            InsertControl(pTB, "", rect, uiCmdId,0);
        }
        else if (pTB->m_ItemType == ccTypeEdit)
        {
            UINT uiCmdId = pTB->m_ID;
            CRect rect;
            rect.SetRectEmpty();
            rect.top = pTB->m_ControlTop; //CY_CONTROL_SPACE;
            rect.left = pTB->m_ControlLeft;
            rect.right = pTB->m_ControlLeft + pTB->m_ControlWidth + CX_CONTROL_SPACE; // 2*CX_CONTROL_SPACE;
            rect.bottom = pTB->m_ControlTop + pTB->m_ControlHeight; // CY_EDIT_CNTRL + 3;
            InsertControl(pTB, "", rect, uiCmdId,0);
        }
        else if (pTB->m_ItemType == ccTypeLabel)
        {
            UINT uiCmdId = pTB->m_ID;
            CRect rect;
            rect.SetRectEmpty();
            rect.top = pTB->m_ControlTop; //CY_CONTROL_SPACE;
            rect.left = pTB->m_ControlLeft;
            rect.right = pTB->m_ControlLeft + pTB->m_ControlWidth + CX_CONTROL_SPACE; // 2*CX_CONTROL_SPACE;
            rect.bottom = pTB->m_ControlTop + pTB->m_ControlHeight; // CY_EDIT_CNTRL + 3;
            if (InsertControl(pTB, "", rect, pTB->m_ID,0))
                if(pTB->m_spImage)
                {
                   CComQIPtr<IPicture,&IID_IPicture> spPic(pTB->m_spImage);
                    HBITMAP hBmp = NULL;
                    if (spPic && SUCCEEDED(spPic->get_Handle((UINT*)&hBmp)) && hBmp)
                        pTB->m_Label.SetBitmap(_CopyBitmap(hBmp));
                }
        }
        iter++;
    }

    return TRUE;
}

void CIBar::ControlsToButtons(TBBUTTON* pData)
{
    // Find Custom controls and replace with buttons if VertDock and vise versa
    CComContainedObject< CIItemCollection>* pCol = &m_pItemCol->m_contained;

    CIItem* pTB; 
    int i = 0;
    ItemColl::ContainerType::iterator iter = pCol->m_coll.begin();
	while (iter != pCol->m_coll.end())
	{
        pTB = *iter;
        ASSERT(pTB);

        if ((pTB->m_ItemType == ccTypeComboBox 
            || pTB->m_ItemType == ccTypeEdit)&& m_bHideControls)
//            || pTB->m_ItemType == ccTypeLabel) // supposed that Label is not going to be
                                                 // substituted by button when Docked VERT
        {
                if (!(pData[i].fsStyle & TBSTYLE_SEP))
                {
                    pData[i].fsStyle = TBSTYLE_SEP;
                    pData[i].iBitmap = pTB->m_ControlLeft + pTB->m_ControlWidth + CX_CONTROL_SPACE;
                }
        }
        iter++;i++;
    }
}

void CIBar::PutButtons(TBBUTTON* pData)
{
    int i = 0;

    CComContainedObject< CIItemCollection>* pCol = &m_pItemCol->m_contained;
    ItemColl::ContainerType::iterator iter = pCol->m_coll.begin();
    CIItem* pTB; 
	while (iter != pCol->m_coll.end())
	{
        pTB = *iter;
        ASSERT (pTB);

        if ((pTB->m_ItemType == ccTypeComboBox
            || pTB->m_ItemType == ccTypeEdit)&& m_bHideControls)
 //            || pTB->m_ItemType == ccTypeLabel) // supposed that Label is not going to be
                                                 // substituted by button when Docked VERT
        {
                pData[i].fsStyle = TBSTYLE_CHECK|TBSTYLE_BUTTON;
                pData[i].fsState = TBBS_DISABLED;
                pData[i].iBitmap = pTB->m_nImage;
                pTB->m_ItemState = ccItemUnpressed;
                ATLTRACE("LM_VERTDOCK\n");
        }
        iter++; i++;
    }

}

int CIBar::ShrinkControls(TBBUTTON* pData, DWORD dwMode, int nCount)
{
    CBCBarButton* pTB; 
	int nControlCount = 0;
    CComContainedObject< CIItemCollection>* pCol = &m_pItemCol->m_contained;
    nCount = pCol->m_coll.size();

	for (int i = 0; i < nCount; i++)
    {
		if ((pData[i].fsStyle & TBSTYLE_SEP) && (pData[i].idCommand != 0))
			nControlCount++;
        pTB = FindItemByID(pData[i].idCommand );
        if(pTB && m_bHideControls && (pTB->m_ItemType == ccTypeComboBox 
            || pTB->m_ItemType == ccTypeEdit))
        {
        int nWidth = 0;
        int nHeight = 0;
        CPoint pt;
        ASSERT_VALID (pTB);
        pt = CPoint(pTB->m_ControlLeft, pTB->m_ControlTop);
        CRect rect;
        GetItemRect(i, &rect);
		pt = rect.TopLeft() + pt;
        CWnd* pWnd = GetDlgItem(pData[i].idCommand);
        if (dwMode & LM_VERTDOCK)
        {
            nWidth = 0; nHeight = 0;
			if (pWnd) pWnd->SetWindowPos(NULL, pt.x, pt.y, nWidth, nHeight,
                SWP_NOACTIVATE |SWP_NOZORDER |SWP_HIDEWINDOW); //|SWP_NOSIZE pTB->m_ControlWidth,pTB->m_ControlHeight
            ATLTRACE("LM_VERTDOCK | SetWindowPos = %d,%d,%d,%d \n",pt.x, pt.y, nWidth, nHeight);
        }
        else if (dwMode & (LM_HORZDOCK | LM_HORZ))
        {
            nWidth = pTB->m_ControlWidth;
            nHeight = pTB->m_ControlHeight;
			if (pWnd) pWnd->SetWindowPos(NULL, pt.x, pt.y, nWidth, nHeight,
                            SWP_NOACTIVATE | SWP_NOZORDER |SWP_SHOWWINDOW); //|SWP_NOSIZE pTB->m_ControlWidth,pTB->m_ControlHeight
            ATLTRACE("LM_HORZDOCK | LM_HORZ | SetWindowPos = %d,%d,%d,%d \n",pt.x, pt.y, nWidth, nHeight);
        }
        }
    }
    return nControlCount;
}


CIItem* CIBar::FindItemByID(UINT ID)
{
    CComContainedObject< CIItemCollection>* pCol = &m_pItemCol->m_contained;
    CIItem* pItem = NULL; 
    ItemColl::ContainerType::iterator iter = pCol->m_coll.begin();

    while (iter != pCol->m_coll.end())
	{
		CIItem* pButton = *iter;
        ASSERT (pButton);

        if (pButton->m_ID == ((int)ID))
        {
            pItem = pButton;
            break;
        }
        iter++;
	}

	return pItem;
}

BOOL CIBar::UpdateImage(UINT nID)
{
    UINT nIndex = CommandToIndex( nID );
    if (nIndex == -1)
        return FALSE;

//******* clean up *************
    m_Buttons.RemoveAll();

    m_Images.EraseImages();
    m_Images.SetImageSize(m_sizeImage);

    m_ImagesHot.EraseImages();
    m_ImagesHot.SetImageSize(m_sizeImage);

    m_ImagesDsbl.EraseImages();
    m_ImagesDsbl.SetImageSize(m_sizeImage);

    CComContainedObject< CIItemCollection>* pCol = &m_pItemCol->m_contained;
    CIItem* pTB; 
    ItemColl::ContainerType::iterator iter = pCol->m_coll.begin();

    while (iter != pCol->m_coll.end())
	{
		pTB =*iter;
        ASSERT (pTB);
        UpdateImages(pTB);
        iter++;
    }

   AddReplaceBitmap(m_Images.GetBitmap());
   SetHotImages(m_ImagesHot.GetBitmap());
   SetDsblImages(m_ImagesDsbl.GetBitmap());

   Invalidate();   
   UpdateWindow();
   return TRUE;
}

void CIBar::EraseSep(CDC *pDC)
{
    CComContainedObject< CIItemCollection>* pCol = &m_pItemCol->m_contained;
    int iButton = 0;
    ItemColl::ContainerType::iterator iter = pCol->m_coll.begin();

    while (iter != pCol->m_coll.end())
	{
 		CIItem* pButton = *iter;
        ASSERT (pButton);

       	TBBUTTON Button;
        GetButton(iButton, &Button);
        if ((Button.fsStyle & TBSTYLE_SEP) &&
            (pButton->m_ItemType == ccTypeLabel ||
            pButton->m_ItemType == ccTypeComboBox ||
            pButton->m_ItemType == ccTypeEdit)) 
        {
                UINT nIndex = CommandToIndex( pButton->m_ID );
                if (nIndex != -1)
                {
                    CRect rc;
	                GetItemRect( nIndex, &rc );
		            pDC->FillSolidRect(&rc, ::GetSysColor (COLOR_3DFACE)); 
                }
        }
        iter++; iButton++;
	}
}

void CIBar::Update()
{
    if (m_hWnd)
        DestructToolBar();
//******* clean up *************
    m_Buttons.RemoveAll();

    m_Images.EraseImages();
    m_Images.SetImageSize(m_sizeImage);

    m_ImagesHot.EraseImages();
    m_ImagesHot.SetImageSize(m_sizeImage);

    m_ImagesDsbl.EraseImages();
    m_ImagesDsbl.SetImageSize(m_sizeImage);

    m_AcellKeys.RemoveAll();
//******************************
    CComContainedObject< CIItemCollection>* pCol = &m_pItemCol->m_contained;

    int i = 0;
    ItemColl::ContainerType::iterator iter = pCol->m_coll.begin();
    CIItem* pTB;
    while (iter != pCol->m_coll.end())
	{
        pTB = *iter;
        ASSERT (pTB);

        TBBUTTON tb;
		memset( &tb, 0, sizeof( TBBUTTON ));
        tb.idCommand = pTB->m_ID;
        tb.iBitmap = -1;
        tb.iString = -1;

        switch (pTB->m_ItemType)
        {
        case ccTypeButton:
	        tb.fsStyle = TBSTYLE_BUTTON;
            break;
        case ccTypeToggleButton:
	        tb.fsStyle = TBSTYLE_BUTTON|TBSTYLE_CHECK;
            break;
        case ccTypeDropDown:
	        tb.fsStyle = TBSTYLE_DROPDOWN;
            break;
        case ccTypeToggleDropDown:
	        tb.fsStyle = TBSTYLE_DROPDOWN|TBSTYLE_CHECK;
            break;
        case ccTypeComboBox:
	        tb.fsStyle = TBBS_SEPARATOR;
            break;
        case ccTypeEdit:
	        tb.fsStyle = TBBS_SEPARATOR;
            break;
       case ccTypeLabel:
	        tb.fsStyle = TBBS_SEPARATOR;
            break;
        case ccTypeSeparator:
            pTB->m_ID = 0;
            tb.idCommand = 0;
	        tb.fsStyle = TBSTYLE_SEP;
            break;
       case ccTypeMenu:
	        tb.fsStyle = TBSTYLE_BUTTON;
            break;
        default:
	        tb.fsStyle = TBSTYLE_BUTTON;
            break;
        }

        if ((pTB->m_ItemState & ccItemGroup))
            tb.fsStyle |= TBSTYLE_GROUP;

	    if (pTB->m_ItemState & ccItemUnpressed)
            tb.fsState |= TBSTATE_ENABLED;

        if (pTB->m_ItemState & ccItemPressed)
            tb.fsState |= TBSTATE_CHECKED;

        if (pTB->m_ItemState & ccItemGrayed)
            tb.fsState |= TBSTATE_INDETERMINATE;
            
        if (!pTB->m_bVisible)
		    tb.fsState |=  TBSTATE_HIDDEN;
         else
            tb.fsState |=  TBSTATE_ENABLED;

        tb.iString = -1;
        if (!pTB->m_strName.IsEmpty())
        {
            LPCTSTR lpszText = pTB->m_strName;
	        // add new string if not already in map

		    // initialize map if necessary
		    if (m_pStringsMap == NULL)
			    m_pStringsMap = new CMapStringToPtr;

		    // cache string away in string map
            if ((pTB->m_ItemStyle == ccTextOnly)
                    ||(pTB->m_ItemStyle == ccImageAndText))
            {
	            void* p;
		        m_pStringsMap->SetAt(lpszText, (void*)i);
		        ASSERT(m_pStringsMap->Lookup(lpszText, p));
                tb.iString = i;
//                tb.fsStyle |= TBSTYLE_AUTOSIZE;                
            }
        }
//--- Build image well 
        tb.iBitmap = UpdateImages(pTB); // Returns -1 if no image
        pTB->m_nImage = tb.iBitmap;     // save image index, for future vertdock subst
        m_Buttons.AddTail(tb);

        if ((pTB->m_ItemType != ccTypeSeparator)
            && (pTB->m_AccelKey != 0))
            m_AcellKeys.SetAt(pTB->m_AccelKey,pTB->m_ID);

        iter++; i++;
	}
}

void _HFileString(HFILETYPE Type, CString Name, UINT ID, CString& OutStr);

void CIBar::GenHeader(HFILETYPE Type, CString &Buffer)
{
    _HFileString(Type, m_strName, m_ID, Buffer);

    CComContainedObject< CIItemCollection>* pCol = &m_pItemCol->m_contained;

    CIItem* pTB = NULL;
    ItemColl::ContainerType::iterator iter = pCol->m_coll.begin();
    while (iter != pCol->m_coll.end())
	{
 	    pTB = *iter;
        ASSERT (pTB);
        if (pTB->m_ItemType != ccTypeSeparator)
            _HFileString(Type, pTB->m_strName, pTB->m_ID, Buffer);
        iter++;
	}
}

///////////////////////////////////////////////////////
/// WM Handlers
///
void CIBar::OnToolBarBtnClick(NMHDR* pNMHDR, LRESULT* pRes)
{
	UNUSED_ALWAYS( pRes );

    LPNMHDR	lpnmh = (LPNMHDR) pNMHDR;
    int ID = lpnmh->idFrom;

    ASSERT(m_pMainControl);

    if ( m_HotID == 0)
	     m_pMainControl->Fire_Click();  //click only if no ItmeClick event fired
}

void CIBar::OnToolBarBtnDropDown(NMHDR* pNMHDR, LRESULT* pRes)
{
	UNUSED_ALWAYS( pRes );

	const NMTOOLBAR& nmtb = *(NMTOOLBAR*)pNMHDR;

    if ( nmtb.iItem != 0)
    {
        CIItem* pTB = FindItemByID(nmtb.iItem);
        ASSERT_VALID(pTB);
        ASSERT(m_pMainControl);

        // get location of button
	    CRect rc;
	    GetRect(nmtb.iItem, rc);
	    ClientToScreen(&rc);
        m_pMainControl->m_pWindow->ScreenToClient(&rc);

        CPoint pt(rc.left,rc.bottom);

        CComPtr<IItem> pItem;
        HRESULT hr = pTB->QueryInterface(IID_IDispatch,(void**)&pItem);
        if (SUCCEEDED(hr))
	        m_pMainControl->Fire_ItemDropDown(pItem, pt.x, pt.y);
    }
}

void CIBar::OnToolBarBtnDblClick(NMHDR* pNMHDR, LRESULT* pRes)
{
	UNUSED_ALWAYS( pRes );

    LPNMHDR	lpnmh = (LPNMHDR) pNMHDR;
    int ID = lpnmh->idFrom;

    ASSERT(m_pMainControl);

    if ( m_HotID == 0)
	    m_pMainControl->Fire_DblClick();
    else
    {
        CIItem* pTB = FindItemByID(m_HotID);
        ASSERT(pTB);

        CComPtr<IItem> pItem;
        HRESULT hr = pTB->QueryInterface(IID_IDispatch,(void**)&pItem);
        if (SUCCEEDED(hr))
	        m_pMainControl->Fire_ItemDblClick(pItem);
    }
}
void CIBar::OnHotItemChange(NMHDR* pNMHDR, LRESULT* pRes)
{
	 *pRes = 0; // Allow change hotitem

    LPNMTBHOTITEM	pHotItem = (LPNMTBHOTITEM) pNMHDR;

    int newHotID = pHotItem->idNew;
}

void CIBar::OnMouseMove(UINT nFlags, CPoint point) 
{
    ASSERT(m_pMainControl);
    UINT nfalgs = nFlags & ~(MK_SHIFT|MK_CONTROL);
    m_pMainControl->Fire_MouseMove(nfalgs,_ShiftState(),point.x,point.y);

    int nIndex = SendMessageC(TB_GETHOTITEM);
    if(nIndex != -1 && m_HotID != GetItemID(nIndex))
    {
        // Check first leaving item
        if (m_HotID != 0)
        {
            CIItem* pTB = FindItemByID(m_HotID);
            ASSERT(pTB);

            CComPtr<IItem> pItem;
            HRESULT hr = pTB->QueryInterface(IID_IDispatch,(void**)&pItem);
            if (SUCCEEDED(hr))
                m_pMainControl->Fire_ItemMouseExit(pItem);
        }
        m_HotID = GetItemID(nIndex);
        if (m_HotID != 0)
        {
            CIItem* pTB = FindItemByID(m_HotID);
            ASSERT(pTB);

            CComPtr<IItem> pItem;
            HRESULT hr = pTB->QueryInterface(IID_IDispatch,(void**)&pItem);
            if (SUCCEEDED(hr))
                m_pMainControl->Fire_ItemMouseEnter(pItem);
        }  
    }
    ATLTRACE("m_HotID = %d \n",m_HotID);

    CBCToolBarBase::OnMouseMove(nFlags, point);
}

void CIBar::OnToolBarOnKeyDown(NMHDR* pNMHDR, LRESULT* pRes) 
{
	UNUSED_ALWAYS( pRes );
    LPNMKEY pNMK = (LPNMKEY) pNMHDR;

    UINT key = pNMK->nVKey;
    UINT flag = pNMK->uFlags;
    
    ASSERT(m_pMainControl);

    m_pMainControl->Fire_KeyDown(key, flag);

//	m_pMainControl->Fire_KeyUp(key, flag);
}

void CIBar::OnSettingChange(UINT uFlags, LPCTSTR lpszSection) 
{
	CBCToolBarBase::OnSettingChange(uFlags, lpszSection);
	
}

void CIBar::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CBCToolBarBase::OnShowWindow(bShow, nStatus);
    ASSERT(m_pMainControl);

    CComPtr<IBar> pBar;
    HRESULT hr = QueryInterface(IID_IDispatch,(void**)&pBar);
    if (FAILED(hr))
        return;

    if (bShow)
	    m_pMainControl->Fire_BarOpen(pBar);
    else
	    m_pMainControl->Fire_BarClose(pBar);	
}


void CIBar::OnLButtonUp(UINT nFlags, CPoint point) 
{
    UINT nfalgs = nFlags & ~(MK_SHIFT|MK_CONTROL);
    ASSERT(m_pMainControl);
    m_pMainControl->Fire_MouseUp(nfalgs,_ShiftState(),point.x,point.y);
    
	CBCToolBarBase::OnLButtonUp(nFlags, point);
}

void CIBar::OnLButtonDown(UINT nFlags, CPoint point) 
{
     ASSERT(m_pMainControl);
    UINT nfalgs = nFlags & ~(MK_SHIFT|MK_CONTROL);
    m_pMainControl->Fire_MouseDown(nfalgs,_ShiftState(),point.x,point.y);

	CBCToolBarBase::OnLButtonDown(nFlags, point);
}

void CIBar::OnItemClick(int ID)
{
    ASSERT(ID !=0);

    CIItem* pTB = FindItemByID(ID);
    ASSERT(pTB);

    if(pTB->m_ItemType == ccTypeToggleButton || 
        pTB->m_ItemType == ccTypeToggleDropDown)
    {
        if (pTB->m_ItemState == ccItemPressed)
           pTB->m_ItemState = ccItemUnpressed;
        else if(pTB->m_ItemState == ccItemUnpressed)
           pTB->m_ItemState = ccItemPressed;
    }

   ASSERT(m_pMainControl);
#ifdef SDS
   if(pTB->m_ItemType != ccTypeComboBox && // skip Edit & ComboBox Controls
                        pTB->m_ItemType != ccTypeEdit &&
                        pTB->m_ItemType != ccTypeSeparator)
#endif
                        
        UINT nIndex = CommandToIndex( ID );
       	TBBUTTON Button;
        if (nIndex != -1)
        {
            GetButton(nIndex, &Button);
            if (!(Button.fsStyle & TBSTYLE_SEP))
            {
                CComPtr<IItem> pItem;
                HRESULT hr = pTB->QueryInterface(IID_IDispatch,(void**)&pItem);
               if (SUCCEEDED(hr))
                   m_pMainControl->Fire_ItemClick(pItem);
            }
        }
}

BOOL CIBar::OnButtonCommand(WPARAM wParam, LPARAM lParam)
{
    BOOL bRet = FALSE;

    int ID = LOWORD(wParam);

    CIItem* pTB = FindItemByID(ID);
    if (ID && pTB)
    {
        bRet =TRUE;
        OnItemClick(ID);
    }

    return bRet;
}


BOOL CIBar::TranslateMessage(MSG *pMsg)
{
	UINT msg = pMsg->message;
   	if (m_bVisible && (msg==WM_SYSKEYDOWN  || msg==WM_KEYDOWN))
    {
		WORD vkey = LOWORD(pMsg->wParam);	// get virt key
        WORD wModifiers =_ShiftState();
        UINT vKEY = MAKELPARAM(wModifiers,toupper(vkey));
        UINT ID = 0;
	    if (m_AcellKeys.Lookup(vKEY, ID))
	    {
            OnItemClick(ID);
            return TRUE;
        }
	}
    return FALSE;
}

BOOL CIBar::UpdateBar()
{
    ConstructToolBar();
    return TRUE;
}
