/* This is from lingucomponent-fi 0.1.2 */

/*
 * TM API definitions for OpenOffice
 */

#ifndef _TM_OPENOFFICE_HXX_
#define _TM_OPENOFFICE_HXX_

#define TM_IGNORE_CAPS          (1<<1)
#define TM_IGNORE_DIGITS        (1<<2)

namespace soikko {

struct tm_in_s {
  const unsigned char *buf;
  int buf_len;
};
typedef struct tm_in_s tm_in_t;

struct tm_out_s {
  int status;
  int err_start;
  int err_len;
  unsigned char *change;
};
typedef struct tm_out_s tm_out_t;

typedef int (version_func_type)(void);
typedef int (init_func_type)(void **);
typedef int (terminate_func_type)(void *);
typedef int (open_func_type)(void *, const char *);
typedef int (openhyph_func_type)(void *, const char *);
typedef int (encoding_func_type)(void *, const char *);
typedef int (option_func_type)(void *, const char *, const char *);
typedef int (check_func_type)(void *, const tm_in_t *, tm_out_t *);
typedef int (suggest_func_type) (void *, const char *, int,
				 char *, int, int *);
typedef int (hyphenate_func_type)(void *, const char *, char *);

}

#endif
