! ----------------------------------------------------------------------------
!  GRAMMAR:  Dutch grammar table entries for the standard verbs library.
!
!  Supplied for use with Inform 6                         Serial number 060505
!                                                         Release 6/11
!  (c) Yuri Robbers 2002-2006
!      but freely usable
!  
!  Thanks to Victor Gijsbers for bugfixes and additions
!
!  Based on the English version
!  (c) Graham Nelson 1993-2004
!      but freely usable (see manuals)
! ----------------------------------------------------------------------------
!  The "meta-verbs", commands to the game rather than in the game, come first:
! ----------------------------------------------------------------------------

System_file;

Verb meta 'score'
                *                                -> Score;
Verb meta 'totaalscore' 'totaal' 'fullscore'
                *                                -> FullScore
                * 'score'                        -> FullScore;
Verb meta 'e//' 'quit' 'einde' 'stoppen'
                *                                -> Quit;
Verb meta 'inlezen' 'load' 'restore'
                *                                -> Restore;
Verb meta 'herstart' 'restart'
                *                                -> Restart;
Verb meta 'verifieer' 'verify'
                *                                -> Verify;
Verb meta 'opslaan' 'save'
                *                                -> Save;
Verb meta 'script' 'transcript'
                *                                -> ScriptOn
                * 'uit'                          -> ScriptOff
                * 'aan'                          -> ScriptOn;
Verb meta 'noscript' 'unscript'
                *                                -> ScriptOff;
Verb meta 'superkort' 'kortst' 'superbrief' 'short'
                *                                -> LMode3;
Verb meta 'uitgebreid' 'lang' 'verbose' 'long'
                *                                -> LMode2;
Verb meta 'kort' 'normaal' 'brief' 'normal'
                *                                -> LMode1;
Verb meta 'voornaamwoorden' 'naamwoorden' 'pronouns' 'nouns'
                *                                -> Pronouns;
Verb meta 'waarschuw' 'notify'
                * 'aan'                           -> NotifyOn
                * 'uit'                          -> NotifyOff;
Verb meta 'versie' 'version'
                *                                -> Version;
#IFNDEF NO_PLACES;
Verb meta 'plaatsen' 'locaties' 'places' 'locations'
                *                                -> Places;
Verb meta 'objecten' 'voorwerpen' 'objects'
                *                                -> Objects;
#ENDIF;

! ----------------------------------------------------------------------------
!  Debugging grammar
! ----------------------------------------------------------------------------

#ifdef DEBUG;
Verb meta 'trace' 'spoor'
                *                                -> TraceOn
                * number                         -> TraceLevel
                * 'aan'                          -> TraceOn
                * 'uit'                          -> TraceOff;
Verb meta 'acties' 'handelingen' 'actions'
                *                                -> ActionsOn
                * 'aan'                          -> ActionsOn
                * 'uit'                          -> ActionsOff;
Verb meta 'routines' 'messages' 'berichten' 'boodschappen'
                *                                -> RoutinesOn
                * 'aan'                          -> RoutinesOn
                * 'uit'                          -> RoutinesOff;
Verb meta 'timers' 'daemons' 'demons'
                *                                -> TimersOn
                * 'aan'                          -> TimersOn
                * 'uit'                          -> TimersOff;
Verb meta 'changes' 'veranderingen'
                *                                -> ChangesOn
                * 'aan'                          -> ChangesOn
                * 'uit'                          -> ChangesOff;
Verb meta 'recording' 'opnemen'
                *                                -> CommandsOn
                * 'aan'                          -> CommandsOn
                * 'uit'                          -> CommandsOff;
Verb meta 'replay' 'herhaling'
                *                                -> CommandsRead;
Verb meta 'random' 'willekeurig'
                *                                -> Predictable;
Verb meta 'purloin' 'ontvreemd' 'steel'
                * multi                          -> XPurloin;
Verb meta 'abstract'
                * noun 'to' noun                 -> XAbstract
                * noun 'naar' noun             	 -> XAbstract
                * noun 'tot' noun             	 -> XAbstract;
Verb meta 'tree' 'boom'
                *                                -> XTree
                * noun                           -> XTree;
Verb meta 'goto' 'ganaar'
                * number                         -> Goto;
Verb meta 'gonear' 'gabij'
                * noun                           -> Gonear;
Verb meta 'scope'
                *                                -> Scope
                * noun                           -> Scope;
Verb meta 'showverb' 'toonactie' 'toonwerkwoord'
                * special                        -> Showverb;
Verb meta 'showobj' 'toonobj'
                *                                -> Showobj
                * multi                          -> Showobj;
#endif;

! ----------------------------------------------------------------------------
!  And now the game verbs.
! ----------------------------------------------------------------------------

Verb 'neem' 'pak'
                * multi                          -> Take
                * multi 'op'/'mee'               -> Take
                * multiinside 'van' noun         -> Remove
                * multiinside 'uit' noun         -> Remove
                * noun 'uit'                     -> Open
                * noun 'af'                      -> Disrobe
                * 'inventaris'                   -> Inv;
Verb 'sta'
                *                                -> Exit
                * 'op'                           -> Exit
                * 'op'/'in' noun                 -> Enter;
Verb 'verwijder'
                * held                           -> Disrobe
                * multi                          -> Take
                * multiinside 'van'/'uit' noun   -> Remove;
Verb 'ontkleed' 'ontdraag'
                * held                           -> Disrobe; 
Verb 'draag' 'kleed'
                * held                           -> Wear;
Verb 'leg' 'plaats' 'hang'
    		* multiheld                      -> Drop
                * multiexcept 'in'/'binnenin' noun
                                                 -> Insert
                * multiexcept 'aan'/'op' noun    -> PutOn
                * 'neer' multiheld               -> Drop
    		* multiheld 'neer'/'weg'/'opzij' -> Drop
                * multiheld 'op' 'de' 'grond'    -> Drop;
Verb 'leeg'
                * noun                           -> Empty
                * noun 'in'/'op'/'boven' noun    -> EmptyT;
Verb 'verplaats'
                * noun 'naar'/'tot' noun         -> Transfer;
Verb 'drop' 'gooi' 'verlies' 'werp'
                * multiheld                      -> Drop
                * multiheld 'neer'/'weg'         -> Drop
                * 'neer'/'weg' multiheld         -> Drop
                * multiexcept 'in' noun          -> Insert
                * multiexcept 'op' noun          -> PutOn
                * held 'naar'/'tegen' noun       -> ThrowAt;

Verb 'geef' 'betaal' 'offreer' 'voed' 'bied' 'voer'
                * held 'aan' creature            -> Give
                * held 'aan' 'aan' creature      -> Give
                * creature held                  -> Give reverse;
Verb 'toon' 'presenteer' 'etaleer'
                * creature held                  -> Show reverse
                * held 'aan' creature            -> Show;
[ ADirection; if (noun in compass) rtrue; rfalse; ];
Verb 'ga' 'loop' 'ren' 'sluip' 'wandel' 'treed' 'stap' 'naar'
                *                                -> VagueGo
                * noun=ADirection                -> Go
		* 'in'/'binnen'/'erin'           -> GoIn
		* 'naar' 'binnen'                -> GoIn
		* noun 'in'/'binnen'             -> Enter
                * 'in'/'naar'/'binnen'/'door' noun
                                                 -> Enter
		* 'uit'/'buiten'/'eruit'         -> Exit
		* 'naar' 'buiten'                -> Exit
		* noun 'uit'                     -> Exit
		* 'uit' noun                     -> Exit
                * noun                           -> Enter
                * noun 'op'                      -> Climb
                * 'in'/'op' noun 'zitten'/'liggen'/'staan'
                                                 -> Enter;
Verb 'verlaat' 'vertrek'
                *                                -> VagueGo
                * noun=ADirection                -> Go
                * noun                           -> Exit
                * 'naar'/'in'/'binnen'/'door' noun
                                                 -> Enter;
Verb 'inventory' 'inventaris' 'inv' 'i//'
                *                                -> Inv
                * 'hoog'/'tall'                  -> InvTall
                * 'breed'/'wide'                 -> InvWide;
Verb 'kijk' 'k//'
                *                                -> Look
                * 'rond'                         -> Look
                * 'de' 'kamer' 'rond'            -> Look
                * 'naar' noun                    -> Examine
                * 'in'/'op'/'binnenin'/'tussen'/'door' noun
                                                 -> Search
                * 'onder' noun                   -> LookUnder;
Verb 'zoek' 'lees'
                * noun                           -> Examine
                * 'in'/'naar' noun               -> Search
                * 'op'/'naar'/'over' topic 'in' noun
                                                 -> Consult
                * topic 'in' noun                -> Consult
                * topic 'op' 'in' noun           -> Consult
                * 'in' noun topic 'op'           -> Consult
                * 'in' noun 'naar'/'over' topic  -> Consult;
Verb 'open' 'ontsluier' 'ontdoe' 'ontsluit' 'ontsleutel' 'onthul'
                * noun                           -> Open
                * noun 'met' held                -> Unlock;
Verb 'sluit' 'dicht' 'bedek' 'versluier' 'verhul' 'versleutel'
                * noun                           -> Close
                * noun 'op'                      -> Close
                * 'op' noun                      -> Close
                * noun 'met' held                -> Lock;
Verb 'enter' 'betreed'
                *                                -> GoIn
                * noun                           -> Enter;
Verb 'zit' 'lig'
                * 'boven' 'op' noun              -> Enter
                * 'op'/'aan'/'in'/'binnen' noun  -> Enter;
Verb 'in' 'binnen' 'binnenin' 'erin'
                *                                -> GoIn;
Verb 'exit' 'uit' 'buiten' 'buitenkant' 'eruit'
                *                                -> Exit;
Verb 'onderzoek' 'x//' 'b//' 'bestudeer' 'beschrijf' 'check' 'bekijk'
                * noun                           -> Examine;
Verb 'ja' 'j//'
                *                                -> Yes;
Verb 'nee'
                *                                -> No;
Verb 'sorry'
                *                                -> Sorry;
Verb 'shit' 'fuck' 'damn' 'sod' 'poep' 'kut' 'jezus' 'klote' 'godver'
    'godverdomme' 'gvd'
                *                                -> Strong
                * topic                          -> Strong;
Verb 'bother' 'curses' 'drat' 'darn' 'blimey' 'chips' 'drommels'
    'jeetje' 'potverdrie'
                *                                -> Mild
                * topic                          -> Mild;
Verb 'doorzoek'
                * noun                           -> Search;
Verb 'zwaai' 'wuif'
                *                                -> WaveHands
                * noun                           -> Wave;
Verb 'stel' 'regel'
                * noun 'in'/'af'                 -> Set
                * noun 'in'/'af' 'op' special    -> SetTo;
Verb 'trek' 'sleep' 'sleur'
                * noun                           -> Pull
                * 'aan' noun                     -> Pull
                * held 'aan'                     -> Wear
                * held 'uit'                     -> Disrobe;
Verb 'duw' 'beweeg' 'schuif' 'druk' 'steek' 'stop'
                * noun                           -> Push
                * noun 'opzij'/'weg'             -> Push
                * 'tegen' noun                   -> Push
                * noun noun                      -> PushDir
                * noun 'naar'/'in'/'op' noun     -> Transfer
                * multiexcept 'in' noun          -> Insert;
Extend only 'steek'
                * noun 'aan'                     -> Burn
                * noun 'in' 'de' 'fik'/'brand'/'hens'
                                                 -> Burn
                * noun 'in' 'brand'              -> Burn;
Verb 'draai' 'roteer' 'ontschroef' 'schroef' 'doe'
                * noun                           -> Turn
                * noun 'aan'                     -> Switchon
                * noun 'uit'                     -> Switchoff
                * 'aan' noun                     -> Switchon
                * 'uit' noun                     -> Switchoff
                * noun 'op' 'slot' 'met' held    -> Lock
                * noun 'op' 'het' 'slot' 'met' held    -> Lock
                * noun 'van' 'slot' 'met' held   -> Unlock
                * noun 'van' 'het' 'slot' 'met' held   -> Unlock;
Extend only 'doe' 
                * held 'af'                      -> Disrobe
                * multiexcept 'in' noun          -> Insert;
Verb 'schakel' 'zet'  
                * noun                           -> Switchon
                * noun 'aan'                     -> Switchon
                * noun 'uit'                     -> Switchoff
                * 'aan' noun                     -> Switchon
                * 'uit' noun                     -> Switchoff
                * noun 'op'                      -> Wear
                * noun 'af'                      -> Disrobe
                * noun held 'neer'               -> Drop
                * multiexcept 'aan'/'op' noun    -> PutOn;
Verb 'breek' 'ram' 'sla' 'vecht' 'bevecht' 'sloop' 'kraak'
     'verwoest' 'vermoord' 'dood' 'martel' 'stomp' 'mep' 'stoot'
     'vernietig' 'vermorzel' 'schop' 'wurg'
                * noun                           -> Attack;
Verb 'val'
                * noun 'aan'                     -> Attack
                * 'aan' noun                     -> Attack;
Verb 'wacht' 'a//'
                *                                -> Wait;
Verb 'antwoord' 'zeg' 'roep' 'schreeuw' 'spreek'
                * topic 'tot'/'tegen'/'naar'/'aan' creature
                                                 -> Answer;
Verb 'vertel'
                * creature 'over'/'betreffende' topic
                                                 -> Tell;
Verb 'vraag'
                * creature 'over'/'naar' topic   -> Ask
                * creature 'om'/'naar' noun      -> AskFor;
Verb 'eet'
                * held                           -> Eat
                * held 'op'                      -> Eat;
Verb 'slaap' 'dut' 'droom'
                *                                -> Sleep;
Verb 'schil' 'schraap' 'peuter'
                * noun                           -> Take
                * 'uit'/'van' noun               -> Take;
Verb 'zing'
                *                                -> Sing;
Verb 'klim' 'beklim' 'klauter' 'daal'
                * noun                           -> Climb
                * noun 'op'/'in'/'af'            -> Climb
                * 'op'/'over'/'naar'/'in' noun   -> Climb;
Verb 'koop' 'bestel'
                * noun                           -> Buy;
Verb 'schaf'    * noun 'aan'                     -> Buy;
Verb 'knijp' 'plet'
                * noun                           -> Squeeze;
Verb 'zwem' 'duik'
                *                                -> Swim;
Verb 'slinger'
                * noun                           -> Swing
                * 'aan' noun                     -> Swing;
Verb 'blaas'
                * held                           -> Blow
                * 'op'/'in'/'door' held          -> Blow;
Verb 'bid'      *                                -> Pray;
Verb 'waak' 'ontwaak' 'wek'
                *                                -> Wake
                * creature                       -> WakeOther;
Verb 'maak'     * creature 'wakker'              -> WakeOther
                * creature 'af'                  -> Attack
                * noun 'schoon'                  -> Rub
                * noun 'aan' noun                -> Tie
                * noun 'vast' 'aan' noun         -> Tie;
Verb 'word'     * 'wakker'                       -> Wake;
Verb 'kus' 'omarm' 'knuffel' 'zoen'
                * creature                       -> Kiss;
Verb 'denk'
                *                                -> Think
                * 'na'                           -> Think;
Verb 'ruik' 'snuif'
                *                                -> Smell
                * noun                           -> Smell;
Verb 'hoor' 'luister'
                *                                -> Listen
                * noun                           -> Listen
                * 'naar' noun                    -> Listen;
Verb 'proef'
                * noun                           -> Taste;
Verb 'voel' 'betast' 'bevoel' 'graai'
                * noun                           -> Touch;
Verb 'aai' 'streel'
                * noun                           -> Touch;
Verb 'raak'
                * noun 'aan'                     -> Touch;
Verb 'wrijf' 'poets' 'veeg' 'reinig' 'stof' 'ontstof' 'schrob' 'was'
                * noun                           -> Rub
                * noun 'op'/'af'                 -> Rub;
Verb 'bind' 'bevestig' 'fixeer'
                * noun                           -> Tie
                * noun 'aan' noun                -> Tie
                * noun 'vast' 'aan' noun         -> Tie;
Verb 'brand' 'verbrand'
                * noun                           -> Burn
                * noun 'met' held                -> Burn;
Verb 'ontsteek' * noun                           -> Burn
                * noun 'met' held                -> Burn;
Verb 'drink' 'slik' 'nip'
                * noun                           -> Drink
                * noun 'op'/'in'/'door'          -> Drink
                * 'aan'/'van' noun               -> Drink;
Verb 'vul'
                * noun                           -> Fill;
Verb 'snij' 'schaaf' 'snoei' 'hak' 'knip'
                * noun                           -> Cut
                * noun 'af'                      -> Cut;
Verb 'spring' 'huppel' 'hinkel'
                *                                -> Jump
                * 'over' noun                    -> JumpOver
                * 'over' noun 'heen'             -> Jumpover
                * 'in' noun                      -> Enter
                * noun 'in'                      -> Enter;
Verb 'graaf'    * noun                           -> Dig
                * noun 'met' held                -> Dig;
Verb 'laat'
                * multiheld 'vallen'             -> Drop
                * held 'zien' 'aan' creature     -> Show
                * held 'aan' creature 'zien'     -> Show;
Verb 'haal'
                * noun 'van' 'het' 'slot' 'met' held  
                                                 -> Unlock
                * noun 'van' 'slot' 'met' held   -> Unlock;

! ----------------------------------------------------------------------------
!  This routine is no longer used here, but provided to help existing games
!  which use it as a general parsing routine:

[ ConTopic w; consult_from = wn;
  do w=NextWordStopped();
  until (w==-1 || (w=='to' && action_to_be==##Answer));
  wn--;
  consult_words = wn-consult_from;
  if (consult_words==0) return -1;
  if (action_to_be==##Ask or ##Answer or ##Tell)
  {   w=wn; wn=consult_from; parsed_number=NextWord();
      if (parsed_number=='the' && consult_words>1) parsed_number=NextWord();
      wn=w; return 1;
  }
  return 0;
];
! ----------------------------------------------------------------------------
!  Final task: provide trivial routines if the user hasn't already:
! ----------------------------------------------------------------------------
#Stub TimePasses      0;
#Stub Amusing         0;
#Stub DeathMessage    0;
#Stub DarkToDark      0;
#Stub NewRoom         0;
#Stub LookRoutine     0;
#Stub AfterLife       0;
#Stub GamePreRoutine  0;
#Stub GamePostRoutine 0;
#Stub AfterPrompt     0;
#Stub BeforeParsing   0;
#Stub PrintTaskName   1;
#Stub InScope         1;
#Stub UnknownVerb     1;
#Stub PrintVerb       1;
#Stub ParserError     1;
#Stub ParseNumber     2;
#Stub ChooseObjects   2;
#IFNDEF PrintRank;
Constant Make__PR;
#ENDIF;
#IFDEF Make__PR;
[ PrintRank; "."; ];
#ENDIF;
#IFNDEF ParseNoun;
Constant Make__PN;
#ENDIF;
#IFDEF Make__PN;
[ ParseNoun obj; obj=obj; return -1; ];
#ENDIF;
#Default Story 0;
#Default Headline 0;
#IFDEF INFIX;
#Include "infix";
#ENDIF;
! ----------------------------------------------------------------------------
