! ===========================================================================
!   Inform Language Definition File: Dutch 060505
!
!   (c) Yuri Robbers 2002-2006
!       but freely usable
!  
!   Thanks to Victor Gijsbers for many bugfixes and a few additions
!
!   Based on:
!
!   Inform Language Definition File: English 042227
!
!   (c) Graham Nelson 1993-2004
! ---------------------------------------------------------------------------
System_file;
! ---------------------------------------------------------------------------
!   Part I.   Preliminaries
! ---------------------------------------------------------------------------
Constant LanguageVersion
    = "Nederlandse vertaling 060505 door Yuri Robbers";

! ParserTrace: 0=off, 1=print string after LanguageToInformese, 
!                     2=ASCII-List (useful for character hacking)
#ifdef DEBUG;
  Constant ParserTrace = 0;
#endif;

Class  CompassDirection
  with article "het", number 0
  has  scenery;
Object Compass "kompas" has concealed;
IFNDEF WITHOUT_DIRECTIONS;
CompassDirection -> n_obj "noorden"
                    with name 'n//' 'noord' 'noorden',    door_dir n_to;
CompassDirection -> s_obj "zuiden"
                    with name 'z//' 'zuid' 'zuiden',    door_dir s_to;
CompassDirection -> e_obj "oosten"
                    with name 'o//' 'oost' 'oosten',     door_dir e_to;
CompassDirection -> w_obj "westen"
                    with name 'w//' 'west' 'westen',     door_dir w_to;
CompassDirection -> ne_obj "noordoosten"
                    with name 'no' 'noordoost' 'noordoosten', door_dir ne_to;
CompassDirection -> nw_obj "noordwesten"
                    with name 'nw' 'noordwest' 'noordwesten', door_dir nw_to;
CompassDirection -> se_obj "zuidoosten"
                    with name 'zo' 'zuidoost' 'zuidoosten', door_dir se_to;
CompassDirection -> sw_obj "zuidwesten"
                    with name 'zw' 'zuidwest' 'zuidwesten', door_dir sw_to;
CompassDirection -> u_obj "plafond"
                    with name 'h//' 'omhoog' 'plafond',    door_dir u_to;
CompassDirection -> d_obj "vloer"
                    with name 'l//' 'omlaag' 'vloer',    door_dir d_to,
                    has male;
ENDIF;
CompassDirection -> out_obj "buiten"
                    with                               door_dir out_to,
                    has proper;
CompassDirection -> in_obj "binnen"
                    with                               door_dir in_to
                    has proper;
! ---------------------------------------------------------------------------
!   Part II.   Vocabulary
! ---------------------------------------------------------------------------
Constant AGAIN1__WD   = 'opnieuw';
Constant AGAIN2__WD   = 'p//';
Constant AGAIN3__WD   = 'again';
Constant OOPS1__WD    = 'oeps';
Constant OOPS2__WD    = 's//';
Constant OOPS3__WD    = 'oops';
Constant UNDO1__WD    = 'ongedaan';
Constant UNDO2__WD    = 'terug';
Constant UNDO3__WD    = 'undo';

Constant ALL1__WD     = 'alle';
Constant ALL2__WD     = 'alles';
Constant ALL3__WD     = 'elk';
Constant ALL4__WD     = 'elke';
Constant ALL5__WD     = 'beide';
Constant AND1__WD     = 'en';
Constant AND2__WD     = 'en';
Constant AND3__WD     = 'en';
Constant BUT1__WD     = 'behalve';
Constant BUT2__WD     = 'uitgezonderd';
Constant BUT3__WD     = 'zonder';
Constant ME1__WD      = 'me';
Constant ME2__WD      = 'mij';
Constant ME3__WD      = 'zelf';
Constant OF1__WD      = 'van';
Constant OF2__WD      = 'uit';
Constant OF3__WD      = 'vanuit';
Constant OF4__WD      = 'van';
Constant OTHER1__WD   = 'ander';
Constant OTHER2__WD   = 'andere';
Constant OTHER3__WD   = 'ander';
Constant THEN1__WD    = 'dan';
Constant THEN2__WD    = 'daarna';
Constant THEN3__WD    = 'erna';

Constant NO1__WD      = 'n//';
Constant NO2__WD      = 'nee';
Constant NO3__WD      = 'nee';
Constant YES1__WD     = 'j//';
Constant YES2__WD     = 'ja';
Constant YES3__WD     = 'ja';

Constant AMUSING__WD  = 'amusant';
Constant FULLSCORE1__WD = 'totaalscore';
Constant FULLSCORE2__WD = 'totaal';
Constant QUIT1__WD    = 'e//';
Constant QUIT2__WD    = 'einde';
Constant RESTART__WD  = 'herstart';
Constant RESTORE__WD  = 'inlezen';

Array LanguagePronouns table

   !  word       possible GNAs                   connected
   !             to follow:                      to:
   !             a     i
   !             s  p  s  p
   !             mfnmfnmfnmfn                 

      'het'    $$001000001000                    NULL
      'hem'    $$100000110000                    NULL
      'haar'   $$010000010000                    NULL
      'ze'     $$000111000111                    NULL
      'hen'    $$000111000111                    NULL
      'er'     $$000000111111                    NULL;

Array LanguageDescriptors table

   !  word       possible GNAs   descriptor      connected
   !             to follow:      type:           to:
   !             a     i
   !             s  p  s  p
   !             mfnmfnmfnmfn                 

      'mijn'   $$111111111111    POSSESS_PK      0
      'dit'    $$001000001000    POSSESS_PK      0
      'deze'   $$110111110111    POSSESS_PK      0
      'dat'    $$001000001000    POSSESS_PK      1
      'die'    $$110111110111    POSSESS_PK      1
      'zijn'   $$111111111111    POSSESS_PK      'hem'
      'haar'   $$111111111111    POSSESS_PK      'haar'
      'hun'    $$111111111111    POSSESS_PK      'hun'
      'zijn'   $$111111111111    POSSESS_PK      'het'
      'de'     $$110111110111    DEFART_PK       NULL
      'het'    $$001000001000    DEFART_PK       NULL
      'een'    $$111000111000    INDEFART_PK     NULL
      'enkele' $$000111000111    INDEFART_PK     NULL
      'enige'  $$000111000111    INDEFART_PK     NULL
      'aan'    $$111111111111    light           NULL
    'verlicht' $$111111111111    light           NULL
      'uit'    $$111111111111    (-light)        NULL;

Array LanguageNumbers table
    'een' 1 'twee' 2 'drie' 3 'vier' 4 'vijf' 5
    'zes' 6 'zeven' 7 'acht' 8 'negen' 9 'tien' 10
    'elf' 11 'twaalf' 12 'dertien' 13 'veertien' 14 'vijftien' 15
    'zestien' 16 'zeventien' 17 'achttien' 18 'negentien' 19
    'twintig' 20 'dertig' 30 'veertig' 40 'vijftig' 50 'zestig' 60
    'zeventig' 70 'tachtig' 80 'negentig' 90 'honderd' 100 'duizend' 1000;

! ---------------------------------------------------------------------------
!   Part III.   Translation
! ---------------------------------------------------------------------------

[ LanguageToInformese x; 			!word at x
    for (x=2:x<2+buffer->1:x++)
    {
	if (buffer->x == '?' or '!' or '.' or '"') buffer->x = ' ';
    }

    ! Vervang "erin" "erop" etc. door "in er" "op er" (hierboven is "er"
    ! zodanig gedefinieerd dat het op deze manier als verwijswoord
    ! gebruikt kan worden. Informese is tenslotte geen Nederlands, en de
    ! gebruiker merkt er niets van.
    ! Gebaseerd op German.h van Toni Arnold.

!    for (x=0:x<parse->1:x++)  ! loop through every word
!    {
!  	word = parse-->(x*2+1);
!  	at = parse->(x*4+5);

!	if (word == 'erin')
!	{
!	    buffer->(at) = 'i';
!	    buffer->(at+1) = 'n';
!	    buffer->(at+2) = ' ';
!	    buffer->(at+3) = 'e';
!	    LTI_Insert->(at+4) = 'r';
!	    break;
!	}

!	if (word == 'eruit')
!	{
!	    buffer->(at) = 'u';
!	    buffer->(at+1) = 'i';
!	    buffer->(at+2) = 't';
!	    buffer->(at+3) = ' ';
!	    buffer->(at+4) = 'e';
!	    LTI_Insert->(at+5) = 'r';
!	    break;
!	}
	
!	if (word == 'erop')
!	{
!	    buffer->(at) = 'o';
!	    buffer->(at+1) = 'p';
!	    buffer->(at+2) = ' ';
!	    buffer->(at+3) = 'e';
!	    LTI_Insert->(at+4) = 'r';
!	    break;
!	}

!	if (word == 'eraf')
!	{
!	    buffer->(at) = 'a';
!	    buffer->(at+1) = 'f';
!	    buffer->(at+2) = ' ';
!	    buffer->(at+3) = 'e';
!	    LTI_Insert->(at+4) = 'r';
!	    break;
!	}

!	if (word == 'eraan')
!	{
!	    buffer->(at) = 'a';
!	    buffer->(at+1) = 'a';
!	    buffer->(at+2) = 'n';
!	    buffer->(at+3) = ' ';
!	    buffer->(at+4) = 'e';
!	    LTI_Insert->(at+5) = 'r';
!	    break;
!	}
!    }

    @tokenise buffer parse;	! othwerwise parse->x is wrong

    ! Toon alle woorden
    ! Gebaseerd op Italian.h van Ilario Nardinocchi

#ifdef DEBUG;
    if (ParserTrace > 0) 
	{
	    print "[LanguageToInformese: ~";
	    for (x = 2: x < 2+ buffer->1: x++) 
	    {
		print (char) buffer->x;
	    }
	    print "~]^";
	    if (ParserTrace > 1)
	    {
		print "[";
		for (x = 2: x < 2 + buffer ->1: x++)
		{
		 print buffer->x,",";
		}
		print "]^";
	    }
	}
#endif;     ! DEBUG
];

! ---------------------------------------------------------------------------
!   Part IV.   Printing
! ---------------------------------------------------------------------------

Constant LanguageAnimateGender   = male;
Constant LanguageInanimateGender = neuter;

Constant LanguageContractionForms = 1;     ! Geen onderscheid zoals
                                           ! Engels "a" en "an"

[ LanguageContraction;
  return 0;
];

Array LanguageArticles -->

 !   Contraction form 0:
 !   Cdef   Def    Indef

     "De " "de " "een "      ! Articles 0
     "Het " "het " "een "    ! Articles 1
     "De " "de " "enkele ";   ! Articles 2

                   !             a           i
                   !             s     p     s     p
                   !             m f n m f n m f n m f n                 

Array LanguageGNAsToArticles --> 0 0 1 2 2 2 0 0 1 2 2 2;

[ LanguageDirection d;
   switch(d)
   {   n_to: print "noord";
       s_to: print "zuid";
       e_to: print "oost";
       w_to: print "west";
       ne_to: print "noordoost";
       nw_to: print "noordwest";
       se_to: print "zuidoost";
       sw_to: print "zuidwest";
       u_to: print "omhoog";
       d_to: print "omlaag";
       in_to: print "binnen";
       out_to: print "buiten";
       default: return RunTimeError(9,d);
   }
];

[ LanguageNumber n f;
  if (n==0)    { print "nul"; rfalse; }
  if (n<0)     { print "min "; n=-n; }
  if (n>=1000) { print (LanguageNumber) n/1000, " duizend"; n=n%1000; f=1; }
  if (n>=100)  { if (f==1) print ", ";
                 print (LanguageNumber) n/100, " honderd"; n=n%100; f=1; }
  if (n==0) rfalse;
  if (f==1) print "";
  switch(n)
  {   1:  print "een";
      2:  print "twee";
      3:  print "drie";
      4:  print "vier";
      5:  print "vijf";
      6:  print "zes";
      7:  print "zeven";
      8:  print "acht";
      9:  print "negen";
      10: print "tien";
      11: print "elf";
      12: print "twaalf";
      13: print "dertien";
      14: print "veertien";
      15: print "vijftien";
      16: print "zestien";
      17: print "zeventien";
      18: print "achttien";
      19: print "negentien";
      20 to 99:
          if (n%10 ~= 0) print (LanguageNumber) n%10, "en";
          switch(n/10)
          {  2: print "twintig";
             3: print "dertig";
             4: print "veertig";
             5: print "vijftig";
             6: print "zestig";
             7: print "zeventig";
             8: print "tachtig";
             9: print "negentig";
          }
  }
];

[ LanguageTimeOfDay hours mins i;
    i=hours%24;
    if (i==0) i=24;
    if (i<10) print " ";
    print i, ":", mins/10, mins%10;
    ! if ((hours/12) > 0) print " pm"; else print " am";
    print " uur";
];

[ LanguageVerb i;
   if (i==#n$k)         { print "kijk";              rtrue; }
   if (i==#n$a or 'zz') { print "wacht";             rtrue; }
   if (i==#n$x)         { print "onderzoek";         rtrue; }
   if (i==#n$i or 'inv' or 'inventory' or 'inventaris')
                        { print "inventaris";        rtrue; }
   rfalse;
];
 
#Ifdef DEBUG;
 [ LanguageVerbIsDebugging w;
      if (w == 'purloin' or 'tree' or 'abstract'
	                         or 'gonear' or 'scope' or 'showobj')
          rtrue;
      rfalse;
  ];
 #Endif;
 
 ! ----------------------------------------------------------------------------
 !  LanguageVerbLikesAdverb is called by PrintCommand when printing an UPTO_PE
 !  error or an inference message.  Words which are intransitive verbs, i.e.,
 !  which require a direction name as an adverb ('walk west'), not a noun
 !  ('I only understood you as far as wanting to touch /the/ ground'), should
 !  cause the routine to return true.
 ! ----------------------------------------------------------------------------
 
 [ LanguageVerbLikesAdverb w;
      if (w == 'look' or 'go' or 'push' or 'walk')
          rtrue;
      rfalse;
  ];
 
 ! ----------------------------------------------------------------------------
 !  LanguageVerbMayBeName is called by NounDomain when dealing with the
 !  player's reply to a "Which do you mean, the short stick or the long
 !  stick?" prompt from the parser. If the reply is another verb (for example,
 !  LOOK) then then previous ambiguous command is discarded /unless/
 !  it is one of these words which could be both a verb /and/ an
 !  adjective in a 'name' property.
 ! ----------------------------------------------------------------------------
  
 [ LanguageVerbMayBeName w;
      if (w == 'long' or 'short' or 'normal'
	  or 'brief' or 'full' or 'verbose')
      rtrue;
   rfalse;
];

Constant NKEY__TX     = "V = volgende pag";
Constant PKEY__TX     = "  O = vorige";
Constant QKEY1__TX    = "  Q = weer spelen";
Constant QKEY2__TX    = "  Q = vorige menu";
Constant RKEY__TX     = "RETURN = lees over onderwerp";

Constant NKEY1__KY    = 'V';
Constant NKEY2__KY    = 'v';
Constant PKEY1__KY    = 'O';
Constant PKEY2__KY    = 'o';
Constant QKEY1__KY    = 'Q';
Constant QKEY2__KY    = 'q';

Constant SCORE__TX    = "Score: ";
Constant MOVES__TX    = "Beurten: ";
Constant TIME__TX     = "Tijd: ";
Constant CANTGO__TX   = "Je kunt die kant niet op.";
Constant FORMER__TX   = "je vroegere zelf";
Constant YOURSELF__TX = "jezelf";
Constant DARKNESS__TX = "Duisternis";

Constant THOSET__TX   = "die dingen";
Constant THAT__TX     = "dat";
Constant OR__TX       = " of ";
Constant NOTHING__TX  = "niets";
Constant IS__TX       = " is";
Constant ARE__TX      = " zijn";
Constant IS2__TX      = "";
Constant ARE2__TX     = "";
Constant AND__TX      = " en ";
Constant WHOM__TX     = "";
Constant WHICH__TX    = "";
Constant COMMA__TX    = ", ";

! English Equivalents:
!
! DieofDat         -> ThatorThose
! HetofHen         -> ItorThem
! IsofZijn         -> IsorAre
! CDieofDat        -> CThatorThose
! CZezijnofDatis   -> CTheyreorThats

[ DieofDat obj;   ! Used in the accusative
  if (obj == player) { print "jou"; return; }
  if (obj has pluralname) { print "die"; return; }
  if (obj has female) { print "haar"; return; }
      else if (obj hasnt neuter) { print "hem"; return; }
  if (obj has neuter){ print "dat"; return; } 
  print "die";
];
[ DieofDat2 obj;
  if (obj has pluralname) { print "die"; return; }
  if (obj hasnt neuter) { print "die"; return; }
  if (obj has neuter) { print "dat"; return; }
  print "die";
];
[ DitofDeze obj;
  if (obj has pluralname) { print "deze"; return; }
  if (obj hasnt neuter) { print "deze"; return; }
  if (obj has neuter) { print "dit"; return; }
  print "deze";
]; 
[ HijofHet obj;   ! Used in the accusative
  if (obj == player) { print "jou"; return; }
  if (obj has pluralname) { print "ze"; return; }
  if (obj has female) { print "haar"; return; }
      else if (obj hasnt neuter) { print "hem"; return; }
  if (obj has neuter){ print "het"; return; } 
  print "ze";
];
[ HetofHen obj;
  if (obj == player) { print "jezelf"; return; }
  if (obj has pluralname) { print "hen"; return; }
  if (obj has animate)
  {   if (obj has female) { print "haar"; return; }
      else if (obj hasnt neuter) { print "hem"; return; }
  }
  print "het";
];
[ IsofZijn obj;
  if (obj has pluralname || obj == player) print "zijn"; else print "is";
];
[ CDieofDat obj;   ! Used in the nominative
  if (obj == player) { print "Je"; return; }
  if (obj has pluralname) { print "Die"; return; }
  if (obj has animate)
  {   if (obj has female) { print "Ze"; return; }
      else if (obj hasnt neuter) { print "Hij"; return; }
  }
  print "Dat";
];
[ CZezijnofDatis obj;
  if (obj == player) { print "Je bent"; return; }
  if (obj has pluralname) { print "Ze zijn"; return; }
  if (obj has animate)
  {   if (obj has female) { print "Zij is"; return; }
      else if (obj hasnt neuter) { print "Hij is"; return; }
  }
  print "Dat is";
];


[ LanguageLM n x1;
  Prompt:  print "^>";
  Miscellany:
           switch(n)
           {   1: "(alleen de eerste zestien objecten in beschouwing nemend!)^";
               2: "Niets te doen!";
               3: print " Je bent dood ";
               4: print " Je hebt gewonnen ";
               5: print "Wil je een HERSTART, een oud spel INLEZEN";
                  #IFDEF DEATH_MENTION_UNDO;
                  print ", je laatste beurt ONGEDAAN maken";
                  #ENDIF;
                  if (TASKS_PROVIDED==0)
                      print ", de TOTAAL score voor dit spel";
                  if (deadflag==2 && AMUSING_PROVIDED==0)
                      print ", wat suggesties voor dingen die AMUSANT
			  zijn om te proberen";
                  " of een EINDE aan het spel maken?";
               6: "[Je interpreter ondersteunt het ~ongedaan~ maken
	       niet. Sorry!]";
               7: "~Ongedaan~ maken mislukt.  [Niet alle interpreters
	       ondersteunen dit.]";
               8: "Geef alsjeblieft een van bovenstaande antwoorden.";
               9: "^Het is hier nu stikdonker!";
              10: "Pardon?";
              11: "[Je kunt niet ~ongedaan~ maken wat je niet gedaan hebt!]";
              12: "[Het is niet mogelijk meerdere beurten ~ongedaan~
	       te maken. Sorry!]";
              13: "[Vorige beurt ongedaan gemaakt.]";
              14: "Sorry, dat kan niet worden gecorrigeerd.";
              15: "Geeft niet.";
              16: "~Oeps~ kan alleen een enkel woord corrigeren.";
              17: "Het is stikdonker, en je ziet geen hand voor ogen.";
              18: print "jezelf";
              19: "Even knap als altijd.";           
              20: "Om een commando zoals ~kikker, spring~, te herhalen
	       zeg je gewoon ~opnieuw~, niet ~kikker, opnieuw~.";
              21: "Het lukt je niet om dat te herhalen.";
              22: "Je kunt een zin niet met een komma beginnen.";
              23: "Het lijkt of je tegen iemand wilt praten, maar ik
	       heb geen idee wie.";
              24: "Je kunt niet tegen ", (the) x1, " praten.";
              25: "Om tegen iemand te praten, kun je ~iemand, hallo~
	       of iets dergelijks proberen.";
              26: "(eerst ", (the) not_holding, " oppakkend)";
              27: "Van die zin begrijp ik helemaal niets.";
		  28: print "Ik begrijp alleen het gedeelte: ";
              29: "Dat getal begrijp ik niet.";
              30: "Je ziet hier niets van dien aard.";
              31: "Zo te zien heb je niet genoeg gezegd!";
              32: "Dat heb je niet bij je!";
              33: "Je kunt geen meerdere objecten met dat werkwoord gebruiken.";
              34: "Je kunt slechts eenmaal in een regel meerdere
	       objecten gebruiken.";
              35: "Ik weet niet precies wat je met ~", (address) pronoun_word,
                  "~ bedoelt.";
              36: "Je hebt iets uitgezonderd wat er toch al niet bij hoorde!";
              37: "Dat kun je alleen met een levend wezen doen.";
              38: "Dat is geen werkwoord dat ik ken.";
	      39: "Dat is niet iets waar je in dit spel naar hoeft te
	       verwijzen.";
              40: "Je ziet ~", (address) pronoun_word,
                  "~ (", (the) pronoun_obj, ") op het moment niet.";
              41: "Ik begrijp de manier waarop dat eindigde niet goed.";
              42: if (x1==0) print "Geen";
                  else print "Slechts ", (number) x1;
                  print " van die ";
                  if (x1==1) print "is"; else print "zijn";
                  " beschikbaar.";
              43: "Niets te doen!";
              44: "Er zijn er helemaal geen beschikbaar!";
              45: print "Wie bedoel je, ";
              46: print "Welke bedoel je, ";
              47: "Sorry, je kunt hier slechts een voorwerp
	       hebben. Welke precies?";
              48: print "Wie bedoel je precies als je";
                  if (actor~=player) print " tegen ", (the) actor;
	          print " zegt ~"; PrintCommand(); print "~?^";
              49: print "Welk voorwerp bedoel je precies als je";
                  if (actor~=player) print " tegen ", (the) actor;
	          print " zegt ~"; PrintCommand(); print "~?^";
              50: print "Je score is zojuist ";
                  if (x1 > 0) print "gestegen"; else { x1 = -x1;
		      print "gedaald"; }
                  print " met ", (number) x1, " punt";
                  if (x1 > 1) print "en";
              51: "(Aangezien er iets dramatisch is gebeurd, is je
	       lijst met mogelijke commando's beperkt.)";
              52: "^Type een getal tussen 1 en ", x1,
                  ", 0 om de tekst nog eens te lezen of druk op ENTER.";
              53: "^[Druk alstublieft op de SPATIEBALK.]";
	      54: "[Commentaar bewaard.]";
	      55: "[Commentaar NIET bewaard.]";
	      56: print ".^";
	      57: print "?^";
           }

  ListMiscellany:
           switch(n)
           {   1: print " (geeft licht)";
	       2: print " (", (DieofDat2) x1, " dicht ", (IsofZijn) x1, ")";
               3: print " (dicht en lichtgevend)";
               4: print " (welke leeg ", (IsofZijn) x1, ")";
               5: print " (leeg en lichtgevend)";
               6: print " (welke leeg en dicht ", (IsofZijn) x1, ")";
               7: print " (leeg, dicht en lichtgevend)";
               8: print " (lichtgevend en gedragen";
               9: print " (lichtgevend";
              10: print " (gedragen";
              11: print " (en ", (DieofDat) x1, " ",(IsofZijn) x1, " ";
              12: print "open";
              13: print "open maar leeg";
              14: print "dicht";
              15: print "dicht en op slot";
              16: print " en leeg";
              17: print " (welke leeg ", (IsofZijn) x1, ")";
              18: print ", en bevat ";
              19: print " (met daarop ";
              20: print " met daarbovenop ";
              21: print " (met daarin ";
              22: print " met daarin ";
           }

  Pronouns: switch(n)
           {   1: print "Op dit moment, ";
               2: print "betekent ";
               3: print "is niet gezet";
               4: "er zijn geen voornaamwoorden bekend aan het spel.";
           }
  Order:          print (The) x1;
                  if (x1 has pluralname) print " hebben"; else print " heeft";
                  " betere dingen te doen.";
  Quit:    switch(n)
           {   1: print "Antwoord alsjeblieft met ja of nee.";
               2: print "Weet je zeker dat je wilt stoppen? ";
           }
  Restart: switch(n)
           {   1: print "Weet je zeker dat je wilt herstarten? ";
               2: "Mislukt.";
           }
  Restore: switch(n)
           {   1: "Inlezen Mislukt.";
               2: "Ok.";
           }
  Save:    switch(n)
           {   1: "Opslaan mislukt.";
               2: "Ok.";
           }
  Verify:  switch(n)
           {   1: "Het spelbestand is geverifieerd en in orde bevonden.";
               2: "Het spelbestand is geverifieerd, maar niet in orde
      bevonden. Het kan beschadigd zijn.";
           }
  ScriptOn: switch(n)
           {   1: "Transcriptie staat al aan.";
               2: "Start transcriptie van";
               3: "Poging transcriptie te starten mislukt.";
           }
  ScriptOff: switch(n)
           {   1: "Transcriptie staat al uit.";
               2: "^Einde transcript.";
               3: "Poging transcriptie te beeindigen mislukt.";
           }
  NotifyOn:       "Score notificatie aan.";
  NotifyOff:      "Score notificatie uit.";
  Places:         print "Je hebt bezocht: ";
  Objects: switch(n)
           {   1: "Objecten die je in je handen hebt gehad:^";
               2: "Geen.";
               3: print "   (gedragen)";
               4: print "   (vastgehouden)";
               5: print "   (weggegeven)";
               6: print "   (in ", (name) x1, ")";
               7: print "   (in ", (the) x1, ")";
               8: print "   (binnenin ", (the) x1, ")";
               9: print "   (op ", (the) x1, ")";
              10: print "   (verloren)";
           }
  Score:          if (deadflag) print "In dit spel scoorde je ";
                  else print "Je hebt tot nog toe gescoord ";
                  print score, " punten van maximaal ", MAX_SCORE,
                  ", in ", turns, " beurt";
                  if (turns~=1) print "en"; return;
  FullScore: switch(n)
           {   1: if (deadflag) print "De score was ";
                  else          print "De score is ";
                  "als volgt tot stand gekomen:^";
               2: "vinden van verscheidene voorwerpen";
               3: "bezoeken van diverse plaatsen";
               4: print "totaal (van de ", MAX_SCORE; ")";
           }
  Inv:     switch(n)
           {   1: "Je hebt niets bij je.";
               2: print "Je hebt bij je";
	       3: print ":^";
	       4: print ".^";
           }
  Take:    switch(n)
           {   1: "Gepakt.";
               2: "Je hebt jezelf altijd in de hand.";
               3: "Ik verwacht niet dat ", (the) x1, " dat op prijs zal
	  stellen.";
               4: print "Dan zul je eerst ";
                  if (x1 has supporter) print "van "; else print
		      "uit ";
                  print (the) x1; if (x1 has supporter) print "af";
      print_ret " moeten komen.";
               5: "Je hebt ", (DieofDat) x1, " al.";
               6: if (noun has pluralname) print "Ze lijken ";
                  else print "Dat lijkt ";
                  "in het bezit van ", (the) x1, " te zijn.";
               7: if (noun has pluralname) print "Ze lijken ";
                  else print "Dat lijkt ";
                  "onderdeel te zijn van ", (the) x1, ".";
               8: print_ret (CDieofDat) x1, " ", (IsofZijn) x1,
                  " niet beschikbaar.";
               9: print_ret (The) x1, " ", (IsofZijn) x1, " niet open.";
              10: if (x1 has pluralname) print "Ze zijn ";
                  else print "Dat is ";
                  "nu niet bepaald draagbaar.";
              11: if (x1 has pluralname) print "Ze zijn ";
                  else print "Dat is ";
                  "stevig bevestigd.";
              12: "Je hebt al teveel bij je.";
              13: "(eerst ", (the) x1, " in ", (the) SACK_OBJECT,
                  " gestopt om plaats te maken)";
           }
  Drop:    switch(n)
           {   1: if (x1 has pluralname) print (The) x1, " liggen ";
                  else print (The) x1, " ligt ";
                  "hier al.";
               2: "Je hebt ", (DieofDat) x1, " niet.";
               3: "(eerst ", (the) x1, " uittrekkend)";
               4: "Neergelegd.";
           }
  Remove:  switch(n)
           {   1: if (x1 has pluralname) print "Ze zijn"; else print
	       "Dat is"; " helaas dicht.";
               2: if (x1 has pluralname)
                      print "Maar ze zijn";
                  else print "Maar dat is";
                  " daar nu niet.";
               3: "Verwijderd.";
           }
  PutOn:   switch(n)
           {   1: "Je moet ", (the) x1,
                  " vasthouden voor je ", (HetofHen) x1,
                  " ergens bovenop kunt leggen.";
               2: "je kunt iets niet bovenop zichzelf leggen.";
               3: "Met dingen op ", (the) x1, " leggen bereik je niets.";
               4: "Daar ben je niet handig genoeg voor.";
               5: "(eerst ", (HetofHen) x1, " uittrekkend)^";
               6: "Er is geen plaats meer op ", (the) x1, ".";
               7: "Gedaan.";
               8: "Je legt ", (the) x1, " op ", (the) second, ".";
           }
  Insert:  switch(n)
           {   1: "Je moet ", (the) x1,
                  " vasthouden voordat je ", (HetofHen) x1,
                  " ergens in kunt stoppen.";
               2: print_ret (CDieofDat) x1, " kan niets bevatten.";
               3: print_ret (The) x1, " ", (IsofZijn) x1, " dicht.";
               4: "Je moet ", (HetofHen) x1, " eerst uittrekken.";
               5: "Je kunt iets niet in zichzelf stoppen.";
               6: "(eerst ", (HetofHen) x1, " uittrekkend)^";
               7: "Er is geen ruimte meer in ", (the) x1, ".";
               8: "Gedaan.";
               9: "Je stopt ", (the) x1, " in ", (the) second, ".";
           }
  EmptyT:  switch(n)
           {   1: print_ret (The) x1, " kan niets bevatten.";
               2: print_ret (The) x1, " ", (IsofZijn) x1, " dicht.";
               3: print_ret (The) x1, " ", (IsofZijn) x1, " al leeg.";
               4: "Dat zou toch niet echt iets leegmaken.";
           }
  Give:    switch(n)
           {   1: "Je hebt ", (the) x1, "niet bij je.";
               2: "Je jongleert wat met ", (the) x1,
                  ", maar bereikt niet veel.";
               3: print (The) x1;
                  if (x1 has pluralname) print " lijken";
                  else print " lijkt";
                  " niet geinteresseerd.";
           }
  Show:    switch(n)
           {   1: "Je hebt ", (the) x1, " niet bij je.";
               2: print_ret (The) x1, " ", (IsofZijn) x1, " niet onder
	  de indruk.";
           }
  Enter:   switch(n)
           {   1: print "Maar je bent al ";
                  if (x1 has supporter) print "op "; else print "in ";
                  print_ret (the) x1, ".";
               2: if (x1 has pluralname) print "Ze zijn"; else print
		   "Dat is";
                  print " niet iets waar je ";
                  switch (verb_word) {
                      'sta': "op kunt staan.";
                      'zit': "op kunt zitten.";
                      'lig': "op kunt liggen.";
                      default: "in kunt gaan.";
                  }
               3: "Je kunt ", (the) x1, " niet binnengaan wanneer ",
		   (DitofDeze) x1, " dicht ", (IsofZijn) x1, ".";
               4: "Je kunt alleen ergens in als het vrij staat.";
               5: print "Je klimt ";
                  if (x1 has supporter) print "op "; else print "in ";
                  print_ret (the) x1, ".";
               6: print "(eerst ";
                  if (x1 has supporter) print "van "; else print "uit ";
                  print (the) x1; "geklommen)";
               7: if (x1 has supporter) "(eerst op ", (the) x1, "geklommen)^";
                  if (x1 has container) "(eerst in ", (the) x1, "geklommen)^";
                  "(eerst ", (the) x1, "binnengegaan)^";
           }
  GetOff:         "Maar je bevindt je helemaal niet op ", (the) x1, "
	           op het moment.";
  Exit:    switch(n)
           {   1: "Maar je bevindt je momenteel nergens in.";
               2: "Je kunt geen afgesloten ", (name) x1, " verlaten.";
               3: print "Je klimt ";
                  if (x1 has supporter) print "van "; else print "uit ";
                  print_ret (the) x1, ".";
           }
  VagueGo:       "Je moet wel zeggen welke kompasrichting je op wilt.";

  Go:      switch(n)
           {   1: print "Je zult eerst ";
                  if (x1 has supporter) print "van "; else print "uit ";
                  print_ret (the) x1, " moeten komen.";
               2: "Die kant kun je niet op.";
               3: "Je kunt niet op ", (the) x1, "klimmen.";
               4: "Je kunt ", (the) x1, " niet afdalen.";
               5: "Dat gaat niet; ", (the) x1, " ", (IsofZijn) x1,
                  " in de weg.";
               6: print "Dat kan niet, want ", (the) x1;
                  if (x1 has pluralname) " gaan nergens heen.";
                  " gaat nergens heen.";
           }

  LMode1:         " is nu in de normale ~kort~ modus, waarin
                   je lange beschrijvingen krijgt van plaatsen waar je
                   nog nooit geweest bent, en anders korte.";
  LMode2:         " is nu in de ~uitgebreid~ modus, waarin je altijd
                   een uitgebreide beschrijving van je locatie krijgt
                   (zelfs als je er al eerder geweest bent).";
  LMode3:         " is nu in de ~superkort~ modus, waarin je altijd
                   korte beschrijvingen van elke locatie krijgt
                   (zelfs als je er nog nooit geweest bent).";

  Look:    switch(n)
           {   1: print " (op ", (the) x1, ")";
               2: print " (in ", (the) x1, ")";
               3: print " (als "; @print_obj x1; print ")";
               4: print "^Op ", (the) x1;
                  WriteListFrom(child(x1),
                      ENGLISH_BIT + RECURSE_BIT + PARTINV_BIT
                      + TERSE_BIT + ISARE_BIT + CONCEAL_BIT);
                  ".";
         default: if (x1~=location)
                  {   if (x1 has supporter) print "^Op "; else print "^In ";
                      print (the) x1, " zie je ";
                  }
                  else print "^Je ziet ";
                  if (n==5) print "ook ";
                  WriteListFrom(child(x1),
                      ENGLISH_BIT + WORKFLAG_BIT + RECURSE_BIT
                      + PARTINV_BIT + TERSE_BIT + CONCEAL_BIT);
                  if (x1~=location) ".";
                  ".";
           }

  Examine: switch(n)
           {   1: "Duisternis, zelfstandig naamwoord.  Een afwezigheid
                   van licht om bij te zien.";
               2: "Je ziet niets bijzonders aan ", (the) x1, ".";
               3: print (The) x1, " ", (IsofZijn) x1, " momenteel ";
                  if (x1 has on) "aan"; else "uit"; print "geschakeld.";
           }
  LookUnder: switch(n)
           {   1: "Maar het is donker.";
               2: "Je vindt niets bijzonders.";
           }

  Search:  switch(n)
           {   1: "Maar het is donker.";
               2: "Maar er ligt niets op ", (the) x1, ".";
               3: print "Op ", (the) x1;
                  WriteListFrom(child(x1),
                      TERSE_BIT + ENGLISH_BIT + ISARE_BIT + CONCEAL_BIT);
                  ".";
               4: "Je vindt niets interessants.";
               5: "Je kunt er niet in kijken, want ", (the) x1, " ",
                  (IsofZijn) x1, " dicht.";
               6: print_ret (The) x1, " ", (IsofZijn) x1, " leeg.";
               7: print "In ", (the) x1;
                  WriteListFrom(child(x1),
                      TERSE_BIT + ENGLISH_BIT + ISARE_BIT + CONCEAL_BIT);
                  ".";
           }

  Unlock:  switch(n)
           {   1: if (x1 has pluralname) print "Dat lijken geen dingen die";
                  else print "Dat lijkt niet iets dat ";
                  "je op slot kunt doen.";
               2: print_ret (CZezijnofDatis) x1,
                  " op het moment niet op slot.";
               3: if (x1 has pluralname) print "Die lijken niet ";
                  else print "Die lijkt niet ";
                  "op het slot te passen.";
               4: "Je doet ", (the) x1, " van slot.";
           }
  Lock:    switch(n)
           {   1: if (x1 has pluralname) print "Dat lijken geen dingen
	          die"; else print "Dat lijkt niet iets dat ";
                  "je op slot kunt doen.";
               2: print_ret (CZezijnofDatis) x1, " op het moment op slot.";
               3: "Eerst moet je ", (the) x1, "dichtdoen.";
               4: if (x1 has pluralname) print "Die lijken niet ";
                  else print "Die lijkt niet ";
                  "op het slot te passen.";
               5: "Je doet ", (the) x1, " op slot.";
           }

  SwitchOn: switch(n)
           {   1: print_ret (CZezijnofDatis) x1,
                  " niet iets dat je kunt aanzetten.";
               2: print_ret (CZezijnofDatis) x1,
                  " al aan.";
               3: "Je zet ", (the) x1, " aan.";
           }
  SwitchOff: switch(n)
           {   1: print_ret (CZezijnofDatis) x1,
                  " niet iets wat je kunt uitzetten.";
               2: print_ret (CZezijnofDatis) x1,
                  " al uit.";
               3: "Je zet ", (the) x1, " uit.";
           }

  Open:    switch(n)
           {   1: print_ret (CZezijnofDatis) x1,
                  " niet iets wat je kunt openen.";
               2: if (x1 has pluralname) print "Ze zijn ";
                  else print (CdieofDat) x1, " zit ";
                  "zo te zien op slot.";
               3: print_ret (CZezijnofDatis) x1,
                  " al open.";
               4: print "Je opent ", (the) x1, ", en onthult ";
                  if (WriteListFrom(child(x1),
                      ENGLISH_BIT + TERSE_BIT + CONCEAL_BIT)==0) "niets.";
                  ".";
               5: "Je opent ", (the) x1, ".";
           }

  Close:   switch(n)
           {   1: print_ret (CZezijnofDatis) x1,
                  " niet iets wat je kunt sluiten.";
               2: print_ret (CZezijnofDatis) x1,
                  " al dicht.";
               3: "Je sluit ", (the) x1, ".";
           }
  Disrobe: switch(n)
           {   1: "Je draagt ", (DieofDat) x1, " niet.";
               2: "Je trekt ", (the) x1, " uit.";
           }
  Wear:    switch(n)
           {   1: "Je kunt ", (DieofDat) x1, " niet dragen!";
               2: "Je hebt ", (DieofDat) x1, " niet bij je!";
               3: "Je draagt ", (DieofDat) x1, " al!";
               4: "Je trekt ", (the) x1, " aan.";
           }
  Eat:     switch(n)
           {   1: print_ret (CZezijnofDatis) x1,
                  " duidelijk oneetbaar.";
               2: "Je eet ", (the) x1, ". Niet slecht.";
           }
  Yes, No:        "Dat was een rhetorische vraag.";
  Burn:           "Met zo'n gevaarlijke actie bereik je toch niets.";
  Pray:           "Je gebed leidt niet tot enig praktisch resultaat.";
  Wake:           "De afgrijselijk waarheid is dat dit geen droom is.";
  WakeOther:      "Dat lijkt me nergens voor nodig.";
  Kiss:           "Houd je gedachten bij het spel.";
  Think:          "Wat een goed idee.";
  Smell:          "Je ruikt niets onverwachts.";
  Listen:         "Je hoort niets onverwachts.";
  Taste:          "Je proeft niets onverwachts.";
  Touch:   switch(n)
           {   1: "Houd je handen thuis!";
               2: "Je voelt niets onverwachts.";
               3: "Als je denkt dat dat helpt...";
           }
  Dig:            "Met graven bereik je hier niets.";
 Cut:            print (CDieofDat) x1;
      switch (verb_word)
      {
       'snij':   " snijden heeft geen enkele zin.";
       'hak':    " omhakken heeft geen enkele zin.";
       'snoei':  " snoeien heeft geen enkele zin.";
       'knip':   " knippen heeft geen enkele zin.";
       'schaaf': " schaven heeft geen enkele zin.";
      };
  Jump:           "Je springt vruchteloos op en neer.";
  JumpOver, Tie:  "Daar zou je niets mee bereiken.";
  Drink:          "Er is hier niets te drinken.";
  Fill:           "Maar er is hier geen water om mee te nemen.";
  Sorry:          "Oh, je hoeft je niet te verontschuldigen.";
  Strong:         "Echte avonturiers gebruiken zulke taal niet.";
  Mild:           "Inderdaad.";
  Attack:         "Geweld lost niets op.";
  Swim:           "Er is niet genoeg water om in te zwemmen.";
  Swing:          "Er is niets zinnigs om mee te zwaaien.";
  Blow:           "Je kunt daar normaal gesproken niet op blazen.";
  Rub:            "Hier bereik je niets mee.";
  Set:            "Nee, je kunt ", (DieofDat) x1, " niet instellen.";
  SetTo:          "Nee, je kunt ", (DieofDat) x1, " nergens op instellen.";
  WaveHands:      "Je zwaait, en voelt jezelf nogal voor gek staan.";
  Wave:    switch(n)
           {   1: "Maar je hebt ", (DieofDat) x1, " in je handen.";
               2: "Je ziet er belachelijk uit nu je met ", (the) x1, "
	           zwaait.";
           }
  Pull, Push, Turn:
           switch(n)
           {   1: if (x1 has pluralname) print "Die zitten ";
                  else print "Dat zit ";
                  "stevig vast.";
               2: "Het lukt je niet.";
               3: "Er gebeurt zo te zien niets.";
               4: "Dat zou helemaal niet beleefd zijn.";
           }
  PushDir: switch(n)
           {   1: "Is dat het beste wat je kunt bedenken?";
               2: "Dat is geen richting.";
               3: "Nee, die kant op lukt je dat niet.";
           }
  Squeeze: switch(n)
           {   1: "Hou je handen thuis!";
               2: "Hier bereik je niets mee.";
           }
  ThrowAt: switch(n)
           {   1: "Zinloos.";
               2: "Op het moment supreme ontbreekt je het lef.";
           }
  Tell:    switch(n)
           {   1: "Je praat een tijdje in jezelf.";
               2: "Geen reactie.";
           }
  Answer, Ask:    "Er is geen antwoord.";
  Buy:            "Er is niets te koop.";
  Sing:           "Je zingt abominabel.";
  Climb:          "Ik denk niet dat daar veel mee te bereiken valt.";
  Wait:           "De tijd verglijdt.";
  Sleep:          "Je voelt je niet bijzonder moe.";
  Consult:        "Je ontdekt niets bijzonders in ", (the) x1, ".";
];

! ---------------------------------------------------------------------------
