// FROTZS5.H
//


#ifndef __FROTZS5_H__
#define __FROTZS5_H__

#include <e32svr.h>
#include <e32math.h>
#include <eikconso.h>
#include <e32keys.h>
#include <barsread.h>
#include <coecntrl.h>
#include <eikdef.h>
#include <eikenv.h>
#include <eikappui.h>
#include <eikdialg.h>
#include <eikdialg.hrh>
#include <eikcapc.h>
#include <eikcapca.h>
#include <eikctrls.hrh>
#include <eikcmds.hrh>
#include <eikmfne.h>
#include <eikmfne.hrh>
#include <eikfpne.h>
#include <eikedwin.hrh>
#include <eikcmbut.h>
#include <eiklabel.h>
#include <eikseced.h>
#include <eikrted.h>
#include <txtrich.h>
#include <eiktbar.h>
#include <eikchred.h>
#include <eikchmap.h>
#include <eikrted.h>
#include <eikopbut.h>
#include <eikhopbt.h>
#include <eikchkbx.h>
#include <eikmenub.h>
#include <eikmenup.h>
#include <eikmenu.hrh>
#include <eikfsel.h>
#include <eikapp.h>
#include <eikdoc.h>
#include <eikon.rsg>
#include <basched.h>
#include <frotzs5.rsg>
#include "frotzs5.hrh"

  // Convenient TInt used in the pragma data_seg.
  // See definition of symbol KNarrowReleaseUid defined in E32UID.H
const TInt KFrotzNarrowRelUidValue = 0x10000079;

// needed for creating server thread.
const TUint KDefaultHeapSize=0x100000;

// A version must be specifyed when creating a session with the server

const TUint KMainServMajorVersionNumber=0;
const TUint KMainServMinorVersionNumber=1;
const TUint KMainServBuildVersionNumber=1;

IMPORT_C TInt StartThread();

// opcodes used in message passing between client and server
enum TMainServRqst
	{
	EMainServCreate,
	EMainServClose,
	EMainServStop,
    EMainServPrintf,
    EMainServGetCh,
    EMainServKeyTimer,
    EMainServEraseRect,
    EMainServScroll,
    EMainServCursor,
    EMainServTextAttr,
    EMainServPutChar,
	EMainServPutString,
    EMainServSetCursor,
    EMainServDlgOpen,
    EMainServDlgSave,
	EMainServGetApp,
	EMainServGetStoryName,
	EMainServTerminate
	};

enum TMainServLeave
{
	ENonNumericString
};

// reasons for server panic
enum TMainServPanic
	{
	EBadRequest,
	EBadDescriptor,
	EMainSchedulerError,
	ESvrCreateServer,
	ESvrStartServer,
	ECreateTrapCleanup,
	ENotImplementedYet,
	};


int DlgOpen(char *pathsrc, char *file);
TInt FrotzStartFunction(TAny* aParam);

//**********************************
//CFrotzServServer
//**********************************
//The server class; an active object.
//Contains an instance of RServer; a handle to the kernel server representation which is used
//to receive messages.


//**********************************
//global functions
//**********************************

// function to panic the server
GLREF_C void PanicServer(TMainServPanic aPanic);
// thread function for server
GLREF_C TInt MainServerThread(TAny *);
class CFrotzAppUi;
class CMainServServer : public CServer
	{
public:
	enum {EPriority=950}; // mpt - need to explain the magic here!
    CFrotzAppUi *papp;
public:
//	static TInt ThreadFunction(TAny* aStarted);
	static CMainServServer* New(CFrotzAppUi *ptr);
//	void Delete();
	virtual CSession *NewSessionL(RThread aClient,const TVersion &aVersion) const;
//    static TInt StartFunction();
public:
	CMainServServer(TInt aPriority);
private:
	TInt				iActive;
	};

//**********************************
//CMainServSession
//**********************************
//This class represents a session in the server.
//CSession::Client() returns the client thread.
//Functions are provided to respond appropriately to client messages.


class CMainServSession : public CSession
	{
public:
	// construct/destruct
	CMainServSession(RThread &aClient, CMainServServer * aServer);
	static CMainServSession* NewL(RThread &aClient, CMainServServer * aServer);
	//service request
	virtual void ServiceL(const RMessage &aMessage);
	void DispatchMessageL(const RMessage &aMessage);
    CFrotzAppUi *papp;

protected:
	// panic the client
	void PanicClient(TInt aPanic) const;
	// safewrite between client and server
	void Write(const TAny* aPtr,const TDesC8& aDes,TInt anOffset=0);
private:
	//CMainServServer *iMainSvr;
	TInt iMain;
	int err;
	};
////////////////////////////////////////////////////////////////////////////////////////
// CFrotzAppUi
////////////////////////////////////////////////////////////////////////////////////////
class CKeyTimer;

class TPassParameters
	{
public:
	TInt iVar1 ;
	TInt iVar2 ;
	} ;

class CFrotzAppUi : public CEikAppUi
	{
public:
	void ConstructL();
	virtual ~CFrotzAppUi();
    void ReadProfile();
    void UpdateProfile();
    void DrawUserScreen();
    CCirBuf<TKeyEvent>* iKeyEventQ;
    CEikConsoleScreen *iCons;
    CEikConsoleControl *iControl;
    CKeyTimer *keytimer;
    //int keyreceived;
    CMainServServer *pS;
	//For thread
	char thestoryname[256];
	int storyrunning;
	int keyready;
	int waitingkey;
	RSemaphore SemaKey;
	int cattr;
	int cfontsize;
	int ctoolbar;
	int cscreenwidth, cscreenheight;
	int consolepixelwidth, consolepixelheight;
	int cboldmode;
	char storypath[128];
	char savepath[128];
	int boldtoggled;
	TInt threadrand;
	TPassParameters iparampass;
private: // framework
	RThread FrotzThread;
	CMainServServer *iMainSvr;
	virtual void HandleCommandL(TInt aCommand);
	void DynInitMenuPaneL(TInt aMenuId,CEikMenuPane* aMenuPane);
	void MakeToolBarVisible(TBool aVisible);
	TRequestStatus iLogonStatus;
	void HandleKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);
	};

class CKeyTimer : public CTimer
{
  public:
  CFrotzAppUi *papp;
  CKeyTimer():CTimer(EPriorityHigh){}
  ~CKeyTimer(){Cancel();}
  void Start(CFrotzAppUi *ptr, int delay);
  virtual void RunL(void);
};

class CExampleAboutDialog : public CEikDialog
	{
public:
	  // Construction
	CExampleAboutDialog(){};
	};

#endif
