! ==============================================================================
!   LINKLPA:  Link declarations of common properties and attributes.
!
!   Supplied for use with Inform 6 -- Release 6.12.5 -- Serial number 210605
!
!   Copyright Graham Nelson 1993-2004 and David Griffith 2012-2021
!
!   This file is free software: you can redistribute it and/or modify
!   it under the terms of the GNU Affero General Public License as
!   published by the Free Software Foundation, either version 3 of the
!   License, or (at your option) any later version.
!
!   This file is distributed in the hope that it will be useful, but
!   WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
!   Affero General Public License for more details.
!
!   You should have received a copy of the GNU Affero General Public
!   License along with this program. If not, see
!   https://gnu.org/licenses/
!
!   This file is automatically Included in your game file by "parser".
! ==============================================================================

System_file;

! ------------------------------------------------------------------------------
!   Some VM-specific constants.
!   (WORDSIZE and TARGET_XXX are defined by the compiler.)
! ------------------------------------------------------------------------------

#Ifdef TARGET_ZCODE;
Constant NULL         = $ffff;
Constant WORD_HIGHBIT = $8000;
#Ifnot; ! TARGET_GLULX
Constant NULL         = $ffffffff;
Constant WORD_HIGHBIT = $80000000;
#Endif; ! TARGET_

! ------------------------------------------------------------------------------
!   The common attributes and properties.
! ------------------------------------------------------------------------------

Attribute animate;
Attribute absent;       Attribute non_floating alias absent;
Attribute clothing;
Attribute concealed;
Attribute container;
Attribute door;
Attribute edible;
Attribute enterable;
Attribute general;
Attribute light;
Attribute lockable;
Attribute locked;
Attribute moved;
Attribute on;
Attribute open;
Attribute openable;
Attribute proper;
Attribute scenery;
Attribute scored;
Attribute static;
Attribute supporter;
Attribute switchable;
Attribute talkable;
Attribute transparent;
Attribute visited;
Attribute workflag;
Attribute worn;

Attribute male;
Attribute female;
Attribute neuter;
Attribute pluralname;

#Ifdef INFIX;
Attribute infix__watching;
#Endif;

! ------------------------------------------------------------------------------

Property additive before NULL;
Property additive after  NULL;
Property additive life   NULL;

Property n_to;
Property s_to;
Property e_to;
Property w_to;
Property ne_to;
Property nw_to;
Property se_to;
Property sw_to;
Property u_to;
Property d_to;
Property in_to;
Property out_to;

Property door_to;
Property with_key;
Property door_dir;
Property invent;
Property plural;
Property add_to_scope;
Property list_together;
Property react_before;
Property react_after;
Property grammar;
Property additive orders;

Property initial;
Property when_open;
Property when_closed;
Property when_on;
Property when_off;
Property description;
Property additive describe NULL;
Property article "a";

Property cant_go;

Property found_in;          ! For fiddly reasons this can't alias

Property time_left;
Property number;
Property additive time_out NULL;
Property daemon;
Property additive each_turn NULL;

Property capacity 100;

Property short_name 0;
Property short_name_indef 0;
Property parse_name 0;

Property articles;
Property inside_description;

! ==============================================================================
