#include <stdio.h>
#include <sgtty.h>

#if V7
#ifndef TIOCSETA
#define TIOCSETA TIOCSETP
#define TIOCGETA TIOCGETP
#endif
#define stty(fd,ttyptr) ioctl(fd, TIOCSETA, ttyptr)
#define gtty(fd,ttyptr) ioctl(fd, TIOCGETA, ttyptr)
#endif

extern int turn,speed;

ttopen(tn)
char *tn;
{
    int fd;

    if (tn == 0) return(0);
    if ((fd = open(tn,2)) < 0)
    {
	printmsg("Cannot open %s",tn);
#if ICDOC
	lckexit(1);
#else
	exit(1);
#endif
    }
    return(fd);
}


ttbin(fd,old)
int fd;
struct sgttyb *old;
{
    struct sgttyb new;

    gtty(fd,old);			/* Save current mode so we can */
    gtty(fd,&new);			/* restore it later */
#ifndef MINIX
    new.sg_flags |= (RAW);
#ifdef TANDEM
    if (!turn) new.sg_flags |= TANDEM;	/* use xon/xoff if no handshaking */
#endif
    new.sg_flags &= ~(ECHO|CRMOD);
#else
    new.sg_flags = RAW | BITS8;
#endif
    if (fd != 0) setspd(&new);		/* Speed if requested and supported */
    stty(fd,&new);			/* Put tty in raw mode */
}

ttres(fd,old)
int fd;
struct sgttyb *old;
{
    sleep(1);		/* wait before releasing the line */
    stty(fd,old);
}

setspd(tty)
struct sgttyb *tty;
{
    int spbits;
    if (speed)				/* User specified a speed? */
    {
	switch(speed)			/* Get internal system code */
    	{
#ifdef B110
	    case 110:  spbits = B110; break;
#endif
#ifdef B150
	    case 150:  spbits = B150; break;
#endif
#ifdef B300
	    case 300:  spbits = B300; break;
#endif
#ifdef B1200
	    case 1200: spbits = B1200; break;
#endif
#ifdef B1800
	    case 1800: spbits = B1800; break;
#endif
#ifdef B2400
	    case 2400: spbits = B2400; break;
#endif
#ifdef B4800
	    case 4800: spbits = B4800; break;
#endif
#ifdef B9600
	    case 9600: spbits = B9600; break; 
#endif

#if ICDOC
	    default:   printmsg("Bad line speed.");
			lckexit(1);
#else
	    default:   printmsg("Bad line spbits.");
			exit(1);
#endif
	}
	tty->sg_ispeed = spbits;
	tty->sg_ospeed = spbits;

    }
}

