## -*-Tcl-*-
 # ###################################################################
 #  CSS mode - tools for editing CSS documents
 # 
 #  FILE: "CSSCompletions.tcl"
 #                                    created: 98-04-05 21.30.48 
 #                                last update: 99-04-24 13.21.17 
 #  Author: Johan Linde
 #  E-mail: <jlinde@telia.com>
 #     www: <http://www.theophys.kth.se/~jl/Alpha.html>
 #  
 # Version: 1.1.1
 # 
 # Copyright 1997-1999 by Johan Linde
 #  
 # This software may be used freely, and distributed freely, as long as the 
 # receiver is not obligated in any way by receiving it.
 #  
 # If you make improvements to this file, please share them!
 # 
 # ###################################################################
 ##

set completions(CSS) {word}

# Word completion
proc CSS::Completion::word {dummy} {
	global cssLengths cssPercentage cssColors cssURLs cssAny cssGroup cssProperty
	global HTMLmodeVars
	
	set allCss [lunique [concat $cssLengths $cssPercentage $cssColors $cssURLs $cssAny \
	[array names cssGroup] [array names cssProperty] border-left border-top border-bottom border-right]]
	foreach p {size text Display} {
		set allCss [lreplace $allCss [set w [lsearch $allCss $p]] $w]
	}
	set matches ""
	# Between {}?
	set thepos [getPos]
	if {$thepos == [maxPos]} {set thepos [expr [maxPos] - 1]}
	if {[catch {matchIt "\}" $thepos} bpos]} {
		set allHtmlWords [cssGetHtmlWords]
		set pos [getPos]
		backwardWord
		set word [string toupper [getText [getPos] $pos]]
		foreach p $allHtmlWords {
			if {[string match $word* $p]} {lappend matches $p}
		}
		if {![llength $matches]} {
			select [getPos] $pos
		} else {
			replaceText [getPos] $pos [largestPrefix $matches]
		}
		return 1
	}
	# Get current word
	if {[catch {search -s -f 0 -m 0 -r 1 {[\{;: \t\r]} [expr [getPos] - 1]} wpos]} {set wpos "0 0"}
	set wpos [lindex $wpos 1]
	set word [getText $wpos [getPos]]
	# Before or after :?
	if {[catch {search -s -f 0 -m 0 -r 0 {;} [expr [getPos] - 1]} spos] || [lindex $spos 0] < $bpos} {set spos 0}
	set spos [lindex $spos 0]
	if {[catch {search -s -f 0 -m 0 -r 0 {:} [getPos]} cpos] || [lindex $cpos 0] < $bpos} {set cpos 0}
	set cpos [lindex $cpos 0]
	if {$spos < $cpos} {
		# After colon
		if {[catch {search -s -f 0 -m 0 -r 1 {[;\{ \t\r]} $cpos} w2pos]} {set w2pos 0}
		set pword [getText [lindex $w2pos 1] $cpos]
		if {[lsearch -exact $cssURLs $pword] >= 0 || [string match "url(*" $word]} {
			set matchWords $HTMLmodeVars(URLs)
			incr wpos 4
			set word [string trimleft [string range $word 4 end] \"]
			set isURL 1
		} else {
			set matchWords [eval concat $cssProperty($pword)]
			set isURL 0
		}
		foreach p $matchWords {
			if {[string match $word* $p]} {lappend matches $p}
		}
		if {![llength $matches]} {
			select $wpos [getPos]
		} else {
			set newval [largestPrefix $matches]
			if {$isURL} {set newval [htmlURLescape2 $newval]}
			replaceText $wpos [getPos] [lindex {"" "\""} $isURL]$newval
		}
	} else {
		# Before colon
		foreach p $allCss {
			if {[string match $word* $p]} {lappend matches $p}
		}
		if {![llength $matches]} {
			select $wpos [getPos]
		} else {
			set word [largestPrefix $matches]
			if {[llength $matches] == 1} {
				append word ": "
				set backTwo 0
				if {[lsearch -exact $cssURLs [string trimright $word ": "]] >= 0} {
					append word "url(\"\")"
					set backTwo 1
				}
			}
			replaceText $wpos [getPos] $word
			if {$backTwo} {goto [expr [getPos] - 2]}
		}
	}
	return 1
}
