/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser
 * Version: 0.9
 */
#define SELECTION_C

#include "wafe.h"
#include <X11/Xatom.h>

char *selected = NULL;
char *loseSelectionCommand = NULL;
char *doneSelectionCommand = NULL;

static Boolean
convertProc(owner, selection, target, typeReturn, valueReturn, 
            lengthReturn, formatReturn)
Widget          owner;
Atom           *selection;
Atom           *target;
Atom           *typeReturn;
XtPointer      *valueReturn;
unsigned long  *lengthReturn;
int            *formatReturn;
    {
    DBUG_ENTER("ConvertProc");

    if (*target != XA_STRING)
	{
	fprintf(stderr, "Requested target-type %ld is unsupported!\n",*target);
	DBUG_RETURN(False);
	}
    else
	{
	*valueReturn = (XtPointer) selected;
	*typeReturn = XA_STRING;
	*formatReturn = 8;
	*lengthReturn = strlen(selected);
	DBUG_RETURN(True);
	}
    }
           
static void
loseSelectionProc(w, selection)
Widget     w;
Atom      *selection;
     {
     DBUG_ENTER("loseSelectionProc");
     (void) wafeEval(wafeInterpreter, loseSelectionCommand, "loseSelectionProc");
     DBUG_VOID_RETURN;
     }

static void
doneSelectionProc(w, selection, target)
Widget     w;
Atom      *selection;
Atom      *target;
    {
    DBUG_ENTER("doneSelectionDoneProc");
    (void) wafeEval(wafeInterpreter, doneSelectionCommand,"doneSelectionProc");
    DBUG_VOID_RETURN;
    }

void
wafeGetSelectionValueProc(w, clientData, selection, type, value, length, format)
Widget         w;
XtPointer      clientData;
Atom          *selection;
Atom          *type;
XtPointer      value;
unsigned long *length;
int           *format;
    {
    char *command = (char *) clientData;
    char *primary;

    DBUG_ENTER("getSelectionValueProc");

    if (value == NULL)
	primary = "";
    else
	primary = (char *)value;
    
    Tcl_SetVar(wafeInterpreter, "PRIMARY", primary, TCL_GLOBAL_ONLY);
    (void) wafeEval(wafeInterpreter, command, "selectionProc");

    DBUG_VOID_RETURN;
    }


Boolean
wafeOwnSelectionCmd(string, loseSelection, doneSelection)
String      string;
String      loseSelection;
String      doneSelection;
    {
    XtLoseSelectionProc    loseProc = NULL;
    XtSelectionDoneProc   doneProc = NULL;

    if (selected)
	XtFree(selected);
    selected = string;


    if (loseSelectionCommand)
	XtFree(loseSelectionCommand);
    if (loseSelection) 
	{
	loseProc = loseSelectionProc;
	loseSelectionCommand = XtNewString(loseSelection);
	}


    if (doneSelectionCommand)
	XtFree(doneSelectionCommand);
    if (doneSelection) 
	{
	doneProc = doneSelectionProc;
	doneSelectionCommand = XtNewString(doneSelection);
	}


    if (XtOwnSelection(wafeTopLevel, XA_PRIMARY,  CurrentTime,
		       convertProc, loseProc, doneProc))
	return True;
    else  
	{
	fprintf(stderr, "Wafe(OwnSelection): Couldn't get PRIMARY Buffer\n");
	return False;
	}      
    }
