package Message::Passing::Output::Syslog;

use Moo;
use Sys::Syslog;
use File::Basename 'fileparse';
use JSON::MaybeXS ();

our $VERSION = '0.01';

has facility => (
  is => 'ro', default => sub { 'USER' }
);

has ident => (
  is => 'ro', default => sub {
    my ($filename) = fileparse($0); $filename;
  }
);

has logopt => (
  is => 'ro', default => sub { 'pid' }
);

has level => (
  is => 'ro', default => sub { 'debug' }
);

has _json => (
  is      => 'lazy',
  default => sub {
    my $self = shift;
    return JSON::MaybeXS->new( utf8 => 1, pretty => 0 );
  },
);

sub BUILD {
  my ($self) = @_;
  openlog( map { $self->$_ } qw(ident logopt facility) );
}

sub consume {
  my ($self, $data) = @_;
  return unless $data;
  my $level = ref($data) ?
    $data->{'level'} || $self->level
    : $self->level;
  my $msg = ref($data) ? $self->_json->encode($data) : $data;
  syslog($level, $msg);
}

1;
__END__

=encoding utf-8

=head1 NAME

Message::Passing::Output::Syslog - output messages into syslog

=head1 SYNOPSIS

  $ message-pass --input STDIN --output Syslog

=head1 DESCRIPTION

A simple message output which publishes messages to syslog.

=head1 AUTHOR

Wallace Reis E<lt>wallace@reis.meE<gt>

=head1 COPYRIGHT

Copyright 2018- Wallace Reis

=head1 LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

=cut
