/*
 * FCKeditor - The text editor for internet
 * Copyright (C) 2003-2005 Frederico Caldeira Knabben
 * 
 * Licensed under the terms of the GNU Lesser General Public License:
 *    http://www.opensource.org/licenses/lgpl-license.php
 * 
 * For further information visit:
 *    http://www.fckeditor.net/
 * 
 * File Name: fckplugin.js
 * 
 */
FCKCommands.RegisterCommand('Abbr', new FCKDialogCommand( 'Abbr', FCKLang.AbbrDlgTitle, FCKPlugins.Items['Abbr'].Path + 'fck_abbr.html', 375, 300 ) ) ;

// Create the "Abbr" toolbar button.
var oAbbrItem = new FCKToolbarButton( 'Abbr', FCKLang.AbbrBtn ) ;
oAbbrItem.IconPath = FCKPlugins.Items['Abbr'].Path + 'plugin.gif' ;
FCKToolbarItems.RegisterItem( 'Abbr', oAbbrItem ) ;

// The object used for all Abbr operations.
var FCKAbbr = new Object() ;

// Insert a new Abbr
FCKAbbr.Insert = function(val, isSafari) {

    val = val.replace(/^\s+/,'');
    val = val.replace(/\s+$/,'');
   
    if(val) {
          val = '"' + val + '"';
    }

	var hrefStartHtml	= (val == '') ? '<plugin>' : '<plugin title=' + val + '>';
	var hrefEndHtml		= '</plugin>&nbsp;';
    var reset = false;

	mySelection = ( FCKBrowserInfo.IsIE) ? FCKSelection.GetSelectedHTML(isSafari) : removeBR(FCKSelection.GetSelectedHTML(isSafari));

    mySelection = mySelection.replace(/^\s+/,"");
    mySelection = mySelection.replace(/\s+$/,"");

    if(mySelection.match(/<\/FCK:plugin>/)) {
            reset = true;
    }
    mySelection = mySelection.replace(/<\/FCK:plugin>/gi,"");
    mySelection = mySelection.replace(/<FCK:plugin.*?>/gi,"");

    mySelection = mySelection.replace(/<\/P>/gi,"");
    mySelection = mySelection.replace(/^<P.*?>/gi," ");
    mySelection = mySelection.replace(/&nbsp;/gi, "");  // for IE in <indent>

    mySelection = mySelection.replace(/<indent.*?indent>/gi, "");

    mySelection = mySelection.replace(/<P>/gi," &lt;p&gt; ");   
    mySelection = mySelection.replace(/<P.*?>/gi," ");  

    mySelection = mySelection.replace(/<br>/g," &lt;br&gt; ");
    mySelection = mySelection.replace(/<br\s+\/>/g," &lt;br&gt; ");
 
    if(FCKBrowserInfo.IsIE && reset) {
        hrefHtml = mySelection;
   }
	else {  
      hrefHtml = hrefStartHtml+mySelection+hrefEndHtml;
	}



//////////////////////////////////////////////////////
// 	choose one of these two lines; in fckeditor 2.5 both lines can be skipped!!!
//	
// 	hrefHtml = FCK.ProtectTags( hrefHtml ) ;								// needed because in fckeditor 2.4 protected tags only works with SetHTML
//	hrefHtml = ProtectTags( hrefHtml ) ;									// needed because IE doesn't support <abbr> and it breaks it.
/////////////////////////////////////////////////////

	FCK.InsertHtml(hrefHtml);
}

FCKSelection.GetSelectedHTML = function(isSafari) {	

							// see http://www.quirksmode.org/js/selected.html for other browsers
	if( FCKBrowserInfo.IsIE) {												// IE
		var oRange = FCK.EditorDocument.selection.createRange() ;
		//if an object like a table is deleted, the call to GetType before getting again a range returns Control
		switch ( this.GetType() ) {
			case 'Control' :
			return oRange.item(0).outerHTML;

			case 'None' :
			return '' ;

			default :
			return oRange.htmlText ;
		}
	}
	else if ( FCKBrowserInfo.IsGecko || isSafari ) {									// Mozilla, Safari

									// Mozilla, Safari
		var oSelection = FCK.EditorWindow.getSelection();
		//Gecko doesn't provide a function to get the innerHTML of a selection,
		//so we must clone the selection to a temporary element and check that innerHTML
		var e = FCK.EditorDocument.createElement( 'DIV' );
		for ( var i = 0 ; i < oSelection.rangeCount ; i++ ) {
			e.appendChild( oSelection.getRangeAt(i).cloneContents() );
		}
		return e.innerHTML;
	}
}

function removeBR(input) {							/* Used with Gecko */
	var output = "";
	for (var i = 0; i < input.length; i++) {
		if ((input.charCodeAt(i) == 13) && (input.charCodeAt(i + 1) == 10)) {
			i++;
			output += " ";
		}
		else {
			output += input.charAt(i);
   		}
	}
	return output;
}


// put it into the contextmenu (optional)
FCK.ContextMenu.RegisterListener( {
	AddItems : function( menu, tag, tagName ) {
		// when the option is displayed, show a separator then the command
		menu.AddSeparator() ;
		// the command needs the registered command name, the title for the context menu, and the icon path
		menu.AddItem( 'Abbr', FCKLang.Abbr, oAbbrItem.IconPath ) ;
	}
}
);
