<?php
/**
 * 
 * @license    GPL 2 (http://www.gnu.org/licenses/gpl.html)
 * @author     Myron Turner <turnermm02@shaw.ca>
 */

// must be run within Dokuwiki
if(!defined('DOKU_INC')) die();
 
if(!defined('DOKU_PLUGIN')) define('DOKU_PLUGIN',DOKU_INC.'lib/plugins/');
require_once(DOKU_PLUGIN.'syntax.php');
 
/**
 * All DokuWiki plugins to extend the parser/rendering mechanism
 * need to inherit from this class
 */
class syntax_plugin_fckg_dwplugin extends DokuWiki_Syntax_Plugin {
  var $plugin_ref;
  var $escaped_pattern;

   function syntax_plugin_fckg_dwplugin() {
      global $EVENT_HANDLER;
      $EVENT_HANDLER->register_hook('PARSER_HANDLER_DONE', 'BEFORE', $this, 'meta_scripts');
   }

    /**
     * return some info
     */
    function getInfo(){
        return array(
            'author' => 'Myron Turner',
            'email'  => 'turnermm02@shaw.ca',
            'date'   => '2007-07-26',
            'name'   => 'Plugin handler',
            'desc'   => 'supports dokuwiki plugins',
            'url'    => 'http://www.mturner.org/development/',
        );
    }
 
    function getType(){ return 'formatting'; }
    function getAllowedTypes() { return array('formatting','substition'); }   
    function getSort(){ return 80; }
    function connectTo($mode) {
         $this->Lexer->addSpecialPattern('<plugin.*?</plugin>',$mode,'plugin_fckg_dwplugin'); 
       }

    function handle($match, $state, $pos, &$handler){  
    
     if(isset($_REQUEST['do']) && $_REQUEST['do'] == 'edit') {

         list($title, $pattern) = explode('>',substr($match,7,-9),2);          
         $pattern=trim($pattern);
           // escape '<' and '>' using ~ for escape character
         $pattern = preg_replace('/(?<!~)(<+)(?!~)/', '~' . '\\1' . '~',$pattern);   
         $pattern = preg_replace('/(?<!~)(>+)(?!~)/','~' . '\\1' . '~',$pattern); 
         $match = "<plugin $title>$pattern</plugin>";

         return array($state,$match); 
     }

     
      $this->escaped_pattern = false;  
      if(preg_match('/~(<+)~/',$match)) {
         $this->escaped_pattern = true;
      }
      $match = preg_replace('/~(<+)~/','\\1',$match); 
      $match = preg_replace('/~(>+)~/','\\1',$match); 
    
      $mode = 'xhtml';
      $file = DOKU_INC."inc/parser/$mode.php";      
      @require_once($file);

      list($title, $pattern) = explode('>',substr($match,7,-9),2);
      if(!$title) return array($state,"");

      list($t,$plugin) =  explode('=',$title);      
      $plugin=trim($plugin); 
      $pattern=trim($pattern);
      
      if(!isset($plugin)) return array($state,"");
      
      $match = $pattern;
      if(isset($plugin)) {
        $this->plugin_ref = $this->setup_plugin($plugin,$pattern);
         if($this->plugin_ref) {
             list($state, $match) = $this->plugin_ref->handle($match, $state, $pos, $handler);  
             $Renderer = & new Doku_Renderer_xhtml();   
             $this->plugin_ref->render('xhtml', $Renderer, array($state, $match));   
             return array($state, $Renderer->doc);
         }
      }

       return array($state,"");
    }
      
    function & setup_plugin($plugin, $pattern) {
          global $INFO;
          global $DWPLUGINS;
         // Access Doku_LexerParallelRegex class
         // Get plugin name 
         $DLP = $this->Lexer->_regexes['base'];
         $plugin_name = $DLP->match($pattern,$matches); 
         if($plugin_name === true || $plugin_name === false) {   // name wasn't found 
            $p_ref = & plugin_load('syntax', $plugin);     // try plugin name given in title attribute
            if($p_ref && $this->escaped_pattern) $DWPLUGINS[] =  $plugin;   
         }
         else {
                          // this will fail if $plugin_name doesn't match plugin directory name
                         // $DLP->match returns name as _plugin_name
             $plugin = substr($plugin_name,8); // remove '_plugin_'  
             
             $p_ref =  &plugin_load('syntax', $plugin);         
             if($p_ref && $this->escaped_pattern) $DWPLUGINS[] =  $plugin;  

             if(!$p_ref) {  // if above fails create class name and try to instantiate it
                $func = 'syntax' . $plugin_name; 
                if(class_exists($func,false)) {  
                    $p_ref = new $func();
                }
            }
         }

         return $p_ref;
    }


    /**
     * Create output
     */
    function render($mode, &$renderer, $data) {

  
        if($mode == 'xhtml'){            
            list($state, $match) = $data;
            $renderer->doc .= $match;          
            
            return true;         
         }
        
              
        return false;
    } 


function meta_scripts(&$event) {
  global $DWPLUGINS, $INFO, $conf;
  require_once(DOKU_INC . 'inc/io.php');


          if(count($DWPLUGINS)) {
            $list = array();            
            foreach ($DWPLUGINS as $p){
                if(file_exists(DOKU_PLUGIN."$p/script.js")) {
                $list[$p] = DOKU_BASE."lib/plugins/$p/script.js";
                }
            }
              $meta_data = array($list, $DWPLUGINS);
               
              $meta_path = str_replace(':', '/', $INFO['id']);
              $meta_path = $conf['metadir']  . '/' . $meta_path . '_dwpi.meta';
              $data = serialize($meta_data);
              io_saveFile($meta_path, $data);
          }

  }
}
 

