#!perl -T

use strict;
use warnings;

use Test::More tests => 51;
use Math::BigNum;

foreach my $pair (
                  qw/
                  123:123:123
                  123.4:123.4:123.4
                  1.4:1.4:1.4
                  0.1:0.1:0.1
                  -0.1:-0.1:-0.1
                  -1.1:-1.1:-1.1
                  -123.4:-123.4:-123.4
                  -123:-123:-123
                  123e2:123e2:12300
                  123e-1:12.3:12.3
                  123e-4:0.0123:0.0123
                  123e-3:0.123:0.123
                  123.345e-1:12.3345:12.3345
                  123.456e+2:12345.6:12345.6
                  1234.567e+3:1234567:1234567
                  1234.567e+4:1234567E1:12345670
                  1234.567e+6:1234567E3:1234567000
                  /
  ) {
    my ($x, $y, $z) = split(/:/, $pair);

    my $n = Math::BigNum->new($x);
    my $m = Math::BigNum->new($y);

    is($n,   $m, qq/new("$x") = $y/);
    is("$n", $z, qq/"$x" = $z/);
    is("$m", $z, qq/"$y" = $z/);
}
