#!/usr/bin/perl -w 
#
# Converts stdin and converts NFL_I_XXX nad NFL_T_XXX fields into 
# perl hash structure 
#

my $SUFFIX = "\t\t# generated by h2fields.pl";

use strict; 

my (%F, %D);

while (<STDIN>) {
	# parse follwig lines
	#0x00370008  icmptype             NSEL ICMP type value
	if (/^\s+(0x.+?)\s+(.+?)\s+(.+)$/) {
		my ($id, $name, $descr) = ($1, $2, $3);
		
		$F{$id} = $name;
		$D{$id} = $descr;
	}
}

printf "# generated with h2fields.pl\n";
printf "package Net::NfDump::Fields;\n";
printf "our %%NFL_FIELDS_INT = (\n";
foreach ( sort keys %F ) {
	printf "\t%s => \'%s\',\n", $_, $F{$_};
}
printf ");\n\n";

printf "our %%NFL_FIELDS_TXT = (\n";
foreach ( sort keys %F ) {
	printf "\t\'%s\' => %s,\n", $F{$_}, $_;
}
printf ");\n\n";

printf "=pod\n\n";
printf "=head1 LIST OF ITEMS SUPPORTED BY Net::NfDump\n\n";

foreach ( sort keys %F ) {
	printf "  %s => %s\n", $F{$_}, $D{$_};
}

printf "\n=cut\n";
printf "\n";

