#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::SiteCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SiteCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::SiteCodeType

=head1 DESCRIPTION

eBay sites (by the country in which each resides) on which a user is registered
and on which items can be listed.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 US

USA, site ID 0, abbreviation US, currency USD.



=cut


use constant US => scalar('US');


=head2 Canada

Canada, site ID 2, abbreviation CA, currencies CAD and USD.



=cut


use constant Canada => scalar('Canada');


=head2 UK

United Kingdom, site ID 3, abbreviation UK, currency GBP.



=cut


use constant UK => scalar('UK');


=head2 Australia

Australia, site ID 15, abbreviation AU, currency AUD.



=cut


use constant Australia => scalar('Australia');


=head2 Austria

Austria, site ID 16, abbreviation AT, currency EUR.



=cut


use constant Austria => scalar('Austria');


=head2 Belgium_French

Belgium (French), site ID 23, abbreviation BEFR, currency EUR.



=cut


use constant Belgium_French => scalar('Belgium_French');


=head2 France

France, site ID 71, abbreviation FR, currency EUR.



=cut


use constant France => scalar('France');


=head2 Germany

Germany, site ID 77, abbreviation DE, currency EUR.



=cut


use constant Germany => scalar('Germany');


=head2 Italy

Italy, site ID 101, abbreviation IT, currency EUR.



=cut


use constant Italy => scalar('Italy');


=head2 Belgium_Dutch

Belgium (Dutch), site ID 123, abbreviation BENL, currency EUR.



=cut


use constant Belgium_Dutch => scalar('Belgium_Dutch');


=head2 Netherlands

Netherlands, site ID 146, abbreviation NL, currency EUR.



=cut


use constant Netherlands => scalar('Netherlands');


=head2 Spain

Spain, site ID 186, abbreviation ES, currency EUR.



=cut


use constant Spain => scalar('Spain');


=head2 Switzerland

Switzerland, site ID 193, abbreviation CH, currency CHF.



=cut


use constant Switzerland => scalar('Switzerland');


=head2 Taiwan

Taiwan, currency TWD. Note that the old eBay Taiwan site is no longer in operation, and the new site does not use this API.



=cut


use constant Taiwan => scalar('Taiwan');


=head2 eBayMotors

eBay Motors, site ID 100, currency USD.



=cut


use constant eBayMotors => scalar('eBayMotors');


=head2 HongKong

Hong Kong, site ID 201, abbreviation HK, currency HKD.



=cut


use constant HongKong => scalar('HongKong');


=head2 Singapore

Singapore, site ID 216, abbreviation SG, currency SGD.



=cut


use constant Singapore => scalar('Singapore');


=head2 India

India, site ID 203, abbreviation IN, currency INR.



=cut


use constant India => scalar('India');


=head2 China

China, currency CNY. Note that there is no longer an eBay China site.



=cut


use constant China => scalar('China');


=head2 Ireland

Ireland, site ID 205, abbreviation IE, currency EUR.



=cut


use constant Ireland => scalar('Ireland');


=head2 Malaysia

Malaysia, site ID 207, abbreviation MY, currency MYR.



=cut


use constant Malaysia => scalar('Malaysia');


=head2 Philippines

Philippines, site ID 211, abbreviation PH, currency PHP.



=cut


use constant Philippines => scalar('Philippines');


=head2 Poland

Poland, site ID 212, abbreviation PL, currency PLN.



=cut


use constant Poland => scalar('Poland');


=head2 Sweden

Sweden, site ID 218, abbreviation SE, currency SEK.



=cut


use constant Sweden => scalar('Sweden');


=head2 CustomCode

Reserved for internal or future use



=cut


use constant CustomCode => scalar('CustomCode');


=head2 CanadaFrench

CanadaFrench, site ID 210, abbreviation CAFR, currencies CAD and USD.



=cut


use constant CanadaFrench => scalar('CanadaFrench');







1;   
