package App::EventStreamr::IngestTest;
use Method::Signatures;
use Moo;
use namespace::clean;

# ABSTRACT: A  Test Ingest Process

our $VERSION = '0.3'; # VERSION: Generated by DZP::OurPkg:Version


extends 'App::EventStreamr::Process';

has 'cmd'         => ( is => 'ro', lazy => 1, builder => 1 );
has 'id'          => ( is => 'ro', required => 1 );
has 'device'      => ( is => 'ro', required => 1 );
has 'type'        => ( is => 'ro', default => sub { 'IngestTest' } );

method _build_cmd() {
  return 'ping 127.0.0.1';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::EventStreamr::IngestTest - A  Test Ingest Process

=head1 VERSION

version 0.3

=head1 SYNOPSIS

This Provides a Test ingest process.

=head1 DESCRIPTION

This largely extends L<App::EventStreamr::Process>.

=head1 AUTHOR

Leon Wright < techman@cpan.org >

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2014 by Leon Wright.

This is free software, licensed under:

  The GNU Affero General Public License, Version 3, November 2007

=cut
