#!perl
use Test::More;
use InfluxDB::Client::DataSet;
use InfluxDB::LineProtocol;

plan tests => 2;

my ($ds);

subtest 'create DataSet' => sub {
    eval {
        $ds = InfluxDB::Client::DataSet->new(
            measurement => 'measurement',
            values => {
                cost        => 42,
                funfactor   => 1000,
                available   => 3
            },
            tags => {
                tag => 'wanted'
            }
        );
    };
    if ($@) {
        fail();
        diag($@);
    } else {
        pass();
    }
};

subtest 'to_string' => sub {
    my $s1 = $ds->as_string;
    my $s2 = InfluxDB::LineProtocol::data2line(
        'measurement',
        {
            cost        => 42,
            funfactor   => 1000,
            available   => 3
        },
        {
            tag => 'wanted'
        },
        $ds->ts #  we need the timestamp from the object
    );
    is($s2,$s1);
};

done_testing;
