package InfluxDB::Client::Response::Status;
# ABSTRACT: status flags of the L<InfluxDB::Client::Response> class

use strict;
use warnings;


use constant {
    OK       => 1,
    SRVFAIL  => 2,
    AUTH     => 3,
    INTFAIL  => 4,
};

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

InfluxDB::Client::Response::Status - status flags of the L<InfluxDB::Client::Response> class

=head1 VERSION

version 0.1

=head1 CONSTANTS

=head2 B<OK>

the request returned no error

=head2 B<SRVFAIL>

either the server returned an HTTP error, or we could not find a valid server

=head2 B<AUTH>

authentication failed

=head2 B<INTFAIL>

internal failure, mostly unparsable JSON

=head1 AUTHOR

Thomas Berger <thomas.berger@1und1.de>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2017 by 1&1 Telecommunication SE.

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut
