# WARNING: DO NOT EDIT THIS FILE, EDIT Peek.pm.mp1.perl5.8 instead

package Apache::Peek;

use strict;
use warnings;

use XSLoader ();
use base qw(Exporter Devel::Peek);

our $VERSION = 1.01;
our @EXPORT = qw(Dump DumpArray);

use mod_perl;
die "This module was built against mod_perl 1.0 ", 
    "and can't be used with $mod_perl::VERSION, "
    unless $mod_perl::VERSION < 1.98;

XSLoader::load 'Apache::Peek';

1;

__END__

=head1 NAME

Apache::Peek - A data debugging tool for the XS programmer (under mod_perl)

=head1 SYNOPSIS

        use Apache::Peek;
        Dump( $a );
        Dump( $a, 5 );
        DumpArray( 5, $a, $b, ... );

        # more functionality inherited from Devel::Peek

=head1 DESCRIPTION

C<Apache::Peek> is a sub-class of C<Devel::Peek>. The only difference
is that it overrides the stderr stream, to which C<Devel::Peek> sends
its output, and send the output to the client instead.

Note: The following table summarizes what parts of the
C<Devel::Peek>'s API are available, depending on the used Perl version
and configurations:

  5.005_0x                 all
  5.6.x                    only Dump()
  5.8.x (w/  -Duseperlio)  all
  5.8.x (w/o -Duseperlio)  none

Patches to complete the functionality under all configurations are
welcome.

C<Apache::Peek> works both with mod_perl 1.0 and 2.0.

See the C<Devel::Peek> manpage for a complete documentation.

=head1 AUTHOR

Hacking the mod_perl versions:

Doug MacEachern         dougm@pobox.com

Stas Bekman             stas@stason.org

Writing the original C<Devel::Peek>

Ilya Zakharevich	ilya@math.ohio-state.edu

=head1 Copyright

Copyright (c) 1995-98 Ilya Zakharevich. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

Author of this software makes no claim whatsoever about suitability,
reliability, edability, editability or usability of this product, and
should not be kept liable for any damage resulting from the use of
it. If you can use it, you are in luck, if not, I should not be kept
responsible. Keep a handy copy of your backup tape at hand.

=head1 SEE ALSO

L<perlguts>, and L<perlguts>, again.

=cut
