package Spp;

our $VERSION = '1.05';

use Exporter;
our @ISA       = qw(Exporter);
our @EXPORT_OK = qw(get_parser match parse);

use 5.012;
no warnings "experimental";
use Spp::SppAst qw(get_spp_ast);
use Spp::SppGrammar qw(get_spp_grammar);
use Spp::Tools qw(read_file write_file trim to_json);
use Spp::LintParser qw(lint_parser);
use Spp::Match qw(match);
use Spp::OptSppAst qw(opt_spp_ast);

sub get_ast_table {
   my $ast   = shift;
   my $table = {};
   for my $spec (@{$ast}) {
      my ($name, $rule) = @{$spec};
      if (exists $table->{$name}) {
         say("repeat token define $name");
      }
      $table->{$name} = $rule;
   }
   return $table;
}

sub get_ast_parser {
   my $ast = shift;
   my $door  = $ast->[0][0];
   my $table = get_ast_table($ast);
   return [$door, $table];
}

sub get_spp_parser {
  my $ast = get_spp_ast();
  return get_ast_parser($ast);
}

sub get_grammar_ast {
  my $text = shift;
  my $parser = get_spp_parser();
  my $match = match($parser, $text);
  return opt_spp_ast($match);
}

sub get_parser {
  my $grammar_text = shift;
  my $ast = get_grammar_ast($grammar_text);
  return get_ast_parser($ast);
}

sub eval_spp_ast {
  my $ast = shift;
  my $parser = get_ast_parser($ast);
  if (exists $parser->[1]->{'text'}) {
    my $text = get_text($parser->[1]->{'text'});
    return match($parser, $text);
  }
  if (exists $parser->[1]->{'file'}) {
    my $file = get_text($parser->[1]->{'file'});
    my $text = read_file($file);
    return match($parser, $text);
  }
  return $ast;
}

sub get_text {
  my $rule = shift;
  return $rule->[1] if is_str_atom($rule);
  die "could not get Rule text not Str atom";
}

## test basic parse rule
sub repl {
   my $parser = get_spp_parser();
   lint_parser($parser);
   say("This is Spp REPL, type enter to exit.");
   while (1) {
      print(">> ");
      my $line = <STDIN>;
      exit() if $line eq "\n";
      $line = trim($line);
      my $match = match($parser, $line);
      # say("match-> ", to_json($match));
      my $ast = opt_spp_ast($match);
      $ast = eval_spp_ast($ast);
      say(".. ", to_json($ast));
   }
}

# should add lang to --lang mylisp --action update
sub update {
  my $grammar_str = get_spp_grammar();
  my $ast = get_grammar_ast($grammar_str);
  my $code = to_ast_func($ast);
  write_file("SppAst.pm", $code);
  say("write SppAst.pm ok!");
}

# --action lint --grammar grammar.file
sub lint {
  my $spp_file = shift;
  my $spp_text = read_file($spp_file);
  my $ast = get_grammar_ast($spp_text);
  my $parser = get_ast_parser($ast);
  lint_parser($parser);
}

sub parse {
   my ($grammar_text, $code_text) = @_;
   my $parser = get_parser($grammar_text);
   lint_parser($parser);
   return match($parser, $code_text);
}

# --action spp --grammar grammar.file --target target.file
sub spp {
   my ($grammar_file, $text_file) = @_;
   my $grammar = read_file($grammar_file);
   my $text    = read_file($text_file);
   return parse($grammar, $text);
}

sub to_ast_func {
   my $code = shift;
   my $str  = <<'EOFF';
## Create by Spp::to_ast_func()   
package Spp::SppAst;

use Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(get_spp_ast);

use JSON::XS qw(decode_json);

sub get_spp_ast {
   return decode_json(<<'EOF'
EOFF
   return $str . to_json($code) . "\nEOF\n) }\n1;";
}

1;
