package Task::Catalyst;

use strict;

our $VERSION = '1.10';

=head1 NAME

Task::Catalyst - All you need to start with Catalyst

=head1 SYNOPSIS

C<perl -MCPAN -e 'install Task::Catalyst'>

=head1 DESCRIPTION

Installs everything you need to write serious Catalyst applications.

L<Catalyst>

L<Catalyst::Plugin::FormValidator>

L<Catalyst::Plugin::FormValidator::Simple>

L<Catalyst::Plugin::FillInForm>

L<Catalyst::Plugin::Prototype>

L<Catalyst::Plugin::Singleton>

L<Catalyst::Plugin::DefaultEnd>

L<Catalyst::Plugin::SubRequest>

L<Catalyst::Plugin::Session>

L<Catalyst::Plugin::Session::Store::File>

L<Catalyst::Plugin::Session::State::Cookie>

L<Catalyst::Plugin::Session::State::URI>

L<Catalyst::Model::DBIC::Plain>

L<Catalyst::Model::DBIC>

L<Catalyst::View::TT>

L<Test::WWW::Mechanize::Catalyst>

L<DBD::SQLite>

L<YAML>

=head1 AUTHOR

Sebastian Riedel, C<sri@oook.de>

=head1 LICENSE

This library is free software, you can redistribute it and/or modify it under
the same terms as Perl itself.

=cut

1;
