#
#  USAGE: perl -MTest::Harness -e "runtests('class2.t');"
#
#  Test of \p{ .. }, \P{ .. }, etc.
#
#  This script uses ShiftJIS::String.
#
$::HARNESS = $] > 5.004; # true (please change it if this is FALSE.)

use ShiftJIS::String qw(mkrange);
use ShiftJIS::Regexp qw(re match);

my $time = time;

my $n  = 0;
my @NG;

my %char = (
 n => [ "\n" ],
 r => [ "\r" ],
 f => [ "\f" ],
 t => [ "\t" ],
 v => [ "\x0b" ],
 s => [ ' '  ],
 S => [ '@' ],
 b => [ "\x7F" ],
 c => [ mkrange("\x00-\x08\x0e-\x1F") ],
 p => [ mkrange('!-/:-@[-^`{-~') ],
 q => [ '_' ],
 d => [ mkrange("0-9") ],
 u => [ mkrange("A-Z") ],
 l => [ mkrange("a-z") ],
 D => [ mkrange('O-X') ],
 U => [ mkrange('`-y') ],
 L => [ mkrange('-') ],
 G => [ mkrange('-') ],
 Q => [ mkrange('-') ],
 C => [ mkrange('@-`') ],
 R => [ mkrange('p-') ],
 H => [ mkrange('-JKTU') ],
 K => [ mkrange('@-[RS')   ],
 h => [ mkrange('-') ],
 k => [ mkrange('-') ],
 J => [ mkrange('-r') ],
 Z => [ mkrange('-') ],
 Y => [ mkrange('V-Z') ],
 P => [ mkrange('A-IL-Q\---΁--') ],
 B => [ mkrange('-') ],
 N => [ mkrange("\x87\x40-\x87\x5D\x87\x5F-\x87\x75\x87\x7E-\x87\x9C"
	.	"\xED\x40-\xEE\xEC\xEE\xEF-\xEE\xFC") ],
 I => [ mkrange("\xFA\x40-\xFC\x4B") ],
 X => [ mkrange("\x81\xAD-\x81\xB7\x81\xC0-\x81\xC7\x81\xCF-\x81\xD9"
	.	"\x81\xE9-\x81\xEF\x81\xF8-\x81\xFB\x82\x40-\x82\x4E"
	.	"\x82\x59-\x82\x5F\x82\x7A-\x82\x80\x82\x9B-\x82\x9E"
	.	"\x82\xF2-\x82\xFC\x83\x97-\x83\x9E\x83\xB7-\x83\xBE"
	.	"\x83\xD7-\x83\xFC\x84\x61-\x84\x6F\x84\x92-\x84\x9E"
	.	"\x84\xBF-\x86\xFC\x88\x40-\x88\x9E\x98\x73-\x98\x9E"
	.	"\x87\x5E\x87\x76-\x87\x7D\x87\x9D-\x87\xFC"
	.	"\xEA\xA5-\xEC\xFC"
	.	"\xEE\xED-\xEE\xEE"
	. 	"\xFC\x4C-\xFC\xFC") ],
);

sub sp { grep /\w/, split '', shift }

my @cls =		   sp q(nrftvsSbc-pqdulDUL-GQCRHKhk-JZYPB-NIX);
my %res = (
 '[\x20-\x7F\xA1-\xDF]' =>[sp q(000001010-11111000-00000011-00000-000)],
 '[^\x20-\x7F\xA1-\xDF]'=>[sp q(111110101-00000111-11111100-11111-111)],
 '\p{X0201}'		=>[sp q(111111011-11111000-00000011-00000-000)],
 '\P{X0201}'		=>[sp q(000000100-00000111-11111100-11111-111)],
 '\p{X0208}'		=>[sp q(000000100-00000111-11111100-11111-000)],
 '\P{X0208}'		=>[sp q(111111011-11111000-00000011-00000-111)],

 '\p{JIS}' 		=>[sp q(111111111-11111111-11111111-11111-000)],
 '\pJ'			=>[sp q(111111111-11111111-11111111-11111-000)],
 '[[:jis:]]'		=>[sp q(111111111-11111111-11111111-11111-000)],
 '[[:x0201:][:x0208:]]' =>[sp q(111111111-11111111-11111111-11111-000)],
 '[\p{X0201}\p{X0208}]' =>[sp q(111111111-11111111-11111111-11111-000)],
 '[\p{Print}\p{Cntrl}]' =>[sp q(111111111-11111111-11111111-11111-000)],
 '[\pT\pC]'		=>[sp q(111111111-11111111-11111111-11111-000)],
 '\P{JIS}'		=>[sp q(000000000-00000000-00000000-00000-111)],
 '\PJ'			=>[sp q(000000000-00000000-00000000-00000-111)],
 '[[:^JIS:]]'		=>[sp q(000000000-00000000-00000000-00000-111)],
 '[^[:x0201:][:x0208:]]'=>[sp q(000000000-00000000-00000000-00000-111)],
 '[^\p{X0201}\p{X0208}]'=>[sp q(000000000-00000000-00000000-00000-111)],
 '[^\p{Print}\p{Cntrl}]'=>[sp q(000000000-00000000-00000000-00000-111)],
 '[^\pT\pC]'		=>[sp q(000000000-00000000-00000000-00000-111)],

 '\p{NEC}'		=>[sp q(000000000-00000000-00000000-00000-100)],
 '\pN'			=>[sp q(000000000-00000000-00000000-00000-100)],
 '\P{NEC}' 		=>[sp q(111111111-11111111-11111111-11111-011)],
 '\PN'			=>[sp q(111111111-11111111-11111111-11111-011)],
 '\p{IBM}'		=>[sp q(000000000-00000000-00000000-00000-010)],
 '\pI'			=>[sp q(000000000-00000000-00000000-00000-010)],
 '[\x{fa40}-\x{fc4b}]'	=>[sp q(000000000-00000000-00000000-00000-010)],
 '\P{IBM}' 		=>[sp q(111111111-11111111-11111111-11111-101)],
 '\PI'			=>[sp q(111111111-11111111-11111111-11111-101)],
 '[^\x{fa40}-\x{fc4b}]'	=>[sp q(111111111-11111111-11111111-11111-101)],
 '\p{Vendor}'		=>[sp q(000000000-00000000-00000000-00000-110)],
 '\pV'			=>[sp q(000000000-00000000-00000000-00000-110)],
 '\P{Vendor}' 		=>[sp q(111111111-11111111-11111111-11111-001)],
 '\PV'			=>[sp q(111111111-11111111-11111111-11111-001)],
 '\p{MSWin}' 		=>[sp q(111111111-11111111-11111111-11111-110)],
 '[\pJ\pN\pI]' 		=>[sp q(111111111-11111111-11111111-11111-110)],
 '\P{MSWin}'		=>[sp q(000000000-00000000-00000000-00000-001)],
 '\PM'			=>[sp q(000000000-00000000-00000000-00000-001)],

 '\p{Latin}'		=>[sp q(000000000-00011000-00000000-00000-000)],
 '[A-Za-z]'		=>[sp q(000000000-00011000-00000000-00000-000)],
 '\P{Latin}'		=>[sp q(111111111-11100111-11111111-11111-111)],
 '[^A-Za-z]'		=>[sp q(111111111-11100111-11111111-11111-111)],
 '\p{FullLatin}'	=>[sp q(000000000-00000011-00000000-00000-000)],
 '[`-y-]'		=>[sp q(000000000-00000011-00000000-00000-000)],
 '\P{FullLatin}'	=>[sp q(111111111-11111100-11111111-11111-111)],
 '[^`-y-]'	=>[sp q(111111111-11111100-11111111-11111-111)],
 '\p{Greek}'		=>[sp q(000000000-00000000-11000000-00000-000)],
 '[--]'		=>[sp q(000000000-00000000-11000000-00000-000)],
 '(?I)[-]'		=>[sp q(000000000-00000000-11000000-00000-000)],
 '[-]'		=>[sp q(000000000-00000000-10000000-00000-000)],
 '[-]'		=>[sp q(000000000-00000000-01000000-00000-000)],
 '\P{Greek}'		=>[sp q(111111111-11111111-00111111-11111-111)],
 '[^--]'	=>[sp q(111111111-11111111-00111111-11111-111)],
 '(?I)[^-]'		=>[sp q(111111111-11111111-00111111-11111-111)],
 '\p{Cyrillic}'		=>[sp q(000000000-00000000-00110000-00000-000)],
 '[@-`p-]'		=>[sp q(000000000-00000000-00110000-00000-000)],
 '\P{Cyrillic}'		=>[sp q(111111111-11111111-11001111-11111-111)],
 '[^@-`p-]'	=>[sp q(111111111-11111111-11001111-11111-111)],
 '(?I)[@-`]'		=>[sp q(000000000-00000000-00110000-00000-000)],
 '[@-`]'		=>[sp q(000000000-00000000-00100000-00000-000)],
 '[p-]'		=>[sp q(000000000-00000000-00010000-00000-000)],
 '\p{European}' 	=>[sp q(000000000-00011011-11110000-00000-000)],
 '\P{European}'		=>[sp q(111111111-11100100-00001111-11111-111)],
 '\p{HalfKana}'		=>[sp q(000000000-00000000-00000001-00000-000)],
 '[\xA6-\xDF]'		=>[sp q(000000000-00000000-00000001-00000-000)],
 '\P{HalfKana}'		=>[sp q(111111111-11111111-11111110-11111-111)],
 '[^\xA6-\xDF]'		=>[sp q(111111111-11111111-11111110-11111-111)],
 '\p{Hiragana}'		=>[sp q(000000000-00000000-00001000-00000-000)],
 '\pH'			=>[sp q(000000000-00000000-00001000-00000-000)],
 '[-JKTU]'	=>[sp q(000000000-00000000-00001000-00000-000)],
 '\P{Hiragana}'		=>[sp q(111111111-11111111-11110111-11111-111)],
 '\PH'			=>[sp q(111111111-11111111-11110111-11111-111)],
 '[^-JKTU]'	=>[sp q(111111111-11111111-11110111-11111-111)],
 '\p{Katakana}'		=>[sp q(000000000-00000000-00000100-00000-000)],
 '\pK'			=>[sp q(000000000-00000000-00000100-00000-000)],
 '[@-[RS]'	=>[sp q(000000000-00000000-00000100-00000-000)],
 '\P{Katakana}'		=>[sp q(111111111-11111111-11111011-11111-111)],
 '\PK'			=>[sp q(111111111-11111111-11111011-11111-111)],
 '[^@-[RS]'	=>[sp q(111111111-11111111-11111011-11111-111)],
 '\p{FullKana}'		=>[sp q(000000000-00000000-00001100-00000-000)],
 '[\pH\pK]'		=>[sp q(000000000-00000000-00001100-00000-000)],
 '\P{FullKana}'		=>[sp q(111111111-11111111-11110011-11111-111)],
 '[^\pH\pK]'		=>[sp q(111111111-11111111-11110011-11111-111)],
 '\p{Kana}'		=>[sp q(000000000-00000000-00001101-00000-000)],
 '\P{Kana}'		=>[sp q(111111111-11111111-11110010-11111-111)],
 '\p{kanji0}'		=>[sp q(000000000-00000000-00000000-00100-000)],
 '[V-Z]'		=>[sp q(000000000-00000000-00000000-00100-000)],
 '\P{kanji0}'		=>[sp q(111111111-11111111-11111111-11011-111)],
 '[^V-Z]'		=>[sp q(111111111-11111111-11111111-11011-111)],
 '\p{Kanji1}'		=>[sp q(000000000-00000000-00000000-10000-000)],
 '[-r]'		=>[sp q(000000000-00000000-00000000-10000-000)],
 '\P{Kanji1}'		=>[sp q(111111111-11111111-11111111-01111-111)],
 '[^-r]'		=>[sp q(111111111-11111111-11111111-01111-111)],
 '\p{Kanji2}'		=>[sp q(000000000-00000000-00000000-01000-000)],
 '[-]'		=>[sp q(000000000-00000000-00000000-01000-000)],
 '\P{Kanji2}'		=>[sp q(111111111-11111111-11111111-10111-111)],
 '[^-]'		=>[sp q(111111111-11111111-11111111-10111-111)],
 '\p{Kanji}'		=>[sp q(000000000-00000000-00000000-11100-000)],
 '[\p0\p1\p2]'		=>[sp q(000000000-00000000-00000000-11100-000)],
 '\P{Kanji}'		=>[sp q(111111111-11111111-11111111-00011-111)],
 '[^\p0\p1\p2]'		=>[sp q(111111111-11111111-11111111-00011-111)],
 '\p{BoxDrawing}'	=>[sp q(000000000-00000000-00000000-00001-000)],
 '\P{BoxDrawing}'	=>[sp q(111111111-11111111-11111111-11110-111)],
);

printf "1..%d\n", keys(%res) * keys(%char);

my($mod,$OK,$r,$cl);
for $r (sort keys %res){
  print "$r\n" if ! $HARNESS;

  my $re = "^$r\$";
  for $cl (0..$#cls){
    my $match = grep(match($_, $re, 'o'), @{ $char{ $cls[ $cl ] } });
    my $a = $match == @{ $char{ $cls[ $cl ] } } ? 1 : $match == 0 ? 0 : -1;

    my $msg = $a == $res{ $r }[$cl] ? "ok" : "not ok";
    ++$n;

    print "$msg $n\n";

    push @NG, "$n$r $cls[ $cl ]\n" if ! $HARNESS and $msg ne 'ok';
  }
}

if(! $HARNESS){
  printf "version: $]\ntime: %d\n", time - $time;
  print ! @NG
    ? "All tests successful.\n"
    : "Failed ".scalar(@NG).", tests.\n", @NG;
}

__END__
