# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

BEGIN { $| = 1; print "1..10\n"; }
END {print "not ok 1\n" unless $loaded;}
use ShiftJIS::Regexp qw(:all);
$loaded = 1;
print "ok 1\n";

######################### End of black magic.

print !match("Perl", "perl")
   &&  match("PERL", '^(?i)perl$')
   &&  match("PErl", '^perl$', 'i')
   &&  match("PerluK", '^perluK$', 'i')
   && !match("Perluk", '^perluK$', 'i')
   && !match('G', 'g', 'i')
   && !match('G', '(?i)g')
   &&
 ( $] < 5.005 || 
       match("PerluK", '^(?i:perluK)$')
   && !match("Perluk", '^(?i:perluK)$')
 )
   &&  match("^]Ƌ", "^]")
   && !match("J", "|bg")
   && !match("J", "[]")
   &&  match("J", "[]", 'j')
   &&  match('炭{', '', 'j')
   &&  match('炭{', '(?j)')
   &&  match('炭{', '^(?j)')
   &&  match('炭{', '\A(?j)')
   &&  match('炭{', '\G(?j)')
   &&  match("U", "JS", 'j')
   &&  match("U", "(?j)JS")
   &&  match("͂o", "", 'I')
   &&  match("Ã", "΃Ãσ", 'I')
   &&  match("Ã", "(?I)΃Ãσ", 'j')
   &&  match('W\', qw/\\ /)
   && !match('@@ ==@', '@')
   &&  match('', '')
   &&  join('', match("\n", '(^\j*)')) eq "\n"
   &&  join('', match("\n", '(^\J*)')) eq ""
   &&  join('', match("\n", '(^\C\C{2})')) eq "\n"
   &&  join('', match("ABCD", '(^\J\C)')) eq "A"
   &&  join('', match("\xff\xe0", '(^\C\J)')) eq "\xff"
   &&  match('AaA', '^\j{6}$')
   &&  match('AaA', '^\j{6}$', 's')
   &&  match('AaA', '^\j{6}$', 'm')
   &&  match('AaA'."\n", '^\j{6}$')
   &&  match('AaA'."\n", '^\j{6}$', 's')
   &&  match('AaA'."\n", '^\j{6}$', 'm')
   &&  match('\', <<'HERE', 'x')
^\ .$
HERE
    ? "ok" : "not ok", " 2\n";

print  match('\@', '@$')
   && !match('\@', '^@$')
   &&  match('@', '^\@$')
   &&  match('@', '^\x{8140}$')
   &&  match('', '^\x{82A0}$')
   &&  match('', '^[\x81\xfc-\x83\x40]$')
   &&  match(' ',  '^\x20$')
   &&  match('  ',  '^ \040	\ $	 ','x')
   && !match("a b",  'a b', 'x')
   &&  match("ab",  'a b', 'x')
   &&  match("ab",  '(?iIjx)  a  b  ')
   &&  match("a b",  'a\ b', 'x')
   &&  match("a b",  'a[ ]b', 'x')
   &&  match("\0",  '^\0$')
    ? "ok" : "not ok", " 3\n";

print  match('--\\--', '\\\\')
   &&  match('', '^..{3}$')
   &&  match('', '^{3}$')
   &&  match('', '^+{3}$')
   &&  match('ACEEE', '^ACE{3}$')
   &&  match('ACEEE', '^ACE{3}$', 'i')
   && !match('ACCEEE', '^ACcE{3}$')
   && !match('', '^ACcE{3}$')
   &&  match("aaa\x1Caaa", '[\c\]')
   &&  match('ACCEEE', '^ACcE{3}$', 'i')
   &&  match("09", '^\p{Hiragana}{3}\p{Digit}{2}$')
   &&
 ( $] < 5.005 || match "PQ", '(?<=\p{InHiragana}{2})\p{IsDigit}{2}') 
    ? "ok" : "not ok", " 4\n";

my $str = "!--00";

print "!--00" eq replace($str, '[\p{Hiragana}]', '\x{8194}', 'g')
   && "!--00" eq replace($str, '\p{InHiragana}', '')
   && "\\0\\0" eq replace("\0\0",'\0', '\\\\0', 'g')
   && "!--00"
	 eq replace($str,'(\p{InHiragana}+)', '${1}${1}', 'g')
   && "!--00"
	 eq replace($str,'(\p{InHiragana}+)', '${1}${1}')
   && "=}~=" eq replace('{}~}', '\{|\}', '=', 'g')
   && "\n\n" eq replace("\0\0",'\0', '\n', 'g')
   && '' eq (match("o",   '(\J)\Z'))[0]
   && '' eq (match("o\n", '(\J)\Z'))[0]
   && "\n" eq (match("o\n", '(\j)\z'))[0]
   && '' eq (match("o",   '(\j)\z'))[0]
   && '`' eq (match("}b`",   '(\j)\z'))[0]
   && '' eq (match('@낤', '(\P{Space}+)\p{Space}*\1'))[0]
   && 'EE' eq replace('EE', 'E', 'E', 'g')
   && "a bDC123" eq replace("a b\n123", '$ \j', "DC", 'mx')
   && "a bDC123" eq replace("a b\n123", '$\j', "DC", 'm')
    ? "ok" : "not ok", " 5\n";

print '::^' eq join(':', jsplit('^', '^^^'))
   && ':@:@^' 
	eq join(':', jsplit('\p{IsSpace}+', '  @@@^', 3))
   && join('-;-', jsplit('\|', 'Ƀ|}[hGL||||| A|'))
	eq 'Ƀ|}[hGL-;-||-;--;- A|'
   && join('-', jsplit('|+', 'Ƀ|}[hGL||| A|', 3))
	eq '-}[hGL|- A|'
   && join('-:-', jsplit('(^)', 'Perl^vO^pX[h'))
	eq 'Perl-:-^-:-vO-:-^-:-pX[h'
   && join('-:-', jsplit('(?j)(}c)', '܂܂₠܂܂܂܂'))
	eq '-:-܂-:-܂₠-:-܂-:-܂-:-܂-:-܂'
   && join('-:-', jsplit('(?j)+', 'A݂'))
	eq '-:-A-:-݂'
    ? "ok" : "not ok", " 6\n";

{
  local $^W = 0;
  my($asc,$ng,$re);
  $asc = "\0\x01\a\e\n\r\t\f"
	. q( !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ)
	. q([\]^_`abcdefghijklmnopqrstuvwxyz{|}~)."\x7F";

  for $re('[\d]', '[^\s]', '[^!2]', '[^#-&]',
	'[^\/]', '[[-\\\\]', '[a-~]', '[\a-\e]',
	'[\a-\b]', '[\a-\v]', '[!-@[-^`{-~]',
	'[\C]', '[\j]', '[\J]',
  ){
    my $str = $asc;
    my $sjs = replace($str, $re, qw/ g/);
    $str =~ s/$re//g;
    $ng++ if $sjs ne $str;
  }
  print !$ng ? "ok" : "not ok", " 7\n";
}

{
  my $str = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz123456789+-=";
  my $zen = "`abcdefghiOPQRS";
  my $jpn = "ACEGIJLNPROPQRS";
  my $perl = "odqkperlPERLςpA";
 print 1
   && "**CDEFGHIJKLMNO****TUVWXY***cdefghijklmno****tuvwxy*123456789+-="
       eq replace($str, '[abp-sz]', '*', 'ig')
   && "***DEFGHIJKLMNOPQRSTUVWXYZ***defghijklmnopqrstuvwxyz123456789+-="
       eq replace($str, '[abc]', '*', 'ig')
   && "**CDEFGHIJKLMNOPQRSTUVW*****cdefghijklmnopqrstuvw***123456789+-="
       eq replace($str, '[a-a_b-bx-z]', '*', 'ig')
   && "ABCDEFGHI*KLMNOPQRSTUVWXYZabcdefghi*klmnopqrstuvwxyz123456789+-="
       eq replace($str, '\c*', '*', 'ig')
   && "*BCDEFGHIJKLMNOPQRSTUVWXYZ*bcdefghijklmnopqrstuvwxyz*********+-*"
       eq replace($str, '[0-A]', '*', 'ig')
   && "*************************************************************+-*"
       eq replace($str, '[0-a]', '*', 'ig')
   && "****E******L***P*R************e******l***p*r********************"
       eq replace($str, '[^perl]', '*', 'ig')
   && "AGILNPROPQRS"
       eq replace($jpn, '[]', '', 'jg')
   && "dqprlPRLρp"
       eq replace($perl, '[ek]', '', 'iIjg')
   && "odqprlPRLρp"
       eq replace($perl, '[ek]', '', 'ijg')
    ? "ok" : "not ok", " 8\n";
}

print 1
  && '##-##-##[' eq
    replace('-ٶ-JK[', '[[==]]', '#', 'g')
  &&  match('{', '[[==]][[={=]]')
  &&  match('Prk', '^[[=p=]][[=d=]][[==]][[=L=]]$')
  &&  match('[a]', '^[[=[=]][[=\x41=]][[=]=]]$')
  &&  match('-m`n', '.[[=[=]][[=\x61=]][[=]=]]$')
   ? "ok" : "not ok", " 9\n";

print $] < 5.005 ||
 ( 
   "#\n#\n#a\n#bb\n#\n#cc\n#dd"
      eq replace("\n\na\nbb\n\ncc\ndd", '^', '#', 'mg')
   && 'ZACEGZAZACEZAA'
      eq replace('ACEGAACEAA', '(?=A)', 'Z', 'gz')
   && 'Z1Z2Z3Z1Z2Z3Z'
      eq replace('0123000123', '0*', 'Z', 'g')
 )
   ? "ok" : "not ok", " 10\n";
