package HTML::Entitize;

#use strict;
use warnings;

use HTML::Entities;
use Tie::Function;

our $VERSION = '1.00';

# -----------------------------------------------

tie my %Entitize, 'Tie::Function' => \&encode_entities;

sub import{*{caller().'::Entitize'} = \%Entitize};

# -----------------------------------------------

1;

__END__

=head1 NAME

C<HTML::Entitize> - Call HTML::Entities::encode_entities, via a hash, within a string

=head1 Synopsis

	use HTML::Entitize;

	print qq{<input name="data" value="$Entitize{$old_data}">\n};

	print qq{The full text of the block is <pre>$Entitize{$block}</pre>\n};

	print $Entitize{<<EOF};
	Check out the web page at http://tipjar.com/bin/test?foo=bar&reg=inald
	EOF

=head1 Description

C<DBIx::Admin::Entitize> is a pure Perl module.

=head1 Constructor and initialization

Not needed.

=head1 Required Modules

=over 4

=item HTML::Entities

=item Tie::Function

=back

=head1 Author

David Nicol <davidnicol@gmail.com>.

=cut
