BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( base constant strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.010001; 1}) {
    print "Perl 5.010001 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.75.
use strict;
use warnings;
use 5.010001;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Some Perl::Critic policies used by Plicease",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME"         => "Perl-Critic-Plicease",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.010001",
  "NAME"             => "Perl::Critic::Plicease",
  "PM"               => {
    "lib/Perl/Critic/Plicease.pm"                                          => "\$(INST_LIB)/Perl/Critic/Plicease.pm",
    "lib/Perl/Critic/Policy/Plicease/ProhibitLeadingZeros.pm"              => "\$(INST_LIB)/Perl/Critic/Policy/Plicease/ProhibitLeadingZeros.pm",
    "lib/Perl/Critic/Policy/Plicease/ProhibitSignaturesAndAtUnderscore.pm" => "\$(INST_LIB)/Perl/Critic/Policy/Plicease/ProhibitSignaturesAndAtUnderscore.pm",
    "lib/Perl/Critic/Policy/Plicease/ProhibitSpecificModules.pm"           => "\$(INST_LIB)/Perl/Critic/Policy/Plicease/ProhibitSpecificModules.pm",
    "lib/Perl/Critic/Policy/Plicease/ProhibitUnicodeDigitInRegexp.pm"      => "\$(INST_LIB)/Perl/Critic/Policy/Plicease/ProhibitUnicodeDigitInRegexp.pm"
  },
  "PREREQ_PM" => {
    "PPIx::Regexp"         => 0,
    "Perl::Critic::Policy" => 0,
    "Perl::Critic::Utils"  => 0
  },
  "TEST_REQUIRES" => {
    "Test2::V0"                  => "0.000121",
    "Test::Perl::Critic::Policy" => 0
  },
  "VERSION" => "0.06",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "PPIx::Regexp"               => 0,
  "Perl::Critic::Policy"       => 0,
  "Perl::Critic::Utils"        => 0,
  "Test2::V0"                  => "0.000121",
  "Test::Perl::Critic::Policy" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);