import javax.swing.event.MenuListener;
import org.perl.inline.java.*;

public class      PerlMenuListener
       extends    InlineJavaPerlCaller
       implements MenuListener
{
    String sender;
    String callbacks;

    public PerlMenuListener(String sender, String callbacks)
        throws InlineJavaException
    {
        this.sender    = sender;
        this.callbacks = callbacks;
    }

    public void menuSelected(javax.swing.event.MenuEvent event)  {
        try {
            CallPerl(
                "Java::Swing::MenuListener",
                "_MenuListener",
                new Object[] {sender, callbacks, "menuSelected", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void menuDeselected(javax.swing.event.MenuEvent event)  {
        try {
            CallPerl(
                "Java::Swing::MenuListener",
                "_MenuListener",
                new Object[] {sender, callbacks, "menuDeselected", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void menuCanceled(javax.swing.event.MenuEvent event)  {
        try {
            CallPerl(
                "Java::Swing::MenuListener",
                "_MenuListener",
                new Object[] {sender, callbacks, "menuCanceled", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
}
