import java.awt.event.KeyListener;
import org.perl.inline.java.*;

public class      PerlKeyListener
       extends    InlineJavaPerlCaller
       implements KeyListener
{
    String sender;
    String callbacks;

    public PerlKeyListener(String sender, String callbacks)
        throws InlineJavaException
    {
        this.sender    = sender;
        this.callbacks = callbacks;
    }

    public void keyTyped(java.awt.event.KeyEvent event) {
        try {
            CallPerl(
                "Java::Swing::KeyListener",
                "_KeyListener",
                new Object[] {sender, callbacks, "keyTyped", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void keyPressed(java.awt.event.KeyEvent event) {
        try {
            CallPerl(
                "Java::Swing::KeyListener",
                "_KeyListener",
                new Object[] {sender, callbacks, "keyPressed", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void keyReleased(java.awt.event.KeyEvent event) {
        try {
            CallPerl(
                "Java::Swing::KeyListener",
                "_KeyListener",
                new Object[] {sender, callbacks, "keyReleased", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
}
