package API::MailboxOrg::API::Videochat;

# ABSTRACT: MailboxOrg::API::Videochat

# ---
# This class is auto-generated by bin/get_mailbox_api.pl
# ---

use v5.24;

use strict;
use warnings;

use Moo;
use Types::Standard qw(Enum Str Int);
use Params::ValidationCompiler qw(validation_for);

extends 'API::MailboxOrg::APIBase';

with 'MooX::Singleton';

use feature 'signatures';
no warnings 'experimental::signatures';

our $VERSION = '1.0.0'; # VERSION

my %validators = (
    'add' => validation_for(
        params => {
            mail      => { type => Str, optional => 0 },
            room_name => { type => Str, optional => 0 },
            room_memo => { type => Str, optional => 1 },

        },
    ),
    'del' => validation_for(
        params => {
            mail    => { type => Str, optional => 0 },
            room_id => { type => Int, optional => 0 },

        },
    ),
    'list' => validation_for(
        params => {
            mail => { type => Str, optional => 0 },

        },
    ),
    'update' => validation_for(
        params => {
            mail                => { type => Str, optional => 0 },
            room_id             => { type => Int, optional => 0 },
            room_name           => { type => Str, optional => 1 },
            room_password       => { type => Str, optional => 1 },
            room_admin_password => { type => Str, optional => 1 },
            room_memo           => { type => Str, optional => 1 },

        },
    ),

);


sub add ($self, %params) {
    my $validator = $validators{'add'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'mail.videochat.add', \%params, \%opt );
}

sub del ($self, %params) {
    my $validator = $validators{'del'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'mail.videochat.del', \%params, \%opt );
}

sub list ($self, %params) {
    my $validator = $validators{'list'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'mail.videochat.list', \%params, \%opt );
}

sub update ($self, %params) {
    my $validator = $validators{'update'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'mail.videochat.update', \%params, \%opt );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

API::MailboxOrg::API::Videochat - MailboxOrg::API::Videochat

=head1 VERSION

version 1.0.0

=head1 SYNOPSIS

    use API::MailboxOrg;

    my $user     = '1234abc';
    my $password = '1234abc';

    my $api      = API::MailboxOrg->new(
        user     => $user,
        password => $password,
    );

=head1 METHODS

=head2 add

Add a new video channel for an e-mail address

Available for admin, account, domain, mail

Parameters:

=over 4

=item * mail

=item * room_name

=item * room_memo

=back

returns: boolean

    $api->videochat->add(%params);

=head2 del

Delete a video channel from an e-mail address

Available for admin, account, domain, mail

Parameters:

=over 4

=item * mail

=item * room_id

=back

returns: boolean

    $api->videochat->del(%params);

=head2 list

List all video channels from an e-mail address

Available for admin, account, domain, mail

Parameters:

=over 4

=item * mail

=back

returns: array

    $api->videochat->list(%params);

=head2 update

Update a video channel for an e-mail address

Available for admin, account, domain, mail

Parameters:

=over 4

=item * mail

=item * room_id

=item * room_name

=item * room_password

=item * room_admin_password

=item * room_memo

=back

returns: boolean

    $api->videochat->update(%params);

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2022 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
