package SQL::Statement::Functions::MinMax;

our $DATE = '2017-01-25'; # DATE
our $VERSION = '0.001'; # VERSION

1;
# ABSTRACT: More date/time functions

__END__

=pod

=encoding UTF-8

=head1 NAME

SQL::Statement::Functions::MinMax - More date/time functions

=head1 VERSION

This document describes version 0.001 of SQL::Statement::Functions::MinMax (from Perl distribution SQL-Statement-Functions-MinMax), released on 2017-01-25.

=head1 DESCRIPTION

This distribution contains several SQL functions to be used with
L<SQL::Statement>:

 MAXNUM()
 MAXSTR()
 MINNUM()
 MINSTR()

These functions are added due to the lack of CASE statement as well as IF
function in SQL::Statement. For example, this SQL statement:

 SELECT CASE WHEN a > b THEN a ELSE b END FROM table

can be expressed with:

 SELECT MAXNUM(a, b) FROM table

To use a function from Perl script:

 require SQL::Statement::Function::ByName::MAXNUM;
 $dbh->do(qq{CREATE FUNCTION MAXNUM NAME "SQL::Statement::Function::ByName::MAXNUM::MAXNUM"});

To use a function from L<fsql>:

 % fsql -F MAXNUM --add-csv path/to/sometable.csv "SELECT MAXNUM(col1,col2) FROM sometable ..."

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/SQL-Statement-Functions-MinMax>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-SQL-Statement-Functions-MinMax>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=SQL-Statement-Functions-MinMax>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<SQL::Statement>

L<App::fsql>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
